/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.server;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.ioengine.game.server.ChattingAI;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.server.Agent;
import com.iosoft.secag.server.GameServer;
import com.iosoft.secag.server.SecAgData;
import com.iosoft.secag.server.SecAgPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AI
extends ChattingAI<SecAgPlayer, SecAgData> {
    private final Log.Category Log = new Log.Category("AI");
    private final Map<SecAgPlayer, PlayerEntry> players = new HashMap<SecAgPlayer, PlayerEntry>();
    private int[] movement;
    private Agent[] agents;
    private final List<Agent> movedAgents = new ArrayList<Agent>();
    private int dice;

    private boolean isDebug() {
        return ((SecretAgents)((GameServer)((SecAgPlayer)this.getPlayer()).getServer()).Game).isDevmode();
    }

    @Override
    protected void onGameStarted() {
        super.onGameStarted();
        this.players.clear();
        SecAgPlayer me = (SecAgPlayer)this.getPlayer();
        for (SecAgPlayer player : ((SecAgData)this.getData()).enumerateConnectedPlayers(x -> x != me)) {
            this.players.put(player, new PlayerEntry(player));
        }
    }

    @Override
    protected void onPlayerAdded(SecAgPlayer player) {
        if (player != this.getPlayer()) {
            this.players.put(player, new PlayerEntry(player));
        }
    }

    @Override
    protected void onPlayerRemoved(SecAgPlayer player) {
        this.players.remove(player);
    }

    private PlayerEntry getOtherPlayer(SecAgPlayer player) {
        return player == this.getPlayer() ? null : this.players.get(player);
    }

    public void notifySafeEvent(SecAgPlayer player, int[] points) {
        PlayerEntry playerEntry = this.getOtherPlayer(player);
        if (playerEntry != null) {
            playerEntry.addPoints(points);
        }
    }

    public void notifyMoveEvent(SecAgPlayer player, int[] results) {
        PlayerEntry playerEntry = this.getOtherPlayer(player);
        if (playerEntry == null) {
            return;
        }
        SecAgData data = (SecAgData)this.getData();
        this.agents = data.getAgents();
        int[] scores = new int[this.agents.length];
        int i = 0;
        while (i < results.length) {
            int posStart = this.agents[i].getPos();
            int newPos = posStart + results[i];
            int valStart = data.getHouseScore(posStart);
            int valNew = data.getHouseScore(newPos %= 12);
            if (newPos == 11) {
                if (posStart == 11) {
                    int n = i;
                    scores[n] = scores[n] - 4;
                } else {
                    int n = i;
                    scores[n] = scores[n] - 6;
                }
            }
            if (valNew > valStart) {
                int n = i;
                scores[n] = scores[n] + (valNew - valStart) * 2;
            } else if (valNew < valStart) {
                int n = i;
                scores[n] = scores[n] - (valStart - valNew);
                if (newPos != 11) {
                    int n2 = i;
                    scores[n2] = scores[n2] + 3;
                }
            }
            ++i;
        }
        playerEntry.addPoints(scores);
    }

    private static void tryAddGoodMove(List<Integer> goodMoves, int score, int times, int path) {
        if (score >= 0) {
            goodMoves.add(path);
            int i = 0;
            while (i < times) {
                goodMoves.add(path);
                ++i;
            }
        }
    }

    private boolean shouldHurt(Agent a) {
        Agent agent = ((SecAgPlayer)this.getPlayer()).getAgent();
        if (a == agent) {
            return false;
        }
        int pnts = a.getPoints();
        if (pnts < 8) {
            return false;
        }
        int pointDif = pnts - agent.getPoints();
        if (pointDif < -10) {
            return false;
        }
        if (pointDif > 4) {
            return true;
        }
        return this.getProbabilityForBeingADetectedPlayer(a) > 0.5;
    }

    private double getProbabilityForBeingADetectedPlayer(Agent a) {
        Agent agent = ((SecAgPlayer)this.getPlayer()).getAgent();
        if (a == agent) {
            return 1.0;
        }
        return this.players.values().stream().mapToDouble(x -> x.getProbabilityForBeing(a)).sum();
    }

    private boolean tryToHurt(Agent enemy) {
        int needed = enemy.getPath(11);
        if (needed <= this.dice) {
            if (this.isDebug()) {
                this.Log.info("Hurt: Agent " + enemy.Nr + ", cost: " + needed);
            }
            this.movement[enemy.Nr] = needed;
            this.dice -= needed;
            return true;
        }
        return false;
    }

    private void addEnemies(List<Agent> list) {
        Agent agent = ((SecAgPlayer)this.getPlayer()).getAgent();
        int iC = this.agents.length;
        int i = 0;
        while (i < iC) {
            Agent a = this.agents[i];
            if (a != agent) {
                list.add(a);
            }
            ++i;
        }
    }

    private void tryScoring() {
        SecAgData data = (SecAgData)this.getData();
        ArrayList<ScoreSolution> list = new ArrayList<ScoreSolution>();
        int i = 0;
        while (i < this.agents.length) {
            ScoreSolution ss;
            Agent a = this.agents[i];
            int p = a.getPath(data.getSafeHouse());
            if (p > 0 && p <= this.dice && (ss = new ScoreSolution(a, p)).acceptable) {
                list.add(ss);
            }
            ++i;
        }
        list.sort(Comparator.comparingInt(ScoreSolution::getMaxScoreGain));
        if (!list.isEmpty()) {
            ScoreSolution ss;
            if (this.isDebug()) {
                this.Log.info("Scoring: ScoreSolutions: " + list.size());
            }
            if ((ss = (ScoreSolution)list.get(list.size() - 1)).maxScoreGain > 0 && ss.randomYes()) {
                if (this.isDebug()) {
                    this.Log.info("Scoring: MaxScoreGain: " + ss.maxScoreGain + " @ " + ss.maxScoreGainHouse);
                }
                int n = ((ScoreSolution)ss).onSafe.Nr;
                this.movement[n] = this.movement[n] + ss.onSafe.getPath(data.getSafeHouse());
                this.dice -= ss.onSafe.getPath(data.getSafeHouse());
                if (this.isDebug()) {
                    this.Log.info("Scoring: Safer " + ((ScoreSolution)ss).onSafe.Nr);
                }
                if (ss.endsGame && this.isDebug()) {
                    this.Log.info("Scoring: !!! This will end the game !!!");
                }
                if (!ss.selfSafer) {
                    Agent agent = ((SecAgPlayer)this.getPlayer()).getAgent();
                    if (ss.endsGame) {
                        if (this.isDebug()) {
                            this.Log.info("Scoring: Scoring as many points as possible!");
                        }
                        int n2 = agent.Nr;
                        this.movement[n2] = this.movement[n2] + agent.getPath(ss.maxScoreGainHouse);
                        this.dice -= agent.getPath(ss.maxScoreGainHouse);
                    } else {
                        int possibleGoodMove = ss.possibleGoodMoves[Misc.getRandomInt(ss.possibleGoodMoves.length)];
                        int n3 = agent.Nr;
                        this.movement[n3] = this.movement[n3] + possibleGoodMove;
                        this.dice -= possibleGoodMove;
                        if (this.isDebug()) {
                            this.Log.info("Scoring: Movin' goodly: " + possibleGoodMove + " from " + ss.possibleGoodMoves.length);
                        }
                    }
                }
                ArrayList<Agent> enemies = new ArrayList<Agent>();
                this.addEnemies(enemies);
                enemies.remove(ss.onSafe);
                enemies.sort(Comparator.comparingInt(x -> -x.getPoints()));
                int iC = enemies.size();
                int i2 = 0;
                while (i2 < iC) {
                    Agent e = (Agent)enemies.get(i2);
                    if (this.shouldHurt(e)) {
                        if (this.isDebug()) {
                            this.Log.info("Scoring: Try hurting agent " + e.Nr);
                        }
                        if (this.tryToHurt(e)) {
                            enemies.remove(e);
                            --i2;
                            --iC;
                        }
                    }
                    ++i2;
                }
                enemies.clear();
                this.addEnemies(enemies);
                enemies.remove(ss.onSafe);
                ArrayList<AgentPoint> agentPoints = new ArrayList<AgentPoint>();
                int i3 = 0;
                while (i3 < enemies.size()) {
                    agentPoints.add(new AgentPoint((Agent)enemies.get(i3)));
                    ++i3;
                }
                if (this.isDebug()) {
                    this.Log.info("Dice remaining: " + this.dice);
                }
                while (this.dice > 0) {
                    agentPoints.sort(Comparator.comparingInt(AgentPoint::getValue));
                    AgentPoint ap = (AgentPoint)agentPoints.get(0);
                    Agent e = ap.agent;
                    int n4 = e.Nr;
                    this.movement[n4] = this.movement[n4] + 1;
                    ap.move();
                    --this.dice;
                    if (!this.isDebug()) continue;
                    this.Log.info("Least dangerous is " + e.Nr + " @ " + e.getHouse() + " - " + ap.getValue() + " - " + ap.path);
                }
            }
        }
    }

    private boolean shouldMovePastSafe(Agent a) {
        int safe = ((SecAgData)this.getData()).getSafeHouse();
        int i = 0;
        while (i < this.agents.length) {
            if (this.agents[i] != a && a.getPath(safe) < 5) {
                return false;
            }
            ++i;
        }
        return a.getPath(safe) + 1 <= this.dice;
    }

    private boolean couldHurt(Agent a) {
        int way = a.getPath(11);
        if (way != 0 && way <= this.dice) {
            return true;
        }
        return this.shouldMovePastSafe(a);
    }

    private void tryHurt() {
        MoveAgent ea;
        if (this.dice == 0) {
            return;
        }
        ArrayList<MoveAgent> enemyAgents = new ArrayList<MoveAgent>();
        int iC = this.agents.length;
        int total = 0;
        Agent agent = ((SecAgPlayer)this.getPlayer()).getAgent();
        int i = 0;
        while (i < iC) {
            Agent a = this.agents[i];
            if (a != agent && a.getPoints() >= agent.getPoints() && this.couldHurt(a) && this.shouldHurt(a)) {
                ea = new MoveAgent(a, true);
                enemyAgents.add(ea);
                total += ea.likely;
            }
            ++i;
        }
        if (this.isDebug()) {
            this.Log.info("Hurting: Agents: " + enemyAgents.size() + (!enemyAgents.isEmpty() ? " (" + enemyAgents.stream().map(x -> Integer.toString(((MoveAgent)x).thisAgent.Nr)).collect(Collectors.joining(",")) + ")" : ""));
        }
        iC = enemyAgents.size();
        enemyAgents.sort(Comparator.comparingInt(MoveAgent::getValue));
        if (iC > 0 && !Misc.randomBool(5.0)) {
            int v = Misc.getRandomInt(total);
            int i2 = 0;
            while (i2 < iC) {
                ea = (MoveAgent)enemyAgents.get(i2);
                if (v < ea.likely) {
                    this.hurt(ea.thisAgent);
                    break;
                }
                v -= ea.likely;
                ++i2;
            }
        }
    }

    private void hurt(Agent a) {
        if (!this.tryToHurt(a) && this.shouldMovePastSafe(a)) {
            SecAgData data = (SecAgData)this.getData();
            if (this.isDebug()) {
                this.Log.info("Hurt: Agent " + a.Nr + ", past safe, needed: " + (a.getPath(data.getSafeHouse()) + 1));
            }
            this.movement[a.Nr] = a.getPath(data.getSafeHouse()) + 1;
            this.dice -= this.movement[a.Nr];
        }
    }

    private void trySupport() {
        MoveAgent sa;
        if (this.dice == 0) {
            return;
        }
        ArrayList<MoveAgent> noobAgents = new ArrayList<MoveAgent>();
        int iC = this.agents.length;
        int total = 0;
        Agent agent = ((SecAgPlayer)this.getPlayer()).getAgent();
        int i = 0;
        while (i < iC) {
            Agent a = this.agents[i];
            if (a != agent && a.getPoints() < agent.getPoints() && !this.shouldHurt(a)) {
                sa = new MoveAgent(a, false);
                noobAgents.add(sa);
                total += sa.likely;
            }
            ++i;
        }
        if (this.isDebug()) {
            this.Log.info("Supporting: Agents: " + noobAgents.size());
        }
        iC = noobAgents.size();
        noobAgents.sort(Comparator.comparingInt(MoveAgent::getValue));
        if (iC == 0 && !Misc.randomBool(5.0)) {
            return;
        }
        if (iC == 0 || Misc.randomBool(4.0)) {
            this.support(agent);
        } else {
            int v = Misc.getRandomInt(total);
            int i2 = 0;
            while (i2 < iC) {
                sa = (MoveAgent)noobAgents.get(i2);
                if (v < sa.likely) {
                    this.support(sa.thisAgent);
                    break;
                }
                v -= sa.likely;
                ++i2;
            }
        }
    }

    private void support(Agent a) {
        int use;
        int used = use = Misc.getRandomInt(this.dice) + 1;
        int house = a.getHouse();
        while (use > 0) {
            ++house;
            if ((house %= 12) == 11) break;
            int n = a.Nr;
            this.movement[n] = this.movement[n] + 1;
            --use;
            --this.dice;
        }
        if (this.isDebug()) {
            this.Log.info("Support: Agent " + a.Nr + " | Used: " + (used - use) + " | Had: " + used);
        }
    }

    private void moveWithRest(Agent ... notAgents) {
        if (this.isDebug()) {
            this.Log.info("Moving randomly with " + this.dice + "...");
        }
        ArrayList<Agent> restAgents = new ArrayList<Agent>();
        ArrayList notMyAgents = new ArrayList();
        Collections.addAll(restAgents, this.agents);
        Collections.addAll(notMyAgents, this.agents);
        notMyAgents.remove(((SecAgPlayer)this.getPlayer()).getAgent());
        int i = 0;
        while (i < notAgents.length) {
            restAgents.remove(notAgents[i]);
            ++i;
        }
        int iC = restAgents.size();
        if (iC == 0) {
            restAgents.add((Agent)Misc.getRandom(notMyAgents));
            ++iC;
        }
        while (this.dice > 0) {
            --this.dice;
            int n = ((Agent)Misc.getRandom(restAgents)).Nr;
            this.movement[n] = this.movement[n] + 1;
        }
    }

    public int[] makeMovement() {
        SecAgData data = (SecAgData)this.getData();
        this.agents = data.getAgents();
        this.movement = new int[this.agents.length];
        this.movedAgents.clear();
        this.dice = data.getDice();
        if (this.isDebug()) {
            SecAgPlayer player = (SecAgPlayer)this.getPlayer();
            this.Log.info("------------\nNOW MOVING: " + player.getNr() + ": " + player.getName() + " | Agent: " + player.getAgent().Nr + " | Rolled: " + this.dice);
        }
        this.tryScoring();
        this.tryHurt();
        this.trySupport();
        this.moveWithRest(new Agent[0]);
        if (this.isDebug()) {
            StringBuilder strMove = new StringBuilder();
            strMove.append("We move: ");
            int i = 0;
            while (i < this.movement.length) {
                strMove.append(this.movement[i]);
                strMove.append(' ');
                ++i;
            }
            this.Log.info(strMove.toString());
        }
        return this.movement;
    }

    public int[] getSecretPaperDecision() {
        int[] tips = new int[((SecAgData)this.getData()).getMaxPlayers()];
        Arrays.fill(tips, -1);
        SecAgPlayer me = (SecAgPlayer)this.getPlayer();
        for (PlayerEntry playerEntry : MiscLINQ.iter(this.players.values().stream().sorted(Comparator.comparingInt(x -> -((PlayerEntry)x).getTotal())))) {
            if (playerEntry.player == me) continue;
            tips[((PlayerEntry)playerEntry).player.getNr()] = playerEntry.getAgentTip(tips);
        }
        if (this.isDebug()) {
            this.Log.info("--------------------------------------");
            this.Log.info("SecPap decision for AI " + ((SecAgPlayer)this._player).getNr() + " (" + ((SecAgPlayer)this._player).getName() + ")");
            int i = 0;
            while (i < tips.length) {
                this.Log.info("Player " + i + ": " + tips[i]);
                ++i;
            }
        }
        return tips;
    }

    public void outputScores() {
        SecAgPlayer player = (SecAgPlayer)this.getPlayer();
        this.Log.info("--------------------------------------");
        this.Log.info("Scores for AI " + player.getNr() + " (" + player.getName() + ")");
        for (PlayerEntry playerEntry : this.players.values()) {
            this.Log.info(String.valueOf(Misc.padRight(playerEntry.player.getName(), 16, ' ')) + ": " + playerEntry.getScoreString());
        }
    }

    public int getSafePlacement() {
        return ((SecAgData)this.getData()).getRandomPlaceForSafe();
    }

    @Override
    protected void onChatMessage(SecAgPlayer sender, String msg) {
        if (this.isDebug() && msg.equals("dbg")) {
            this.outputScores();
            return;
        }
        super.onChatMessage(sender, msg);
    }

    public static void fillNames(List<String> randomNames) {
        randomNames.add("John");
        randomNames.add("Andrew");
        randomNames.add("Gerald");
        randomNames.add("Bertram");
        randomNames.add("Quentin");
        randomNames.add("Norbert");
        randomNames.add("Henry");
        randomNames.add("Marcus");
        randomNames.add("Peter");
        randomNames.add("Ivan");
        randomNames.add("Maria");
        randomNames.add("Catherine");
        randomNames.add("Jenny");
        randomNames.add("Kimberley");
        randomNames.add("Nicola");
        randomNames.add("Sarah");
        randomNames.add("Lena");
        randomNames.add("Doris");
        randomNames.add("Veronica");
        randomNames.add("Lindy");
    }

    private class AgentPoint {
        private Agent agent;
        private int path;
        private int value;

        AgentPoint(Agent agent) {
            this.agent = agent;
            this.path = 0;
            this.calc();
        }

        public void move() {
            ++this.path;
            this.calc();
        }

        private void calc() {
            this.value = this.agent.getPoints() + ((SecAgData)AI.this.getData()).getHouseScore((this.agent.getHouse() + this.path) % 12);
        }

        public int getValue() {
            return this.value;
        }
    }

    private class MoveAgent {
        private Agent thisAgent;
        private int likely;

        MoveAgent(Agent a, boolean hurt) {
            this.thisAgent = a;
            this.likely = hurt ? a.getPoints() + 1 : ((SecAgPlayer)AI.this.getPlayer()).getAgent().getPoints() - a.getPoints();
        }

        public int getValue() {
            return -this.likely;
        }
    }

    private class PlayerEntry {
        private SecAgPlayer player;
        private long[] agentPoints;

        PlayerEntry(SecAgPlayer p) {
            this.player = p;
            this.agentPoints = new long[((SecAgData)AI.this.getData()).getAgents().length];
            Arrays.fill(this.agentPoints, 0L);
        }

        public double getProbabilityForBeing(Agent a) {
            long allScore = 0L;
            int i = 0;
            while (i < this.agentPoints.length) {
                allScore += this.getTotalAgentValue(i);
                ++i;
            }
            return (double)this.getTotalAgentValue(a.Nr) / (double)allScore;
        }

        public String getScoreString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.agentPoints.length) {
                boolean isMine;
                if (i > 0) {
                    sb.append('\t');
                }
                boolean bl = isMine = i == ((SecAgPlayer)AI.this.getPlayer()).getAgent().Nr;
                if (isMine) {
                    sb.append('(');
                }
                sb.append(this.agentPoints[i]);
                if (isMine) {
                    sb.append(')');
                }
                ++i;
            }
            return sb.toString();
        }

        public void addPoints(int[] pnts) {
            int i = 0;
            while (i < this.agentPoints.length) {
                if (i != ((SecAgPlayer)AI.this.getPlayer()).getAgent().Nr && (this.agentPoints[i] < 40000L || pnts[i] < 0)) {
                    int n = i;
                    this.agentPoints[n] = this.agentPoints[n] + (long)pnts[i];
                }
                ++i;
            }
        }

        private long getTotalAgentValue(int agent) {
            long n = Math.max(0L, this.agentPoints[agent]);
            return n * n;
        }

        private int getTotal() {
            int t = 0;
            int i = 0;
            while (i < this.agentPoints.length) {
                t = (int)((long)t + this.getTotalAgentValue(i));
                ++i;
            }
            return t;
        }

        private int getAgentTip(int[] tips) {
            boolean[] used = new boolean[this.agentPoints.length];
            used[((SecAgPlayer)AI.this.getPlayer()).getAgent().Nr] = true;
            int i = 0;
            while (i < tips.length) {
                if (tips[i] != -1) {
                    used[tips[i]] = true;
                }
                ++i;
            }
            long totalValue = 0L;
            long[] values = new long[this.agentPoints.length];
            int i2 = 0;
            while (i2 < this.agentPoints.length) {
                if (used[i2]) {
                    values[i2] = 0L;
                } else {
                    values[i2] = this.getTotalAgentValue(i2) + 1L;
                    totalValue += values[i2];
                }
                ++i2;
            }
            long random = Misc.getRandomLong(totalValue);
            int i3 = 0;
            while (i3 < values.length) {
                if ((random -= values[i3]) < 0L) {
                    return i3;
                }
                ++i3;
            }
            throw new RuntimeException("This really should not have happened");
        }
    }

    private class ScoreSolution {
        private Agent onSafe;
        private int pntsForSafe;
        private int pntsLeftover;
        private int maxScoreGain;
        private int maxScoreGainHouse;
        private boolean endsGame;
        private boolean selfSafer;
        private int[] possibleGoodMoves;
        private int[] estimatedProfits;
        private boolean acceptable;

        ScoreSolution(Agent safer, int p) {
            SecAgData data = (SecAgData)AI.this.getData();
            this.acceptable = true;
            this.estimatedProfits = new int[AI.this.agents.length];
            ArrayList goodMoves = new ArrayList();
            this.selfSafer = false;
            this.endsGame = false;
            this.onSafe = safer;
            this.pntsForSafe = p;
            this.pntsLeftover = AI.this.dice - this.pntsForSafe;
            Agent agent = ((SecAgPlayer)AI.this.getPlayer()).getAgent();
            if (safer == agent) {
                this.maxScoreGain = data.getHouseScore(data.getSafeHouse());
                this.maxScoreGainHouse = data.getSafeHouse();
                this.selfSafer = true;
            } else {
                int val;
                int startHouse;
                this.maxScoreGainHouse = startHouse = agent.getHouse();
                int baseVal = val = data.getHouseScore(startHouse);
                AI.tryAddGoodMove(goodMoves, val, 0, 0);
                int i = 0;
                while (i < this.pntsLeftover) {
                    int cPos = (startHouse + i + 1) % 12;
                    int cVal = data.getHouseScore(cPos);
                    AI.tryAddGoodMove(goodMoves, cVal, cVal - baseVal, i + 1);
                    if (cVal > val) {
                        this.maxScoreGainHouse = cPos;
                        val = cVal;
                    }
                    ++i;
                }
                this.maxScoreGain = val;
            }
            if (this.maxScoreGain + agent.getPoints() >= data.getLimit()) {
                this.endsGame = true;
            }
            this.possibleGoodMoves = new int[goodMoves.size()];
            int i = 0;
            while (i < this.possibleGoodMoves.length) {
                this.possibleGoodMoves[i] = (Integer)goodMoves.get(i);
                ++i;
            }
            i = 0;
            while (i < AI.this.agents.length) {
                Agent a = AI.this.agents[i];
                this.estimatedProfits[i] = a == safer ? data.getSafeHouse() : (a == agent ? this.maxScoreGain : AI.this.agents[i].getHouse());
                if (AI.this.shouldHurt(a) && (this.estimatedProfits[i] > this.maxScoreGain || a.getPoints() + this.estimatedProfits[i] > this.maxScoreGain + agent.getPoints() + 3) && Misc.randomBool()) {
                    this.acceptable = false;
                }
                ++i;
            }
        }

        public boolean randomYes() {
            return this.maxScoreGain - Misc.getRandomInt(10) > 0;
        }

        public int getMaxScoreGain() {
            return this.maxScoreGain;
        }
    }
}

