/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.dtos;

import com.iosoft.helpers.network.util.NetworkMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class S_GameOver
implements NetworkMessage {
    public final List<Player> Players = new ArrayList<Player>();

    @Override
    public void read(DataInputStream in) throws IOException {
        int numPlayers = in.readUnsignedByte();
        int i = 0;
        while (i < numPlayers) {
            Player player = new Player();
            player.read(in);
            this.Players.add(player);
            ++i;
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.write(this.Players.size());
        for (Player player : this.Players) {
            player.write(out);
        }
    }

    @Override
    public byte getMessageID() {
        return 54;
    }

    public static class Player {
        public int PlayerId;
        public int OwnAgent;
        public final List<PlayerGuess> ThinkAgents = new ArrayList<PlayerGuess>();

        public void read(DataInputStream in) throws IOException {
            this.PlayerId = in.readUnsignedByte();
            this.OwnAgent = in.readUnsignedByte();
            int numThinkAgents = in.readUnsignedByte();
            int i = 0;
            while (i < numThinkAgents) {
                PlayerGuess guess = new PlayerGuess();
                guess.read(in);
                this.ThinkAgents.add(guess);
                ++i;
            }
        }

        public void write(DataOutputStream out) throws IOException {
            out.write(this.PlayerId);
            out.write(this.OwnAgent);
            out.write(this.ThinkAgents.size());
            for (PlayerGuess guess : this.ThinkAgents) {
                guess.write(out);
            }
        }
    }

    public static class PlayerGuess {
        public int PlayerId;
        public int AgentId;

        public void read(DataInputStream in) throws IOException {
            this.PlayerId = in.readUnsignedByte();
            this.AgentId = in.readUnsignedByte();
        }

        public void write(DataOutputStream out) throws IOException {
            out.write(this.PlayerId);
            out.write(this.AgentId);
        }
    }
}

