/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.dtos;

import com.iosoft.helpers.network.util.StreamObject;
import com.iosoft.ioengine.NetUtil;
import com.iosoft.secag.TurnState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class InProgressGameState
implements StreamObject {
    public Agent[] Agents;
    public int MyAgent;
    public TurnState State;
    public int PlayerAtTurn;
    public int Dice;
    public int SafePos;

    @Override
    public void read(DataInputStream in) throws IOException {
        this.Agents = new Agent[NetUtil.range(in.readUnsignedByte(), 7)];
        int i = 0;
        while (i < this.Agents.length) {
            this.Agents[i] = new Agent();
            this.Agents[i].read(in);
            ++i;
        }
        this.MyAgent = NetUtil.rangeExclusive(in.readUnsignedByte(), this.Agents.length);
        this.State = TurnState.read(in);
        this.PlayerAtTurn = in.readUnsignedByte();
        this.Dice = in.readUnsignedByte();
        this.SafePos = NetUtil.rangeExclusive(in.readUnsignedByte(), 12);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.write(this.Agents.length);
        int i = 0;
        while (i < this.Agents.length) {
            this.Agents[i].write(out);
            ++i;
        }
        out.write(this.MyAgent);
        this.State.write(out);
        out.write(this.PlayerAtTurn);
        out.write(this.Dice);
        out.write(this.SafePos);
    }

    public static class Agent
    implements StreamObject {
        public int Color;
        public int House;
        public int Position;
        public int Points;

        @Override
        public void read(DataInputStream in) throws IOException {
            this.Color = NetUtil.rangeExclusive(in.readUnsignedByte(), 7);
            this.House = NetUtil.rangeExclusive(in.readUnsignedByte(), 12);
            this.Position = NetUtil.rangeExclusive(in.readUnsignedByte(), 7);
            this.Points = in.readUnsignedShort();
        }

        @Override
        public void write(DataOutputStream out) throws IOException {
            out.write(this.Color);
            out.write(this.House);
            out.write(this.Position);
            out.writeShort(this.Points);
        }
    }
}

