/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui.screens;

import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.localizer.LocalizedString;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.ui.awt.Picture;
import com.iosoft.helpers.ui.awt.UnexpandingPanel;
import com.iosoft.ioengine.serverbrowser.client.ServerEntry;
import com.iosoft.ioengine.serverbrowser.client.ui.HeadingModel;
import com.iosoft.ioengine.serverbrowser.client.ui.IServerBrowserMiscProvider;
import com.iosoft.ioengine.serverbrowser.client.ui.ServerBrowserManager;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.ServerListView;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.SwingColumn;
import com.iosoft.ioengine.serverbrowser.client.ui.awt.SwingComponent;
import com.iosoft.secag.SecAgServerInfo;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.MenuButton;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.Screen;
import java.awt.Color;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ServerBrowserScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private final ServerBrowserManager<SecAgServerInfo> serverBrowserManager;
    private boolean _isInternet;

    public ServerBrowserScreen(UserInterface ui) {
        super(ui);
        SecAgServerListView listView = new SecAgServerListView();
        this.serverBrowserManager = new ServerBrowserManager<SecAgServerInfo>((IServerBrowserMiscProvider)ui.getGame(), SecAgServerInfo::new, listView);
        Picture base = new Picture(MediaLib.background);
        base.setBounds(0, 0, 800, 600);
        this.add(base);
        CenterLabel labelHeading = new CenterLabel(0, 20, 800, 80);
        labelHeading.setForeground(new Color(30, 30, 40));
        labelHeading.setHorizontalAlignment(0);
        labelHeading.setFont(MediaLib.fontLoading);
        LocalizedString title = new LocalizedString((ILocalizer)ui.getLocalizer(), "_UI_ServerBrowser_Title", "");
        title.Text.bind(labelHeading::setText);
        this.serverBrowserManager.ModeName.bind(string -> title.setArguments(string));
        base.add(labelHeading);
        JLabel labelStatus = new JLabel("");
        MiscAWT.disableHTML(labelStatus);
        labelStatus.setBounds(90, 100, 620, 40);
        labelStatus.setForeground(Color.WHITE);
        labelStatus.setFont(MediaLib.fontInputSmall);
        this.serverBrowserManager.Status.bind(labelStatus::setText);
        base.add(labelStatus);
        UnexpandingPanel panelServerlist = new UnexpandingPanel(listView);
        panelServerlist.setOpaque(false);
        panelServerlist.setBounds(90, 150, 620, 275);
        Picture backgroundServerList = new Picture(MediaLib.background2);
        backgroundServerList.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        panelServerlist.add(backgroundServerList);
        base.add(panelServerlist);
        MenuButton buttonJoin = new MenuButton(this.localizer, "_UI_ServerBrowser_Join", 90, 450, 200, 40);
        buttonJoin.bindCommand(this.serverBrowserManager.Join);
        base.add(buttonJoin);
        MenuButton buttonRefresh = new MenuButton(this.localizer, "_UI_ServerBrowser_Refresh", 300, 450, 200, 40);
        buttonRefresh.bindCommand(this.serverBrowserManager.Refresh);
        base.add(buttonRefresh);
        MenuButton buttonAbortRefresh = new MenuButton(this.localizer, "_UI_ServerBrowser_Abort", 300, 450, 200, 40);
        buttonAbortRefresh.addActionListener(evt -> {
            boolean bl = this.serverBrowserManager.AbortRefresh.tryPerform();
        });
        this.serverBrowserManager.AbortRefresh.bind(x -> {
            buttonRefresh.setVisible(!x);
            buttonAbortRefresh.setVisible(x);
        });
        base.add(buttonAbortRefresh);
        MenuButton buttonFullRefresh = new MenuButton(this.localizer, "_UI_ServerBrowser_FullRefresh", 510, 450, 200, 40);
        buttonFullRefresh.bindCommand(this.serverBrowserManager.FullRefresh);
        base.add(buttonFullRefresh);
        MenuButton buttonBack = new MenuButton(this.localizer, "_UI_ServerBrowser_Back", 150, 530, 500, 40);
        buttonBack.addActionListener(evt -> this.uif.setMainMenuJoin());
        base.add(buttonBack);
    }

    public void setInternet(boolean internet) {
        this._isInternet = internet;
    }

    @Override
    public void init() {
        super.init();
        if (this._isInternet) {
            this.serverBrowserManager.setInternetMode();
        } else {
            this.serverBrowserManager.setLANMode();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.serverBrowserManager.stop();
    }

    protected static class SecAgServerListView
    extends ServerListView<SecAgServerInfo> {
        private static final long serialVersionUID = 1L;
        protected SwingColumn<SecAgServerInfo> columnSecPap;
        protected SwingColumn<SecAgServerInfo> columnLimit;

        public SecAgServerListView() {
            this.setOpaque(false);
        }

        @Override
        protected void onClick() {
            MediaLib.playClick();
            super.onClick();
        }

        @Override
        protected void setupColumns() {
            super.setupColumns();
            this.columnSecPap = this.addColumn("SecPap", x -> ((SecAgServerInfo)x.getInfo()).SecretPaper);
            this.columnLimit = this.addColumn("Limit", 60.0f, 0.1f, Comparator.comparingInt(x -> ((SecAgServerInfo)x.getInfo()).PointLimit), (ServerEntry<T> x) -> "" + ((SecAgServerInfo)x.getInfo()).PointLimit);
        }

        @Override
        protected HeadingModel<SwingComponent> createHeadingLabel(String name) {
            HeadingModel<SwingComponent> model = super.createHeadingLabel(name);
            model.getComponent().UI.setFont(MediaLib.fontSBHead);
            return model;
        }

        @Override
        protected JLabel createLabel(String name) {
            JLabel label = super.createLabel(name);
            label.setFont(MediaLib.fontSBEntry);
            return label;
        }
    }
}

