/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui.screens;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.localizer.Language;
import com.iosoft.helpers.localizer.LocalizedString;
import com.iosoft.helpers.localizer.MiscTranslator;
import com.iosoft.helpers.network.IpPort;
import com.iosoft.helpers.ui.awt.Picture;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.Settings;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.EasterEggLabel;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.MenuButton;
import com.iosoft.secag.client.ui.SecAgCheckbox;
import com.iosoft.secag.client.ui.SelectPanel;
import com.iosoft.secag.client.ui.TextInput;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.Screen;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainMenuScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static final String[] LANGUAGES = new String[]{"german", "english"};
    private final TextInput textName;
    private final TextInput textUDPPort;
    private final SelectPanel spLAN;
    private final SelectPanel spInternet;
    private final CenterLabel labelUDPPort;
    private final JPanel subArea;
    private final JPanel submenuMain;
    private final JPanel submenuMultiplayer;
    private final JPanel submenuHost;
    private final JPanel submenuJoin;
    private final JPanel submenuJoinDirect;
    private final Settings settings;
    private boolean wasInDirectConnectMenu;

    public MainMenuScreen(UserInterface ui) {
        super(ui);
        this.settings = (Settings)((SecretAgents)ui.getGame()).Settings;
        Picture base = new Picture(MediaLib.background);
        base.setBounds(0, 0, 800, 600);
        this.add(base);
        this.subArea = new JPanel(null);
        this.subArea.setOpaque(false);
        this.subArea.setBounds(0, 170, 800, 360);
        base.add(this.subArea);
        this.submenuMain = MainMenuScreen.createSubMenu();
        this.submenuHost = MainMenuScreen.createSubMenu();
        this.submenuMultiplayer = MainMenuScreen.createSubMenu();
        this.submenuJoin = MainMenuScreen.createSubMenu();
        this.submenuJoinDirect = MainMenuScreen.createSubMenu();
        Picture titlePicture = new Picture(MediaLib.title);
        titlePicture.setBounds(0, 0, MediaLib.title.getWidth(), MediaLib.title.getHeight());
        EasterEggLabel labelVersion = new EasterEggLabel(this.uif);
        labelVersion.setText(((SecretAgents)this.uif.getGame()).getVersion());
        int versionWidth = 80;
        labelVersion.setBounds(MediaLib.title.getWidth() - 95 - 80, MediaLib.title.getHeight() - 30, 80, 30);
        labelVersion.setForeground(Color.GRAY);
        labelVersion.setHorizontalAlignment(4);
        labelVersion.setVerticalAlignment(3);
        labelVersion.setFont(MediaLib.fontInputSmall);
        titlePicture.add(labelVersion);
        base.add(titlePicture);
        JPanel line = new JPanel();
        line.setBounds(0, 170, 800, 4);
        line.setBackground(Color.BLACK);
        base.add(line);
        CenterLabel labelCopyright = new CenterLabel(this.localizer, "_UI_MainMenu_Credits", 0, 530, 800, 30);
        labelCopyright.setForeground(new Color(30, 30, 40));
        labelCopyright.setFont(MediaLib.fontMMCopyright);
        base.add(labelCopyright);
        CenterLabel labelOriginalIdea = new CenterLabel(this.localizer, "_UI_MainMenu_OriginalIdea", 0, 560, 800, 30);
        labelOriginalIdea.setForeground(new Color(30, 30, 40));
        labelOriginalIdea.setFont(MediaLib.fontMMCopyright);
        base.add(labelOriginalIdea);
        this.submenuMain.add(new CenterLabel(this.localizer, ((SecretAgents)this.uif.getGame()).isDedicated() ? "_UI_MainMenu_Dediname" : "_UI_MainMenu_Codename", 0, 20, 800, 50));
        this.textName = new TextInput(this.settings.PlayerName, 200, 70, 400, 35, evt -> {
            String string = this.savePlayerName();
        }, ((GameClient)this.uif.getClient()).getProtocol().getMaxPlayerNameLength());
        this.textName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MainMenuScreen.this.savePlayerName();
            }
        });
        this.submenuMain.add(this.textName);
        MenuButton buttonFullscreen = new MenuButton("", 150, 135, 500, 40);
        buttonFullscreen.bindCommand(this.uif.getFullscreen().ToggleFullscreen);
        LocalizedString localizedString = new LocalizedString((ILocalizer)this.localizer, "", buttonFullscreen::setText);
        this.uif.getFullscreen().Fullscreened.bind(x -> localizedString.setText("_UI_MainMenu_" + (x ? "Windowed" : "Fullscreen")));
        this.submenuMain.add(buttonFullscreen);
        SecAgCheckbox boxGraphics = new SecAgCheckbox(150, 180, 20, 20, this.settings.ForceOpenGL);
        boxGraphics.addActionListener(evt -> this.settings.setForceOpenGL(boxGraphics.isChecked()));
        this.submenuMain.add(boxGraphics);
        JLabel label = MiscTranslator.createJLabel(this.localizer, "_UI_MainMenu_GraphicsSwitch");
        label.setFont(MediaLib.fontLabelVerySmall);
        label.setBounds(175, 180, 475, 20);
        this.submenuMain.add(label);
        MenuButton buttonSingleplayer = new MenuButton(this.localizer, "_UI_MainMenu_MM_Singleplayer", 150, 230, 500, 40, () -> ((SecretAgents)this.uif.getGame()).startServerAndConnectDirect(false, '\u0000', false, false, null, false, this.savePlayerName()));
        this.submenuMain.add(buttonSingleplayer);
        this.submenuMain.add(new MenuButton(this.localizer, "_UI_MainMenu_MM_Multiplayer", 150, 280, 500, 40, this::toMultiplayerMenu));
        int i = 0;
        while (i < LANGUAGES.length) {
            Language language = this.localizer.getLanguage(LANGUAGES[i]);
            MenuButton langButton = new MenuButton("", 700 + 40 * i, 70, 40, 30, () -> ((SecretAgents)this.uif.getGame()).setLanguage(language));
            langButton.setImage(language.getProperty("flagImg", null));
            this.submenuMain.add(langButton);
            ++i;
        }
        this.add(this.submenuMain);
        CenterLabel labelTitleCreate = new CenterLabel(this.localizer, "_UI_MainMenu_Multiplayer", 0, 0, 800, 100);
        labelTitleCreate.setFont(MediaLib.fontTitle);
        labelTitleCreate.setForeground(new Color(60, 60, 10));
        this.submenuMultiplayer.add(labelTitleCreate);
        this.submenuMultiplayer.add(new MenuButton(this.localizer, "_UI_MainMenu_Multiplayer_Host", 150, 100, 500, 40, this::toHostMenu));
        MenuButton buttonMultiplayerJoin = new MenuButton(this.localizer, "_UI_MainMenu_Multiplayer_Join", 150, 150, 500, 40, this::toJoinMenuFromMainMenu);
        this.submenuMultiplayer.add(buttonMultiplayerJoin);
        this.submenuMultiplayer.add(new MenuButton(this.localizer, "_UI_MainMenu_Back", 150, 300, 500, 40, this::toMainMenu));
        CenterLabel labelTitleHost = new CenterLabel(this.localizer, "_UI_MainMenu_Host", 0, 0, 800, 100);
        labelTitleHost.setFont(MediaLib.fontTitle);
        labelTitleHost.setForeground(new Color(60, 60, 10));
        this.submenuHost.add(labelTitleHost);
        this.submenuHost.add(new CenterLabel(this.localizer, "_UI_MainMenu_Host_Port", 100, 100, 290, 50, 4));
        TextInput textHostPort = new TextInput("" + this.settings.HostPort, 400, 110, 200, 35, 5);
        this.submenuHost.add(textHostPort);
        this.submenuHost.add(new CenterLabel(this.localizer, "_UI_MainMenu_Host_ServerBrowser", 100, 150, 290, 50, 4));
        this.spLAN = new SelectPanel(this.localizer, "_UI_MainMenu_Host_SBLAN", 400, 160, 100, 35);
        this.submenuHost.add(this.spLAN);
        this.spInternet = new SelectPanel(this.localizer, "_UI_MainMenu_Host_SBInternet", 510, 160, 100, 35);
        this.spInternet.addActionListener(evt -> this.checkUDPPort());
        this.submenuHost.add(this.spInternet);
        this.labelUDPPort = (CenterLabel)this.submenuHost.add(new CenterLabel(this.localizer, "_UI_MainMenu_Host_SBPort", 400, 200, 100, 25));
        this.labelUDPPort.setFont(MediaLib.fontLabelVerySmall);
        this.textUDPPort = new TextInput("" + (this.settings.AnnounceInternetPort == null ? this.settings.HostPort : this.settings.AnnounceInternetPort.charValue()), 500, 200, 100, 25, 5);
        this.textUDPPort.setFont(MediaLib.fontInputVerySmall);
        this.submenuHost.add(this.textUDPPort);
        MenuButton buttonHost = new MenuButton(this.localizer, "_UI_MainMenu_Host_Start", 150, 250, 500, 40, () -> {
            SecretAgents game = (SecretAgents)this.uif.getGame();
            char defaultPort = game.getProtocol().getDefaultPort();
            char port = Misc.getAsUShort(textHostPort.getText().trim(), defaultPort);
            char udpPort = Misc.getAsUShort(this.textUDPPort.getText().trim(), defaultPort);
            boolean announceLAN = this.spLAN.isSelected();
            boolean announceInternet = this.spInternet.isSelected();
            if (game.isDedicated()) {
                this.uif.setDediMode(Misc.getLocalInetAddress().getHostAddress(), port);
            }
            game.startServerAndConnectDirect(true, port, announceLAN, announceInternet, Character.valueOf(udpPort), game.isDedicated(), this.savePlayerName());
        });
        this.submenuHost.add(buttonHost);
        this.submenuHost.add(new MenuButton(this.localizer, "_UI_MainMenu_Back", 150, 300, 500, 40, this::toMultiplayerMenu));
        CenterLabel labelTitleJoin = new CenterLabel(this.localizer, "_UI_MainMenu_Join", 0, 0, 800, 100);
        labelTitleJoin.setFont(MediaLib.fontTitle);
        labelTitleJoin.setForeground(new Color(60, 60, 10));
        this.submenuJoin.add(labelTitleJoin);
        this.submenuJoin.add(new MenuButton(this.localizer, "_UI_MainMenu_Join_LAN", 150, 100, 500, 40, () -> this.openServerBrowser(false)));
        this.submenuJoin.add(new MenuButton(this.localizer, "_UI_MainMenu_Join_Internet", 150, 150, 500, 40, () -> this.openServerBrowser(true)));
        this.submenuJoin.add(new MenuButton(this.localizer, "_UI_MainMenu_Join_Direct", 150, 220, 500, 40, this::toDirectJoinMenu));
        this.submenuJoin.add(new MenuButton(this.localizer, "_UI_MainMenu_Back", 150, 300, 500, 40, this::toMultiplayerMenu));
        CenterLabel labelTitleJoin2 = new CenterLabel(this.localizer, "_UI_MainMenu_Direct", 0, 0, 800, 100);
        labelTitleJoin2.setFont(MediaLib.fontTitle);
        labelTitleJoin2.setForeground(new Color(60, 60, 10));
        this.submenuJoinDirect.add(labelTitleJoin2);
        IpPort lastJoinTarget = this.settings.LastJoinTarget;
        this.submenuJoinDirect.add(new CenterLabel(this.localizer, "_UI_MainMenu_Direct_IP", 100, 100, 290, 50, 4));
        TextInput textIP = new TextInput(lastJoinTarget.IpAddress, 400, 110, 200, 35, -1);
        this.submenuJoinDirect.add(textIP);
        this.submenuJoinDirect.add(new CenterLabel(this.localizer, "_UI_MainMenu_Direct_Port", 100, 150, 290, 50, 4));
        TextInput textPort = new TextInput("" + lastJoinTarget.Port, 400, 160, 200, 35, 5);
        this.submenuJoinDirect.add(textPort);
        MenuButton buttonJoin = new MenuButton(this.localizer, "_UI_MainMenu_Direct_Join", 150, 250, 500, 40, () -> {
            String ip = textIP.getText().trim();
            String sPort = textPort.getText().trim();
            char port = Misc.getAsUShort(sPort, ((SecretAgents)this.uif.getGame()).getProtocol().getDefaultPort());
            IpPort target = new IpPort(ip, port);
            this.settings.setJoinOptions(target);
            this.wasInDirectConnectMenu = true;
            ((GameClient)this.uif.getClient()).connect(target);
        });
        this.submenuJoinDirect.add(buttonJoin);
        MenuButton buttonBackJoin2 = new MenuButton(this.localizer, "_UI_MainMenu_Back", 150, 300, 500, 40, this::toJoinMenuFromMainMenu);
        this.submenuJoinDirect.add(buttonBackJoin2);
        if (((SecretAgents)this.uif.getGame()).isDedicated()) {
            buttonSingleplayer.setEnabled(false);
            buttonMultiplayerJoin.setEnabled(false);
        }
        this.toMainMenu();
        this.checkUDPPort();
    }

    private String savePlayerName() {
        this.textName.setText(this.validateName(this.textName.getText()));
        String serverName = !((SecretAgents)this.uif.getGame()).isDedicated() ? this.localizer.translate("_ServerAdd", this.textName.getText()) : this.textName.getText();
        this.settings.setPlayerName(this.textName.getText());
        return serverName;
    }

    private void toMenu(JPanel menu) {
        this.subArea.removeAll();
        this.subArea.add(menu);
        this.revalidate();
        this.repaint();
    }

    private void toMainMenu() {
        this.toMenu(this.submenuMain);
    }

    private void toMultiplayerMenu() {
        this.toMenu(this.submenuMultiplayer);
    }

    private void toJoinMenuFromMainMenu() {
        this.wasInDirectConnectMenu = false;
        this.toJoinMenu();
    }

    public void toJoinMenu() {
        this.toMenu(this.submenuJoin);
    }

    private void toDirectJoinMenu() {
        this.toMenu(this.submenuJoinDirect);
    }

    private void toHostMenu() {
        this.subArea.removeAll();
        this.subArea.add(this.submenuHost);
        this.revalidate();
        this.repaint();
    }

    private void checkUDPPort() {
        boolean inet = this.spInternet.isSelected();
        this.labelUDPPort.setVisible(inet);
        this.textUDPPort.setVisible(inet);
    }

    @Override
    public void reset() {
        super.reset();
        if (!this.wasInDirectConnectMenu) {
            this.toMainMenu();
        }
    }

    @Override
    public void init() {
        this.spLAN.setSelected(this.settings.AnnounceLAN);
        this.spInternet.setSelected(this.settings.AnnounceInternet);
        this.checkUDPPort();
    }

    private static JPanel createSubMenu() {
        JPanel p = new JPanel(null);
        p.setOpaque(false);
        p.setBounds(0, 0, 800, 360);
        p.setBackground(Color.RED);
        return p;
    }

    public void openServerBrowser(boolean internet) {
        this.uif.getServerBrowser().setInternet(internet);
        this.uif.setServerBrowser();
    }

    private String validateName(String text) {
        return Misc.limitLength(Misc.trimAll(text), ((GameClient)this.uif.getClient()).getProtocol().getMaxPlayerNameLength());
    }
}

