/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui.screens;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.localizer.LocalizedString;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.ui.awt.Picture;
import com.iosoft.ioengine.game.client.LocalPlayer;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.Settings;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.PlayerEntry;
import com.iosoft.secag.client.SecAgGameState;
import com.iosoft.secag.client.ui.BGPanel;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.ChatArea;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.MenuButton;
import com.iosoft.secag.client.ui.SecAgCheckbox;
import com.iosoft.secag.client.ui.SecAgSpinner;
import com.iosoft.secag.client.ui.TextInput;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.Screen;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.SocketAddress;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LobbyScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static final Color COLOR_ADMIN = new Color(60, 60, 0);
    public static final int[] LIMITS = new int[]{25, 30, 41, 50, 60, 70, 80, 90, 100, 120, 150, 170, 200};
    private final SecAgGameState gs;
    private final PlayerSlot[] slots;
    private final SecAgSpinner<Integer> spinnerPlayers;
    private final SecAgSpinner<Integer> spinnerLimit;
    private final SecAgSpinner<SecretPaperLimitValue> spinnerSecretPaperLimit;
    private final SecAgCheckbox boxUseSecretPaper;
    private final SecAgCheckbox boxOpenGame;
    private final MenuButton buttonQuit;
    private final MenuButton buttonStart;
    private final MenuButton buttonAddAI;
    private final MenuButton buttonReady;
    private final CenterLabel labelSecretPaperLimit;
    private final CenterLabel labelVersion;
    private final CenterLabel labelIP;
    private final CenterLabel labelOpenGame;
    private final TextInput textVersion;
    private final TextInput textIP;
    private final TextInput textChat;
    private final LocalizedString strTextVersion;
    private final ChatArea chatArea;
    private final SecretPaperLimitValue[] secretPaperLimitFakeList = new SecretPaperLimitValue[]{new SecretPaperLimitValue(), new SecretPaperLimitValue(), new SecretPaperLimitValue()};
    private int secretPaperLimitStartChoice;
    private String STR_FREESLOT = "";
    private String STR_CONNECTING = "";
    private final ImageIcon IconKick = new ImageIcon(MediaLib.kick[0]);
    private final ImageIcon IconKickOmo = new ImageIcon(MediaLib.kick[1]);

    public LobbyScreen(UserInterface ui, SecAgGameState gamestate) {
        super(ui);
        this.gs = gamestate;
        Picture base = new Picture(MediaLib.background);
        base.setBounds(0, 0, 800, 600);
        this.add(base);
        GameClient client = (GameClient)this.uif.getClient();
        Settings settings = (Settings)((SecretAgents)this.gs.getGame()).Settings;
        JPanel slotsPanel = new JPanel(null);
        slotsPanel.setOpaque(false);
        slotsPanel.setBounds(0, 0, 500, 360);
        base.add(slotsPanel);
        this.slots = new PlayerSlot[7];
        int i = 0;
        while (i < this.slots.length) {
            this.slots[i] = new PlayerSlot(i);
            this.slots[i].setBounds(10, 10 + i * 50, 480, 40);
            slotsPanel.add(this.slots[i]);
            ++i;
        }
        base.add(new CenterLabel(this.localizer, "_UI_Lobby_Players", 500, 10, 150, 35, 2));
        this.spinnerPlayers = new SecAgSpinner<Integer>(650, 10, 140, 35, Misc.boxIntArray(Misc.range(2, 7)), 0);
        this.spinnerPlayers.addActionListener(evt -> {
            int num = this.spinnerPlayers.getChoiceIndex() + 2;
            client.sendCommandIfFullyConnected("maxplayers " + num);
            settings.setMaxPlayers(num);
        });
        base.add(this.spinnerPlayers);
        base.add(new CenterLabel(this.localizer, "_UI_Lobby_SecPap", 500, 60, 250, 35, 2));
        this.boxUseSecretPaper = new SecAgCheckbox(755, 60, 35, 35, false);
        this.boxUseSecretPaper.addActionListener(evt -> {
            boolean is = this.boxUseSecretPaper.isChecked();
            client.sendCommandIfFullyConnected("secpap " + (is ? 1 : 0));
            settings.setUseSecretPaper(is);
        });
        base.add(this.boxUseSecretPaper);
        this.labelOpenGame = new CenterLabel(this.localizer, "_UI_Lobby_OpenGame", 500, 110, 250, 35, 2);
        base.add(this.labelOpenGame);
        this.boxOpenGame = new SecAgCheckbox(755, 110, 35, 35, false);
        this.boxOpenGame.addActionListener(evt -> {
            boolean is = this.boxOpenGame.isChecked();
            client.sendCommandIfFullyConnected("opengame " + (is ? 1 : 0));
            settings.setOpenGame(is);
        });
        base.add(this.boxOpenGame);
        base.add(new CenterLabel(this.localizer, "_UI_Lobby_Limit", 500, 160, 150, 35, 2));
        this.spinnerLimit = new SecAgSpinner<Integer>(650, 160, 140, 35, Misc.boxIntArray(LIMITS), 0);
        this.spinnerLimit.addActionListener(evt -> {
            int num = LIMITS[this.spinnerLimit.getChoiceIndex()];
            client.sendCommandIfFullyConnected("limit " + num);
            settings.setLimit(num);
        });
        base.add(this.spinnerLimit);
        this.labelSecretPaperLimit = new CenterLabel(this.localizer, "_UI_Lobby_SecPapAt", 500, 210, 150, 35, 2);
        base.add(this.labelSecretPaperLimit);
        this.spinnerSecretPaperLimit = new SecAgSpinner<SecretPaperLimitValue>(650, 210, 140, 35, this.secretPaperLimitFakeList, 0);
        this.spinnerSecretPaperLimit.addActionListener(evt -> {
            int choice = this.spinnerSecretPaperLimit.getChoiceIndex();
            if (choice != this.secretPaperLimitStartChoice) {
                float num = (float)(Math.round(Misc.clamp((float)this.gs.pointsForSecretPaper / (float)this.gs.pointsForGameover, 0.0f, 1.0f) * 10.0f) + choice - this.secretPaperLimitStartChoice) / 10.0f;
                client.sendCommandIfFullyConnected("secpap_quota " + num);
                settings.setSecretPaperQuota(num);
                this.setSpinnerSecretPaperLimit();
            }
        });
        base.add(this.spinnerSecretPaperLimit);
        this.labelVersion = new CenterLabel(this.localizer, "_UI_Lobby_ServerVersion", 500, 260, 290, 35, 2);
        this.labelVersion.setFont(MediaLib.fontLabelSmall);
        base.add(this.labelVersion);
        this.textVersion = new TextInput(500, 295, 290, 35);
        this.strTextVersion = new LocalizedString((ILocalizer)this.localizer, "_UI_Lobby_Version", this.textVersion::setText, "");
        this.textVersion.setRenderBG(false);
        this.textVersion.setEditable(false);
        this.textVersion.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        this.textVersion.setFont(MediaLib.fontLabelSmall);
        base.add(this.textVersion);
        this.labelIP = new CenterLabel(this.localizer, "_UI_Lobby_ServerIP", 500, 345, 290, 35, 2);
        this.labelIP.setFont(MediaLib.fontLabelSmall);
        base.add(this.labelIP);
        this.textIP = new TextInput(500, 380, 290, 35);
        this.textIP.setRenderBG(false);
        this.textIP.setEditable(false);
        this.textIP.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        this.textIP.setFont(MediaLib.fontLabelSmall);
        base.add(this.textIP);
        this.chatArea = new ChatArea(10, 360, 480, 185);
        base.add(this.chatArea);
        this.textChat = new TextInput(10, 555, 480, 35, this.gs.getProtocol().getMaxChatLength());
        this.textChat.addActionListener(evt -> {
            String text = this.textChat.getText();
            this.textChat.setText("");
            client.chat(text, 0);
        });
        this.textChat.setFont(MediaLib.fontInputSmall);
        this.textChat.setBackground(Color.WHITE);
        this.textChat.setHorizontalAlignment(2);
        base.add(this.textChat);
        this.buttonAddAI = new MenuButton(this.localizer, "_UI_Lobby_AddAI", 500, 450, 290, 40, () -> client.doAction(4));
        base.add(this.buttonAddAI);
        this.buttonStart = new MenuButton(this.localizer, "_UI_Lobby_Start", 500, 500, 290, 40, () -> client.doAction(0));
        base.add(this.buttonStart);
        this.buttonReady = new MenuButton(this.localizer, "_UI_Lobby_Ready", 500, 500, 290, 40, () -> client.doAction(1, 1));
        base.add(this.buttonReady);
        this.buttonQuit = new MenuButton(this.localizer, "_UI_Lobby_Quit", 500, 550, 290, 40, client::quit);
        base.add(this.buttonQuit);
        this.localizer.bind("_UI_Lobby_FreeSlot", x -> {
            String string = this.STR_FREESLOT = x;
        });
        this.localizer.bind("_UI_Lobby_Connecting", x -> {
            String string = this.STR_CONNECTING = x;
        });
        gamestate.IsAdmin.bind(x -> this.update());
    }

    @Override
    public void init() {
        this.strTextVersion.setArguments(this.gs.getServerVersion());
        SocketAddress address = this.gs.getServerAddress();
        this.textIP.setVisible(address != null);
        if (address != null) {
            this.textIP.setText(address.toString());
        }
        boolean mp = !this.gs.isSingleplayer();
        this.textIP.setVisible(mp);
        this.labelIP.setVisible(mp);
        this.textVersion.setVisible(mp);
        this.labelVersion.setVisible(mp);
        this.labelOpenGame.setVisible(mp);
        this.boxOpenGame.setVisible(mp);
        this.update();
    }

    public void update() {
        boolean showReadyButton;
        boolean admin = this.gs.IsAdmin.get();
        this.buttonStart.setVisible(admin);
        boolean bl = showReadyButton = !admin;
        if (showReadyButton) {
            PlayerEntry primaryLocalPlayerSlot = (PlayerEntry)((LocalPlayer)((GameClient)this.gs.getClientApp()).getPrimaryLocalPlayer()).getSlot();
            showReadyButton = primaryLocalPlayerSlot != null && !primaryLocalPlayerSlot.isReady();
        }
        this.buttonReady.setVisible(showReadyButton);
        this.buttonAddAI.setVisible(admin && !this.gs.isSingleplayer());
        this.spinnerPlayers.setEnabled(admin);
        this.spinnerLimit.setEnabled(admin);
        this.spinnerSecretPaperLimit.setEnabled(admin);
        this.boxUseSecretPaper.setEnabled(admin);
        this.boxOpenGame.setEnabled(admin);
        this.spinnerPlayers.setValue(this.gs.getMaxPlayers());
        this.spinnerLimit.setValue(this.gs.pointsForGameover);
        this.setSpinnerSecretPaperLimit();
        this.boxUseSecretPaper.setChecked(this.gs.useSecretPaper);
        this.boxOpenGame.setChecked(this.gs.isOpenGame());
        this.labelSecretPaperLimit.setVisible(this.gs.useSecretPaper);
        this.spinnerSecretPaperLimit.setVisible(this.gs.useSecretPaper);
        boolean allReady = true;
        boolean freeSlots = false;
        boolean allowOpenStart = ((Settings)((SecretAgents)this.uif.getGame()).Settings).getAllowOpenStart();
        int numHumans = 0;
        int i = 0;
        while (i < 7) {
            this.slots[i].setVisible(i < this.gs.getMaxPlayers());
            this.slots[i].update();
            PlayerEntry p = (PlayerEntry)this.gs.tryGetPlayer(i);
            if (i < this.gs.getMaxPlayers()) {
                if (p.isFree() && (!this.gs.isOpenGame() || !allowOpenStart) || p.isConnecting() || !p.isReady() && !p.isFree()) {
                    allReady = false;
                }
                if (p.isFree()) {
                    freeSlots = true;
                }
                if (p.isPlaying() && !p.isAI()) {
                    ++numHumans;
                }
            }
            ++i;
        }
        this.buttonStart.setEnabled(allReady && (numHumans >= 2 || this.gs.isSingleplayer()));
        this.buttonAddAI.setEnabled(freeSlots);
        this.revalidate();
    }

    private void setSpinnerSecretPaperLimit() {
        SecretPaperLimitValue[] secretPaperLimitValueArray = this.secretPaperLimitFakeList;
        int n = this.secretPaperLimitFakeList.length;
        int n2 = 0;
        while (n2 < n) {
            SecretPaperLimitValue value = secretPaperLimitValueArray[n2];
            value.Value = this.gs.pointsForSecretPaper;
            ++n2;
        }
        float value = Misc.clamp((float)this.gs.pointsForSecretPaper / (float)Math.max(1, this.gs.pointsForGameover), 0.0f, 1.0f);
        this.secretPaperLimitStartChoice = value == 0.0f ? 0 : (value == 1.0f ? 2 : 1);
        this.spinnerSecretPaperLimit.setChoices((SecretPaperLimitValue[])this.secretPaperLimitFakeList, this.secretPaperLimitStartChoice);
    }

    public void setChat(String text) {
        this.chatArea.setText(text);
        this.revalidate();
        this.repaint();
    }

    private class PlayerSlot
    extends BGPanel {
        private static final long serialVersionUID = 1L;
        private final int nr;
        private PlayerEntry player;
        private final JLabel labelName;
        private final JLabel labelPing;
        private final JButton buttonKick;
        private final Picture picRight;

        PlayerSlot(int i) {
            super(null);
            this.nr = i;
            this.labelName = new JLabel();
            MiscAWT.disableHTML(this.labelName);
            this.labelName.setFont(MediaLib.fontLabel);
            this.add(this.labelName);
            this.labelPing = new JLabel();
            this.labelPing.setHorizontalAlignment(0);
            this.labelPing.setFont(MediaLib.fontPing);
            this.add(this.labelPing);
            this.picRight = new Picture();
            this.picRight.setSizeRule(Picture.SizeRule.STRETCH);
            this.picRight.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1 && PlayerSlot.this.player.isLocal()) {
                        MediaLib.playClick();
                        ((GameClient)((PlayerSlot)PlayerSlot.this).LobbyScreen.this.uif.getClient()).doAction(1, PlayerSlot.this.player.isReady() ? 0 : 1);
                    }
                }
            });
            this.add(this.picRight);
            this.buttonKick = new JButton();
            this.buttonKick.setContentAreaFilled(false);
            this.buttonKick.setIcon(LobbyScreen.this.IconKick);
            this.buttonKick.setRolloverIcon(LobbyScreen.this.IconKickOmo);
            this.buttonKick.setPressedIcon(LobbyScreen.this.IconKickOmo);
            this.buttonKick.addActionListener(evt -> {
                MediaLib.playClick();
                ((GameClient)LobbyScreen.this.uif.getClient()).doAction((evt.getModifiers() & 2) != 0 ? 3 : 2, this.nr);
            });
            this.add(this.buttonKick);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
            this.update();
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.layoutComponent(w, h);
        }

        @Override
        public void setSize(int width, int height) {
            super.setSize(width, height);
            if (this.buttonKick == null) {
                return;
            }
            this.layoutComponent(width, height);
        }

        private void layoutComponent(int width, int height) {
            this.buttonKick.setBounds(0, 0, height, height);
            this.picRight.setBounds(width - height, 0, height, height);
            this.labelName.setBounds(height, 0, width - height * 2 - 80, height);
            this.labelPing.setBounds(width - height - 80, 0, 80, height);
        }

        public void update() {
            this.player = (PlayerEntry)LobbyScreen.this.gs.tryGetPlayer(this.nr);
            if (this.player.isFree()) {
                this.labelName.setForeground(Color.DARK_GRAY);
                this.labelName.setText(LobbyScreen.this.STR_FREESLOT);
            } else if (this.player.isConnecting()) {
                this.labelName.setForeground(Color.DARK_GRAY);
                this.labelName.setText(LobbyScreen.this.STR_CONNECTING);
            } else {
                Color color;
                Color color2 = color = this.player.isAdmin() ? COLOR_ADMIN : Color.BLACK;
                if (this.player.isStillInGameOver()) {
                    color = MiscAWT.setAlpha(color, 90);
                }
                this.labelName.setForeground(color);
                this.labelName.setText(this.player.getName());
                this.labelPing.setText(this.player.isAI() ? "" : this.player.getPing() + " ms");
                this.labelPing.setForeground(this.player.isLagging() ? Color.RED : Color.BLACK);
            }
            this.labelPing.setVisible(this.player.isPlaying() && !this.player.isAI());
            if (this.player.isAI()) {
                this.picRight.setImage(MediaLib.ai);
            } else if (this.player.isConnecting()) {
                this.picRight.setImage(MediaLib.ready[1]);
            } else {
                this.picRight.setImage(MediaLib.ready[this.player.isReady() ? 2 : 0]);
            }
            this.picRight.setVisible(this.player.isOccupied() && (!LobbyScreen.this.gs.isSingleplayer() || this.player.isAI()));
            this.buttonKick.setVisible(this.player.isOccupied() && !this.player.isMe() && ((LobbyScreen)LobbyScreen.this).gs.IsAdmin.get());
        }
    }

    private static class SecretPaperLimitValue {
        public int Value;

        private SecretPaperLimitValue() {
        }

        public String toString() {
            return "" + this.Value;
        }
    }
}

