/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui.screens;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.localizer.LocalizedString;
import com.iosoft.helpers.math.Misc2D;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.ui.awt.Picture;
import com.iosoft.secag.TurnState;
import com.iosoft.secag.client.Agent;
import com.iosoft.secag.client.AgentColor;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.PlayerEntry;
import com.iosoft.secag.client.SecAgGameState;
import com.iosoft.secag.client.ui.BGPanel;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.ChatArea;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.MenuButton;
import com.iosoft.secag.client.ui.OwnAgentCard;
import com.iosoft.secag.client.ui.TextInput;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.Screen;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class IngameScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static final Color COLOR_QUITOVERLAY = new Color(0, 0, 0, 100);
    private static final Color COLOR_PLAYERSTURN = new Color(100, 100, 100);
    private static final Color COLOR_PLAYERINFO = new Color(150, 150, 150);
    private final SecAgGameState gs;
    private final ChatArea chatArea;
    private final TextInput textChat;
    private final JPanel panelBG;
    private final JPanel panelChat;
    private final JPanel panelList;
    private final JPanel panelStats;
    private final JPanel panelQuit;
    private final JPanel panelQuitOverlay;
    private final JPanel panelStatus;
    private final PlayerList playerList;
    private final StatsList statsList;
    private final JScrollPane scrollStats;
    private final MenuButton buttonChat;
    private final MenuButton buttonList;
    private final MenuButton buttonStats;
    private final MenuButton buttonQuit;
    private final MenuButton buttonYesQuit;
    private final MenuButton buttonNoStay;
    private final MenuButton buttonRTD;
    private final MenuButton buttonTurnDone;
    private final MenuButton buttonSubmitSecretPaper;
    private final MenuButton buttonFullscreen;
    private final CenterLabel labelName;
    private final CenterLabel labelTurnOf;
    private final CenterLabel labelDiceRoll;
    private final CenterLabel labelDiceResult;
    private final CenterLabel labelWaiting;
    private final CenterLabel labelWaiting2;
    private final CenterLabel labelPlaceSafe;
    private final CenterLabel labelPlaceSafe2;
    private final CenterLabel labelSafePlaced;
    private final CenterLabel labelSafePlaced2;
    private final Picture pictureAI;
    private final AgentMovePanel[] agentPanels;
    private final AgentShowMovedPanel[] agentShowPanels;
    private final OwnAgentCard ownAgentCard;
    private final JPanel[] panelByMenuState = new JPanel[3];
    private int remainingPoints;
    private int mouseAtHouse;
    private int[] distributePoints;
    private MenuState currentMenuState;

    public IngameScreen(UserInterface ui, SecAgGameState gs) {
        super(ui);
        this.gs = gs;
        gs.ingameScreen = this;
        ML ml = new ML();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.playerList = new PlayerList();
        this.panelBG = new BGPanel(null);
        this.panelBG.setBounds(0, 360, 800, 240);
        this.panelBG.setBorder(BorderFactory.createEtchedBorder());
        this.add(this.panelBG);
        this.panelChat = IngameScreen.createPanel();
        this.panelList = IngameScreen.createPanel();
        this.panelStats = IngameScreen.createPanel();
        this.panelByMenuState[0] = this.panelChat;
        this.panelByMenuState[1] = this.panelList;
        this.panelByMenuState[2] = this.panelStats;
        this.panelList.add(this.playerList);
        this.panelQuitOverlay = new JPanel(null){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(COLOR_QUITOVERLAY);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        this.panelQuitOverlay.setBounds(0, 0, 800, 600);
        this.panelQuitOverlay.addMouseListener(new MouseAdapter(){});
        this.panelQuitOverlay.setOpaque(false);
        this.panelQuit = new BGPanel(null);
        this.panelQuit.setFocusable(true);
        this.panelQuit.setBorder(BorderFactory.createEtchedBorder());
        this.panelQuit.setBounds(150, 200, 500, 200);
        this.panelQuitOverlay.add(this.panelQuit);
        this.panelStatus = new JPanel(null);
        this.panelStatus.setOpaque(false);
        this.panelStatus.setBounds(0, 0, 350, 240);
        this.panelBG.add(this.panelStatus);
        this.labelTurnOf = new CenterLabel(this.localizer, "_UI_Ingame_TurnOf", 0, 0, 350, 25);
        this.labelTurnOf.setFont(MediaLib.fontLabelSmall);
        this.labelName = new CenterLabel(0, 25, 350, 35);
        MiscAWT.disableHTML(this.labelName);
        this.labelName.setForeground(new Color(150, 0, 0));
        this.pictureAI = new Picture(MediaLib.ai);
        this.pictureAI.setBounds(300, 10, MediaLib.ai.getWidth(), MediaLib.ai.getHeight());
        this.labelDiceRoll = new CenterLabel(this.localizer, "_UI_Ingame_RolledA", 50, 65, 150, 25);
        this.labelDiceRoll.setFont(MediaLib.fontLabelSmall);
        this.labelDiceResult = new CenterLabel(200, 60, 100, 35);
        this.labelDiceResult.setForeground(new Color(0, 0, 150));
        this.labelWaiting = new CenterLabel(this.localizer, "_UI_Ingame_Waiting", 0, 90, 350, 150);
        this.labelWaiting2 = new CenterLabel(this.localizer, "_UI_Ingame_WaitingOthers", 0, 150, 350, 40);
        this.labelPlaceSafe = new CenterLabel(this.localizer, "_UI_Ingame_MoveSafe1", 0, 150, 350, 40);
        this.labelPlaceSafe2 = new CenterLabel(this.localizer, "_UI_Ingame_MoveSafe2", 0, 190, 350, 40);
        this.labelSafePlaced = new CenterLabel(this.localizer, "_UI_Ingame_SafeMoved1", 0, 150, 350, 40);
        this.labelSafePlaced2 = new CenterLabel(this.localizer, "_UI_Ingame_SafeMoved2", 0, 190, 350, 40);
        GameClient client = (GameClient)this.uif.getClient();
        this.buttonRTD = new MenuButton(this.localizer, "_UI_Ingame_RTD", 25, 180, 300, 40, () -> client.doAction(5));
        this.buttonRTD.PlayClick = false;
        this.buttonTurnDone = new MenuButton(this.localizer, "_UI_Ingame_TurnDone", 25, 190, 300, 40, () -> client.doAction(6, this.distributePoints));
        this.buttonSubmitSecretPaper = new MenuButton(this.localizer, "_UI_Ingame_SubmitPaper", 25, 190, 300, 40, () -> client.doAction(8, this.playerList.SecretPaperDecision.get()));
        this.playerList.SecretPaperDecision.bind(x -> this.buttonSubmitSecretPaper.setEnabled(x != null));
        this.agentPanels = new AgentMovePanel[7];
        this.agentShowPanels = new AgentShowMovedPanel[this.agentPanels.length];
        int i = 0;
        while (i < this.agentPanels.length) {
            this.agentPanels[i] = new AgentMovePanel(i);
            this.agentShowPanels[i] = new AgentShowMovedPanel();
            ++i;
        }
        this.panelQuit.add(new CenterLabel(this.localizer, "_UI_Ingame_Quit_Really", 0, 10, 500, 65));
        this.buttonYesQuit = new MenuButton(this.localizer, "_UI_Ingame_Quit_Yes", 50, 75, 400, 40, client::quit);
        this.panelQuit.add(this.buttonYesQuit);
        this.buttonNoStay = new MenuButton(this.localizer, "_UI_Ingame_Quit_No", 50, 135, 400, 40, () -> this.quitState(false));
        this.panelQuit.add(this.buttonNoStay);
        this.buttonChat = new MenuButton(this.localizer, "_UI_Ingame_Chat", 701, 0, 98, 66, () -> this.openMenu(MenuState.Chat));
        this.panelBG.add(this.buttonChat);
        this.buttonList = new MenuButton(this.localizer, "_UI_Ingame_List", 701, 67, 98, 66, () -> this.openMenu(MenuState.List));
        this.panelBG.add(this.buttonList);
        this.buttonStats = new MenuButton(this.localizer, "_UI_Ingame_Log", 701, 134, 98, 66, () -> this.openMenu(MenuState.Stats));
        this.panelBG.add(this.buttonStats);
        this.buttonQuit = new MenuButton(this.localizer, "_UI_Ingame_Quit", 701, 201, 98, 39, () -> this.quitState(true));
        this.panelBG.add(this.buttonQuit);
        this.chatArea = new ChatArea(0, 0, 350, 205);
        this.panelChat.add(this.chatArea);
        this.chatArea.setOpaque(false);
        this.textChat = new TextInput(0, 205, 350, 35, gs.getProtocol().getMaxChatLength());
        this.textChat.addActionListener(evt -> {
            String text = this.textChat.getText();
            this.textChat.setText("");
            ((GameClient)this.uif.getClient()).chat(text, 0);
        });
        this.textChat.setFont(MediaLib.fontInputSmall);
        this.textChat.setBackground(Color.WHITE);
        this.textChat.setOpaque(false);
        this.textChat.setHorizontalAlignment(2);
        this.panelChat.add(this.textChat);
        this.statsList = new StatsList();
        this.scrollStats = new JScrollPane(this.statsList);
        this.scrollStats.setVerticalScrollBarPolicy(22);
        this.scrollStats.getVerticalScrollBar().setUnitIncrement(16);
        this.scrollStats.getViewport().setOpaque(false);
        this.scrollStats.setOpaque(false);
        this.scrollStats.setBounds(0, 0, 350, 240);
        this.scrollStats.setBorder(null);
        this.panelStats.add(this.scrollStats);
        this.buttonFullscreen = new MenuButton(this.localizer, "_UI_Ingame_Fullscreen", 770, 10, 20, 20);
        this.buttonFullscreen.setFont(MediaLib.fontIngameFS);
        this.buttonFullscreen.bindCommand(this.uif.getFullscreen().ToggleFullscreen);
        this.add(this.buttonFullscreen);
        this.ownAgentCard = new OwnAgentCard(ui);
        this.ownAgentCard.setBounds(600, 0, 200, 150);
        gs.OwnAgent.bind(x -> this.ownAgentCard.setAgent(x == null ? null : x.Color, gs.isSingleplayer()));
        this.add(this.ownAgentCard);
    }

    private void quitState(boolean qs) {
        this.buttonQuit.setEnabled(!qs);
        if (qs) {
            this.add(this.panelQuitOverlay);
            this.setComponentZOrder(this.panelQuitOverlay, 0);
            this.panelQuit.requestFocusInWindow();
        } else {
            this.remove(this.panelQuitOverlay);
        }
        this.revalidate();
        this.repaint();
    }

    private static JPanel createPanel() {
        JPanel p = new JPanel(null);
        p.setBounds(350, 0, 350, 240);
        p.setOpaque(false);
        return p;
    }

    @Override
    protected void paintComponent(Graphics gFake) {
        super.paintComponent(gFake);
        Graphics2D g = (Graphics2D)gFake;
        MiscAWT.setAA(g);
        this.gs.render(g);
        if (this.mouseAtHouse != -1 && this.gs.turnState == TurnState.ChooseSafePos && this.gs.playerTurn == this.gs.getMe().getNr()) {
            Composite c = MiscAWT.setAlpha(g, 0.5f);
            Point pnt = MediaLib.mapCoords[this.mouseAtHouse][0];
            g.drawImage((Image)MediaLib.tresor, pnt.x - MediaLib.tresor.getWidth() / 2, pnt.y - MediaLib.tresor.getHeight() / 2, null);
            g.setComposite(c);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.gs.fadeIn > 0) {
            g.setColor(new Color(0, 0, 0, (int)(255.0f * ((float)this.gs.fadeIn / 60.0f))));
            g.fillRect(0, 0, 800, 600);
        }
    }

    private void openMenu(MenuState newMenuState) {
        if (this.currentMenuState == newMenuState) {
            return;
        }
        this.currentMenuState = newMenuState;
        this.buttonChat.setEnabled(this.currentMenuState != MenuState.Chat);
        this.buttonList.setEnabled(this.currentMenuState != MenuState.List);
        this.buttonStats.setEnabled(this.currentMenuState != MenuState.Stats);
        int i = 0;
        while (i < this.panelByMenuState.length) {
            JPanel panel = this.panelByMenuState[i];
            if (i == this.currentMenuState.ordinal()) {
                this.panelBG.add(panel);
            } else {
                this.panelBG.remove(panel);
            }
            ++i;
        }
        if (this.currentMenuState == MenuState.Chat) {
            this.textChat.requestFocusInWindow();
            this.chatArea.scrollDown();
        }
        this.update();
    }

    public void update() {
        this.playerList.update();
        this.revalidate();
        this.repaint();
    }

    public void updateStatus() {
        this.panelStatus.removeAll();
        PlayerEntry p = (PlayerEntry)this.gs.tryGetPlayer(this.gs.playerTurn);
        this.labelName.setText(p.getName());
        this.panelStatus.add(this.labelTurnOf);
        this.panelStatus.add(this.labelName);
        if (p.isAI()) {
            this.panelStatus.add(this.pictureAI);
        }
        switch (this.gs.turnState) {
            case RollTheDice: {
                if (this.gs.playerTurn == this.gs.getMe().getNr()) {
                    this.panelStatus.add(this.buttonRTD);
                    break;
                }
                this.panelStatus.add(this.labelWaiting);
                break;
            }
            case Turn: {
                this.panelStatus.add(this.labelDiceRoll);
                this.panelStatus.add(this.labelDiceResult);
                if (this.gs.playerTurn == this.gs.getMe().getNr()) {
                    this.panelStatus.add(this.buttonTurnDone);
                    int i = 0;
                    while (i < this.distributePoints.length) {
                        this.distributePoints[i] = 0;
                        this.panelStatus.add(this.agentPanels[i]);
                        ++i;
                    }
                } else {
                    this.panelStatus.add(this.labelWaiting);
                }
                this.updateTurnStatus();
                break;
            }
            case TurnWait: {
                this.panelStatus.add(this.labelDiceRoll);
                this.panelStatus.add(this.labelDiceResult);
                if (this.gs.moves == null) break;
                int i = 0;
                while (i < this.distributePoints.length) {
                    if (this.gs.moves[i] > 0) {
                        this.agentShowPanels[i].setValue(this.gs.moves[i]);
                        this.panelStatus.add(this.agentShowPanels[i]);
                    }
                    ++i;
                }
                break;
            }
            case ChooseSafePos: {
                this.mouseAtHouse = -1;
                this.panelStatus.add(this.labelDiceRoll);
                this.panelStatus.add(this.labelDiceResult);
                if (this.gs.moves != null) {
                    int i = 0;
                    while (i < this.distributePoints.length) {
                        if (this.gs.moves[i] > 0) {
                            this.agentShowPanels[i].setValue(this.gs.moves[i]);
                            this.panelStatus.add(this.agentShowPanels[i]);
                        }
                        ++i;
                    }
                }
                this.panelStatus.add(this.labelPlaceSafe);
                this.panelStatus.add(this.labelPlaceSafe2);
                break;
            }
            case SafePlaced: {
                this.panelStatus.add(this.labelDiceRoll);
                this.panelStatus.add(this.labelDiceResult);
                if (this.gs.moves != null) {
                    int i = 0;
                    while (i < this.distributePoints.length) {
                        if (this.gs.moves[i] > 0) {
                            this.agentShowPanels[i].setValue(this.gs.moves[i]);
                            this.panelStatus.add(this.agentShowPanels[i]);
                        }
                        ++i;
                    }
                }
                this.panelStatus.add(this.labelSafePlaced);
                this.panelStatus.add(this.labelSafePlaced2);
                break;
            }
            case SubmitSecretPaper: {
                this.panelStatus.add(this.labelDiceRoll);
                this.panelStatus.add(this.labelDiceResult);
                if (this.gs.moves != null) {
                    int i = 0;
                    while (i < this.distributePoints.length) {
                        if (this.gs.moves[i] > 0) {
                            this.agentShowPanels[i].setValue(this.gs.moves[i]);
                            this.panelStatus.add(this.agentShowPanels[i]);
                        }
                        ++i;
                    }
                }
                if (!this.gs.tipAccepted) {
                    MediaLib.SoundSecretPaper.play();
                    this.addStatsPaper();
                    this.playerList.checkSecretPaperDecision();
                    this.panelStatus.add(this.buttonSubmitSecretPaper);
                    break;
                }
                this.panelStatus.add(this.labelWaiting2);
                break;
            }
        }
        this.playerList.update();
        this.revalidate();
        this.uif.repaint();
    }

    private void updateTurnStatus() {
        if (this.gs.playerTurn == this.gs.getMe().getNr()) {
            this.remainingPoints = this.gs.dice;
            int i = 0;
            while (i < this.distributePoints.length) {
                this.remainingPoints -= this.distributePoints[i];
                ++i;
            }
            this.buttonTurnDone.setEnabled(this.remainingPoints == 0);
            this.labelDiceResult.setText(this.gs.dice + " (" + this.remainingPoints + ")");
        } else {
            this.labelDiceResult.setText("" + this.gs.dice);
        }
        this.revalidate();
        this.uif.repaint();
    }

    public void setChat(String text) {
        this.chatArea.setText(text);
        this.revalidate();
        this.uif.repaint();
    }

    @Override
    public void init() {
        this.statsList.init();
        this.distributePoints = new int[this.gs.agents.length];
        int i = 0;
        while (i < this.distributePoints.length) {
            this.agentPanels[i].init(this.distributePoints.length, this.gs.agents[i].Color);
            this.agentShowPanels[i].init(i, this.distributePoints.length, this.gs.agents[i].Color);
            ++i;
        }
        this.openMenu(MenuState.List);
        this.mouseAtHouse = -1;
        this.quitState(false);
        this.updateStatus();
        this.updateTurnStatus();
    }

    @Override
    public void reset() {
        super.reset();
        this.statsList.clear();
    }

    public void addStatsMoved(int player, int[] xMoves) {
        this.statsList.addStatsMoved(player, xMoves);
    }

    public void addStatsSafe(int safePos, int[] xOldPoints, int[] xNewPoints) {
        this.statsList.addStatsSafe(safePos, xOldPoints, xNewPoints);
    }

    public void addStatsSlot(String msg, boolean joined) {
        this.statsList.addStatsSlot(msg, joined);
    }

    public void addStatsPaper() {
        this.statsList.addStatsPaper();
    }

    private static BufferedImage createStatsImage() {
        return MiscImg.createCompatibleImage(320, 40);
    }

    public void plsFixThis() {
    }

    private class AgentMovePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int nr;
        private int omo;

        AgentMovePanel(int number) {
            this.nr = number;
            this.omo = -1;
            this.setLayout(null);
            this.setOpaque(false);
            this.setFont(MediaLib.fontInputSmall);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Point p = e.getPoint();
                    if (AgentMovePanel.this.onUp(p)) {
                        MediaLib.playClick();
                        int[] nArray = IngameScreen.this.distributePoints;
                        int n = AgentMovePanel.this.nr;
                        nArray[n] = nArray[n] + 1;
                        IngameScreen.this.updateTurnStatus();
                    } else if (AgentMovePanel.this.onDown(p)) {
                        MediaLib.playClick();
                        int[] nArray = IngameScreen.this.distributePoints;
                        int n = AgentMovePanel.this.nr;
                        nArray[n] = nArray[n] - 1;
                        IngameScreen.this.updateTurnStatus();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    AgentMovePanel.this.omo = -1;
                    AgentMovePanel.this.repaint();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point p = e.getPoint();
                    int oldOmo = AgentMovePanel.this.omo;
                    if (AgentMovePanel.this.onUp(p)) {
                        AgentMovePanel.this.omo = 0;
                    } else if (AgentMovePanel.this.onDown(p)) {
                        AgentMovePanel.this.omo = 1;
                    } else {
                        AgentMovePanel.this.omo = -1;
                    }
                    if (AgentMovePanel.this.omo != oldOmo) {
                        AgentMovePanel.this.repaint();
                    }
                }
            });
        }

        private boolean onUp(Point p) {
            return this.canUp() && p.x >= 15 && p.y >= 3 && p.x < 35 && p.y < 23;
        }

        private boolean onDown(Point p) {
            return this.canDown() && p.x >= 15 && p.y >= 57 && p.x < 35 && p.y < 77;
        }

        public void init(int num, AgentColor color) {
            this.setBounds(175 - num * 25 + this.nr * 50, 100, 50, 80);
            this.setBackground(MiscAWT.setAlpha(color.Background, 180));
            this.setForeground(color.Foreground);
        }

        public boolean canDown() {
            return IngameScreen.this.distributePoints[this.nr] > 0;
        }

        public boolean canUp() {
            return IngameScreen.this.remainingPoints > 0;
        }

        @Override
        protected void paintComponent(Graphics gFake) {
            Graphics2D g = (Graphics2D)gFake;
            MiscAWT.setAA(g);
            g.setColor(this.getBackground());
            g.fillRoundRect(5, 0, 40, 80, 20, 20);
            g.setColor(this.getForeground());
            MiscAWT.drawCenteredString("" + IngameScreen.this.distributePoints[this.nr], 0, 20, 50, 40, g);
            if (this.canUp()) {
                g.drawImage((Image)MediaLib.upndown[this.omo == 0 ? 0 : 2], 15, 3, null);
            }
            if (this.canDown()) {
                g.drawImage((Image)MediaLib.upndown[this.omo == 1 ? 1 : 3], 15, 57, null);
            }
        }
    }

    private static class AgentShowMovedPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int _value;

        AgentShowMovedPanel() {
            this.setLayout(null);
            this.setOpaque(false);
            this.setFont(MediaLib.fontInputSmall);
        }

        public void init(int nr, int num, AgentColor color) {
            this.setBounds(175 - num * 25 + nr * 50, 100, 50, 50);
            this.setBackground(MiscAWT.setAlpha(color.Background, 180));
            this.setForeground(color.Foreground);
        }

        public void setValue(int value) {
            this._value = value;
        }

        @Override
        protected void paintComponent(Graphics gFake) {
            Graphics2D g = (Graphics2D)gFake;
            MiscAWT.setAA(g);
            g.setColor(this.getBackground());
            g.fillRoundRect(5, 5, 40, 40, 15, 15);
            g.setColor(this.getForeground());
            MiscAWT.drawCenteredString("" + this._value, 0, 0, 50, 50, g);
        }
    }

    private class ML
    extends MouseAdapter {
        private static final double POS_RADIUS = 70.0;

        ML() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkMouseOnPoint(e.getPoint(), true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.checkMouseOnPoint(e.getPoint(), false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.checkMouseOnPoint(e.getPoint(), false);
        }

        private void checkMouseOnPoint(Point p, boolean click) {
            if (((IngameScreen)IngameScreen.this).gs.turnState != TurnState.ChooseSafePos || ((IngameScreen)IngameScreen.this).gs.playerTurn != IngameScreen.this.gs.getMe().getNr()) {
                return;
            }
            int oldState = IngameScreen.this.mouseAtHouse;
            int atHouse = -1;
            int i = 0;
            while (i < 12) {
                boolean noPlace = false;
                int j = 0;
                while (j < ((IngameScreen)IngameScreen.this).gs.agents.length) {
                    Agent agent = ((IngameScreen)IngameScreen.this).gs.agents[j];
                    if (agent.getHouse() == i) {
                        noPlace = true;
                        break;
                    }
                    ++j;
                }
                if (!noPlace) {
                    Point mp = MediaLib.mapCoords[i][0];
                    if (Misc2D.getDistance(mp.x, mp.y, p.x, p.y) <= 70.0) {
                        atHouse = i;
                        break;
                    }
                }
                ++i;
            }
            IngameScreen.this.mouseAtHouse = atHouse;
            if (click && IngameScreen.this.mouseAtHouse != -1) {
                ((GameClient)IngameScreen.this.uif.getClient()).doAction(7, IngameScreen.this.mouseAtHouse);
            }
            if (IngameScreen.this.mouseAtHouse != oldState) {
                IngameScreen.this.uif.repaint();
            }
        }
    }

    private static enum MenuState {
        Chat,
        List,
        Stats;

    }

    private class PlayerList
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final LocalizedString strPlayerLeft;
        private final ImageIcon IconAI;
        private final PlayerPanel[] playerPanels;
        private final MyObservable<int[]> secretPaperDecision;
        public final Observable<int[]> SecretPaperDecision;

        PlayerList() {
            super(null);
            this.IconAI = new ImageIcon(MiscImg.resize(MediaLib.ai, 20, 20));
            this.secretPaperDecision = new MyObservable<Object>(null);
            this.SecretPaperDecision = this.secretPaperDecision.Getter;
            this.setBounds(0, 0, 350, 240);
            this.setOpaque(false);
            this.strPlayerLeft = new LocalizedString((ILocalizer)IngameScreen.this.localizer, "_UI_Ingame_PlayerLeft", x -> this.update());
            this.playerPanels = new PlayerPanel[7];
            int i = 0;
            while (i < this.playerPanels.length) {
                this.playerPanels[i] = new PlayerPanel(i);
                this.add(this.playerPanels[i]);
                ++i;
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Point p = e.getPoint();
                    int playerNr = (p.y - 1) / 34;
                    if (playerNr < 0 || playerNr >= IngameScreen.this.gs.getMaxPlayers()) {
                        return;
                    }
                    PlayerEntry entry = (PlayerEntry)IngameScreen.this.gs.tryGetPlayer(playerNr);
                    if (!entry.isOccupied() || entry.isMe()) {
                        return;
                    }
                    if (p.x <= 150) {
                        if (MiscAWT.isShiftDown(e) && MiscAWT.isCtrlDown(e) && ((IngameScreen)((PlayerList)PlayerList.this).IngameScreen.this).gs.IsAdmin.get() && !IngameScreen.this.gs.isSingleplayer()) {
                            ((GameClient)((PlayerList)PlayerList.this).IngameScreen.this.uif.getClient()).doAction(MiscAWT.isAltDown(e) ? 3 : 2, playerNr);
                            MediaLib.playClick();
                        }
                    } else {
                        int agentNr = -1;
                        int i = 0;
                        while (i < ((IngameScreen)((PlayerList)PlayerList.this).IngameScreen.this).gs.agents.length) {
                            if (p.x >= 220 + i * 18 && p.x < 220 + i * 18 + 16 && p.y >= 10 + playerNr * 34 && p.y < 26 + playerNr * 34) {
                                agentNr = i;
                                break;
                            }
                            ++i;
                        }
                        Agent ownAgent = ((IngameScreen)((PlayerList)PlayerList.this).IngameScreen.this).gs.OwnAgent.get();
                        if (!(agentNr < 0 || agentNr >= ((IngameScreen)((PlayerList)PlayerList.this).IngameScreen.this).gs.agents.length || ownAgent != null && agentNr == ownAgent.getNr() && ((IngameScreen)((PlayerList)PlayerList.this).IngameScreen.this).ownAgentCard.ShouldShow.get())) {
                            if (e.getButton() != 1) {
                                agentNr = -1;
                            }
                            ((PlayerEntry)IngameScreen.this.gs.tryGetPlayer(playerNr)).setThinkIsAgent(agentNr);
                            MediaLib.playClick();
                            PlayerList.this.checkSecretPaperDecision();
                            ((PlayerList)PlayerList.this).IngameScreen.this.uif.repaint();
                        }
                    }
                }
            });
        }

        private void checkSecretPaperDecision() {
            this.secretPaperDecision.set(this.checkAndCreateSecretPaperDecision());
        }

        private int[] checkAndCreateSecretPaperDecision() {
            int[] ints = new int[IngameScreen.this.gs.getMaxPlayers()];
            int i = 0;
            while (i < IngameScreen.this.gs.getMaxPlayers()) {
                PlayerEntry p = (PlayerEntry)IngameScreen.this.gs.tryGetPlayer(i);
                if (p.isPlaying() && p != IngameScreen.this.gs.getMe()) {
                    ints[i] = p.getThinkIsAgent();
                    if (ints[i] == -1) {
                        return null;
                    }
                    int j = 0;
                    while (j < i) {
                        if (ints[i] == ints[j] && ((PlayerEntry)IngameScreen.this.gs.tryGetPlayer(j)).isPlaying() && j != IngameScreen.this.gs.getMe().getNr()) {
                            return null;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return ints;
        }

        public void update() {
            if (this.playerPanels != null) {
                PlayerPanel[] playerPanelArray = this.playerPanels;
                int n = this.playerPanels.length;
                int n2 = 0;
                while (n2 < n) {
                    PlayerPanel playerPanel = playerPanelArray[n2];
                    playerPanel.update();
                    ++n2;
                }
            }
            this.checkSecretPaperDecision();
        }

        @Override
        public void paint(Graphics gFake) {
            super.paint(gFake);
            Graphics2D g = (Graphics2D)gFake;
            MiscAWT.setAA(g);
            g.setFont(MediaLib.fontPlayerList);
            int shift = 1;
            int iC = IngameScreen.this.gs.getMaxPlayers();
            Agent ownAgent = ((IngameScreen)IngameScreen.this).gs.OwnAgent.get();
            int i = 0;
            while (i < iC) {
                PlayerEntry p = (PlayerEntry)IngameScreen.this.gs.tryGetPlayer(i);
                if (p.isPlaying() && !p.isMe()) {
                    int agent = p.getThinkIsAgent();
                    int j = 0;
                    while (j < ((IngameScreen)IngameScreen.this).gs.agents.length) {
                        if (p.getLockedThinkIsAgent() == j) {
                            g.setColor(Color.DARK_GRAY);
                            g.fillRoundRect(220 + j * 18, shift + 9, 16, 16, 5, 5);
                        }
                        if (ownAgent == null || j != ownAgent.getNr() || !((IngameScreen)IngameScreen.this).ownAgentCard.ShouldShow.get()) {
                            Stroke s;
                            g.setColor(IngameScreen.this.agentShowPanels[j].getBackground());
                            g.fillRoundRect(220 + j * 18, shift + 9, 16, 16, 5, 5);
                            if (agent == j) {
                                s = g.getStroke();
                                g.setStroke(new BasicStroke(3.0f));
                                g.setColor(Color.BLACK);
                                g.drawRoundRect(220 + j * 18, shift + 9, 15, 15, 5, 5);
                                g.setStroke(s);
                            } else if (p.getLockedThinkIsAgent() == j) {
                                s = g.getStroke();
                                g.setStroke(new BasicStroke(1.0f));
                                g.setColor(Color.BLACK);
                                g.drawRoundRect(220 + j * 18, shift + 9, 15, 15, 5, 5);
                                g.setStroke(s);
                            }
                        }
                        ++j;
                    }
                }
                shift += 34;
                ++i;
            }
        }

        private final class PlayerPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private final int nr;
            private final JLabel labelPing;
            private final JLabel labelName;

            private PlayerPanel(int nr) {
                super(null);
                this.nr = nr;
                this.setOpaque(false);
                this.labelName = new JLabel();
                MiscAWT.disableHTML(this.labelName);
                this.labelName.setBounds(8, 0, 147, 34);
                this.add(this.labelName);
                this.labelName.setFont(MediaLib.fontPlayerList);
                this.labelPing = new JLabel();
                this.labelPing.setFont(MediaLib.fontPlayerList);
                this.labelPing.setBounds(155, 0, 65, 34);
                this.add(this.labelPing);
                this.setBounds(0, 1 + nr * 34, 350, 34);
                this.update();
            }

            public void update() {
                PlayerEntry player = (PlayerEntry)IngameScreen.this.gs.tryGetPlayer(this.nr);
                this.setVisible(IngameScreen.this.gs.getMaxPlayers() > this.nr);
                this.labelPing.setVisible(player.isPlaying());
                this.labelPing.setIcon(player.isAI() ? PlayerList.this.IconAI : null);
                this.labelPing.setForeground(player.isLagging() ? Color.RED : Color.DARK_GRAY);
                this.labelPing.setText(player.isAI() ? "" : player.getPing() + " ms");
                this.labelName.setText(player.isPlaying() ? player.getName() : ((PlayerList)PlayerList.this).strPlayerLeft.Text.get());
                this.labelName.setForeground(player.isPlaying() ? Color.BLACK : Color.DARK_GRAY);
                this.setBackground(((IngameScreen)((PlayerList)PlayerList.this).IngameScreen.this).gs.playerTurn == this.nr ? COLOR_PLAYERSTURN : COLOR_PLAYERINFO);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(this.getBackground());
                g.fillRoundRect(2, 2, this.getWidth() - 4, this.getHeight() - 4, 20, 10);
            }
        }
    }

    private class StatsList
    extends JPanel
    implements IDisposable {
        private static final long serialVersionUID = 1L;
        private final List<BufferedImage> statsEntries = new ArrayList<BufferedImage>();

        StatsList() {
            this.setOpaque(false);
        }

        public void init() {
            this.clear();
        }

        public void addStatsMoved(int player, int[] xMoves) {
            int total = 0;
            int i = 0;
            while (i < xMoves.length) {
                total += xMoves[i];
                ++i;
            }
            BufferedImage img = IngameScreen.createStatsImage();
            Graphics2D g = img.createGraphics();
            MiscAWT.setAA(g);
            g.setColor(Color.GRAY);
            g.fillRoundRect(0, 0, 320, 40, 10, 10);
            g.drawImage((Image)MediaLib.events[0], 5, 5, null);
            g.setColor(Color.BLACK);
            g.setFont(MediaLib.fontStats);
            MiscAWT.drawVerticalCenteredString(((PlayerEntry)IngameScreen.this.gs.tryGetPlayer(player)).getName(), 40, 5, 10, g);
            MiscAWT.drawVerticalCenteredString(IngameScreen.this.localizer.translate("_UI_Ingame_Rolled", "" + total), 40, 25, 10, g);
            int shift = 5;
            int iC = xMoves.length;
            int i2 = 0;
            while (i2 < iC) {
                int nr = iC - i2 - 1;
                Agent agent = ((IngameScreen)IngameScreen.this).gs.agents[nr];
                int newPos = agent.getHouse();
                int oldPos = Misc.modNegToPos(newPos - xMoves[nr], 12);
                shift += 23;
                if (xMoves[nr] != 0) {
                    g.setColor(IngameScreen.this.agentShowPanels[nr].getBackground());
                    g.fillRoundRect(320 - shift, 5, 22, 30, 4, 4);
                    g.setColor(agent.Color.Foreground);
                    g.setFont(MediaLib.fontStats);
                    MiscAWT.drawVerticalCenteredString(this.getHouseName(oldPos), 320 - shift + 2, 5, 10, g);
                    MiscAWT.drawVerticalCenteredString("" + xMoves[nr], 320 - shift + 2, 25, 10, g);
                    g.setFont(MediaLib.fontStatsBig);
                    MiscAWT.drawVerticalCenteredString(this.getHouseName(newPos), 320 - shift + 8, 5, 30, g);
                }
                ++i2;
            }
            g.dispose();
            this.addEntry(img);
        }

        public void addStatsSafe(int safePos, int[] xOldPoints, int[] xNewPoints) {
            BufferedImage img = IngameScreen.createStatsImage();
            Graphics2D g = img.createGraphics();
            MiscAWT.setAA(g);
            g.setColor(Color.GRAY);
            g.fillRoundRect(0, 0, 320, 40, 10, 10);
            g.drawImage((Image)MediaLib.events[1], 5, 5, null);
            g.setColor(Color.BLACK);
            g.setFont(MediaLib.fontStats);
            MiscAWT.drawVerticalCenteredString(((PlayerEntry)IngameScreen.this.gs.tryGetPlayer(((IngameScreen)IngameScreen.this).gs.playerTurn)).getName(), 40, 5, 10, g);
            MiscAWT.drawVerticalCenteredString(IngameScreen.this.localizer.translate("_UI_Ingame_AtPos", safePos == 11 ? IngameScreen.this.localizer.translate("_UI_Ingame_TheRuin") : IngameScreen.this.localizer.translate("_UI_Ingame_House", safePos)), 40, 25, 10, g);
            int shift = 5;
            int iC = xOldPoints.length;
            int i = 0;
            while (i < iC) {
                int nr = iC - i - 1;
                int dif = xNewPoints[nr] - xOldPoints[nr];
                Agent agent = ((IngameScreen)IngameScreen.this).gs.agents[nr];
                shift += 23;
                if (dif != 0) {
                    g.setColor(IngameScreen.this.agentShowPanels[nr].getBackground());
                    g.fillRoundRect(320 - shift, 5, 22, 30, 4, 4);
                    g.setColor(agent.Color.Foreground);
                    g.setFont(MediaLib.fontStats);
                    MiscAWT.drawVerticalCenteredString("" + xOldPoints[nr], 320 - shift + 2, 5, 10, g);
                    if (dif < 0) {
                        g.drawRoundRect(320 - shift, 25, 14, 10, 4, 4);
                    }
                    MiscAWT.drawVerticalCenteredString("" + dif, 320 - shift + 2, 25, 10, g);
                    g.setFont(MediaLib.fontStatsBig);
                    MiscAWT.drawVerticalCenteredString("" + xNewPoints[nr], 320 - shift + 8, 5, 30, g);
                }
                ++i;
            }
            g.dispose();
            this.addEntry(img);
        }

        public void addStatsSlot(String msg, boolean joined) {
            BufferedImage img = IngameScreen.createStatsImage();
            Graphics2D g = img.createGraphics();
            MiscAWT.setAA(g);
            g.setColor(Color.GRAY);
            g.fillRoundRect(0, 0, 320, 40, 10, 10);
            g.drawImage((Image)MediaLib.events[joined ? 2 : 3], 5, 5, null);
            g.setColor(Color.BLACK);
            g.setFont(MediaLib.fontStats);
            StringBuilder str1 = new StringBuilder();
            StringBuilder str2 = new StringBuilder();
            String[] lined = msg.split(" ");
            int numLined = 0;
            int len = 0;
            FontMetrics fm = g.getFontMetrics();
            int i = 0;
            while (i < lined.length) {
                int nextLen = fm.stringWidth(String.valueOf(lined[i]) + " ");
                if (len + nextLen > 250) break;
                str1.append(lined[i]);
                str1.append(' ');
                len += nextLen;
                ++numLined;
                ++i;
            }
            i = numLined;
            while (i < lined.length) {
                str2.append(lined[i]);
                str2.append(' ');
                ++i;
            }
            if (str2.length() == 0) {
                MiscAWT.drawVerticalCenteredString(msg, 40, 5, 30, g);
            } else {
                MiscAWT.drawVerticalCenteredString(str1.toString(), 40, 8, 10, g);
                MiscAWT.drawVerticalCenteredString(str2.toString(), 40, 22, 10, g);
            }
            g.dispose();
            this.addEntry(img);
        }

        public void addStatsPaper() {
            BufferedImage img = IngameScreen.createStatsImage();
            Graphics2D g = img.createGraphics();
            MiscAWT.setAA(g);
            g.setColor(Color.GRAY);
            g.fillRoundRect(0, 0, 320, 40, 10, 10);
            g.drawImage((Image)MediaLib.events[4], 5, 5, null);
            g.setColor(Color.BLACK);
            g.setFont(MediaLib.fontStats);
            MiscAWT.drawVerticalCenteredString(IngameScreen.this.localizer.translate("_UI_Ingame_ScoreReached", "" + ((IngameScreen)IngameScreen.this).gs.pointsForSecretPaper), 40, 8, 10, g);
            MiscAWT.drawVerticalCenteredString(IngameScreen.this.localizer.translate("_UI_Ingame_FillInSecPap"), 40, 22, 10, g);
            g.dispose();
            this.addEntry(img);
        }

        private String getHouseName(int house) {
            switch (house) {
                case 11: {
                    return "R";
                }
            }
            return "" + house;
        }

        private void addEntry(BufferedImage img) {
            this.statsEntries.add(img);
            this.recalcSize();
        }

        @Override
        public void dispose() {
            this.clear();
        }

        private void recalcSize() {
            int width = 0;
            int height = 3;
            for (BufferedImage entry : this.statsEntries) {
                height += 3;
                height += entry.getHeight();
                if (entry.getWidth() <= width) continue;
                width = entry.getWidth();
            }
            this.setSize(width + 3, height);
            this.setPreferredSize(this.getSize());
            IngameScreen.this.scrollStats.revalidate();
            MiscAWT.scrollDownContent(this);
        }

        @Override
        protected void paintComponent(Graphics gFake) {
            Graphics2D g = (Graphics2D)gFake;
            MiscAWT.setAA(g);
            super.paintComponent(g);
            int shift = 3;
            for (BufferedImage entry : this.statsEntries) {
                g.drawImage((Image)entry, 3, shift, null);
                shift += entry.getHeight() + 3;
            }
        }

        public void clear() {
            this.statsEntries.forEach(Image::flush);
            this.statsEntries.clear();
            this.recalcSize();
        }
    }
}

