/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui.screens;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.game.ITickable;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.secag.client.Agent;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.PlayerEntry;
import com.iosoft.secag.client.SecAgGameState;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.ChatArea;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.MenuButton;
import com.iosoft.secag.client.ui.TextInput;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.Screen;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JPanel;

public class GameOverScreen
extends Screen
implements ITickable {
    private static final long serialVersionUID = 1L;
    private static final int TICKS_FOR_MOVE = 30;
    private static final int TIME_IN_TICKS = 720;
    private static final Color COLOR_POINTS = new Color(110, 110, 0);
    private static final Color COLOR_RANK = new Color(0, 80, 0);
    private final SecAgGameState gs;
    private final ChatArea chatArea;
    private final TextInput textChat;
    private final AgentLabel[] agentLabels = new AgentLabel[7];
    private final MenuButton buttonReplay;
    private final MenuButton buttonQuit;

    public GameOverScreen(UserInterface ui, SecAgGameState gas) {
        super(ui);
        this.gs = gas;
        int i = 0;
        while (i < this.agentLabels.length) {
            this.agentLabels[i] = new AgentLabel(i);
            ++i;
        }
        this.chatArea = new ChatArea(10, 410, 350, 180);
        this.add(this.chatArea);
        CenterLabel labelThanks = new CenterLabel(this.localizer, "_UI_GameOver_Thanks", 370, 415, 415, 40);
        labelThanks.setForeground(Color.LIGHT_GRAY);
        this.add(labelThanks);
        CenterLabel labelThanks2 = new CenterLabel(this.localizer, "_UI_GameOver_ConceptBy", 370, 455, 415, 40);
        labelThanks2.setForeground(Color.LIGHT_GRAY);
        labelThanks2.setFont(MediaLib.fontLabelVerySmall);
        this.add(labelThanks2);
        this.textChat = new TextInput(370, 555, 415, 35, 50);
        this.textChat.addActionListener(evt -> {
            String text = this.textChat.getText();
            this.textChat.setText("");
            ((GameClient)this.uif.getClient()).chat(text, 0);
        });
        this.textChat.setFont(MediaLib.fontInputSmall);
        this.textChat.setBackground(Color.WHITE);
        this.textChat.setHorizontalAlignment(2);
        this.add(this.textChat);
        this.buttonReplay = new MenuButton(this.localizer, "_UI_GameOver_PlayAgain", 370, 500, 202, 40, () -> {
            ((GameClient)this.uif.getClient()).doAction(9);
            if (!this.gs.IsAdmin.get() && this.gs.HostWantsRestart.get()) {
                this.gs.restart();
                this.uif.checkGameState(this.gs.GameInProgress.get());
            }
        });
        this.add(this.buttonReplay);
        gas.HostWantsRestart.bind(x -> this.checkRestart());
        this.buttonQuit = new MenuButton(this.localizer, "_UI_GameOver_Leave", 583, 500, 202, 40, () -> {
            if (((GameClient)this.uif.getClient()).isFullyConnected()) {
                ((GameClient)this.uif.getClient()).quit();
            } else {
                this.uif.setMainMenu();
            }
        });
        this.add(this.buttonQuit);
        gas.IsAdmin.bind(x -> this.checkRestart());
    }

    public void onFadeDone() {
        this.uif.addTickable(this);
    }

    @Override
    public boolean tick() {
        boolean done = true;
        int i = 0;
        while (i < this.gs.agents.length) {
            if (this.agentLabels[i].tick()) {
                done = false;
            }
            ++i;
        }
        this.revalidate();
        this.repaint();
        return !done;
    }

    @Override
    protected void paintComponent(Graphics gFake) {
        super.paintComponent(gFake);
        Graphics2D g = (Graphics2D)gFake;
        MiscAWT.setAA(g);
        g.drawImage((Image)MediaLib.background, 0, 0, null);
    }

    public void setChat(String text) {
        this.chatArea.setText(text);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void init() {
        this.uif.addTickable(this);
        MediaLib.SoundGameOver.play();
        this.checkRestart();
        ArrayList<Agent> agents = new ArrayList<Agent>(Arrays.asList(this.gs.agents));
        agents.sort(Comparator.comparingInt(x -> -x.getRealPoints()));
        int lastRank = 1;
        int i = 0;
        while (i < this.gs.agents.length) {
            Agent a = (Agent)agents.get(i);
            lastRank = i > 0 && ((Agent)agents.get(i - 1)).getRealPoints() == a.getRealPoints() ? lastRank : i + 1;
            a.setRank(lastRank);
            ++i;
        }
        int numAgents = this.gs.agents.length;
        int timePerAgent = 720 / numAgents;
        int i2 = 0;
        while (i2 < this.agentLabels.length) {
            this.remove(this.agentLabels[i2]);
            if (i2 < numAgents) {
                Agent a = (Agent)agents.get(i2);
                this.agentLabels[i2].init(timePerAgent * (numAgents - i2 - 1), a);
                this.add(this.agentLabels[i2]);
            }
            ++i2;
        }
    }

    public void checkRestart() {
        this.buttonReplay.setEnabled(this.gs.isConnected() && (this.gs.IsAdmin.get() || this.gs.HostWantsRestart.get()));
    }

    private class AgentLabel
    extends JPanel
    implements IDisposable {
        private static final long serialVersionUID = 1L;
        private static final int EXPOSED_START = 350;
        private static final int EXPOSED_END = 710;
        private static final int EXPOSED_LENGTH = 360;
        private int nr;
        private int visible;
        private int counter;
        private BufferedImage prerendered;
        private static final int WIDTH = 770;
        private static final int HEIGHT = 55;

        AgentLabel(int nr) {
            this.nr = nr;
            this.setOpaque(false);
        }

        public boolean tick() {
            if (this.visible == 30) {
                return false;
            }
            if (this.counter < 0) {
                ++this.counter;
            } else {
                ++this.visible;
                this.setBounds(15, 15 + this.nr * 55 + (int)(120.0 * Misc.smootherstep((double)(30 - this.visible) / 60.0)), 770, 55);
            }
            return true;
        }

        @Override
        public void dispose() {
            if (this.prerendered != null) {
                this.prerendered.flush();
            }
        }

        public void init(int atTime, Agent a) {
            this.setBounds(0, 0, 770, 55);
            PlayerEntry player = MiscLINQ.firstOrDefault(GameOverScreen.this.gs.enumeratePlayingPlayers(), x -> x.getRealAgent() == a);
            this.counter = -atTime;
            this.visible = 0;
            this.setBackground(MiscAWT.setAlpha(a.Color.Background, 100));
            if (this.prerendered != null) {
                this.prerendered.flush();
            }
            this.prerendered = MiscImg.createCompatibleImage(770, 55);
            Graphics2D g = this.prerendered.createGraphics();
            MiscAWT.setAA(g);
            g.setFont(MediaLib.fontBigEnd);
            g.setColor(COLOR_RANK);
            MiscAWT.drawShadowedCenteredString(a.getRank() + ".", 0, 0, 50, 50, g);
            g.drawImage((Image)a.Color.Image, 35, 5, null);
            g.setColor(Color.BLACK);
            if (player != null) {
                g.setColor(Color.BLACK);
                MiscAWT.drawVerticalCenteredString(player.getName(), 75, 0, 50, g);
                if (player.isAI()) {
                    g.drawImage((Image)MediaLib.ai, 80 + g.getFontMetrics().stringWidth(player.getName()), 5, null);
                }
            } else {
                String anonymous = GameOverScreen.this.localizer.translate("_UI_GameOver_Anonymous");
                g.setColor(Color.BLACK);
                MiscAWT.drawVerticalCenteredString(anonymous, 74, -1, 50, g);
                g.setColor(Color.DARK_GRAY);
                MiscAWT.drawVerticalCenteredString(anonymous, 75, 0, 50, g);
            }
            g.setColor(COLOR_POINTS);
            MiscAWT.drawShadowedCenteredString("" + a.getRealPoints(), 710, 0, 50, 50, g);
            if (((GameOverScreen)GameOverScreen.this).gs.useSecretPaper) {
                g.setFont(MediaLib.fontExposed);
                g.setColor(Color.BLACK);
                String[] exposers = a.getDiscoverers();
                int uncovPoints = a.getUncoverPoints();
                if (exposers.length > 0) {
                    int len;
                    if (uncovPoints > 0) {
                        MiscAWT.drawCenteredString(GameOverScreen.this.localizer.translate("_UI_GameOver_Bonus", uncovPoints, GameOverScreen.this.localizer.translate("_UI_GameOver_ExposedBy")), 350, 0, 360, 16, g);
                    } else {
                        MiscAWT.drawCenteredString(GameOverScreen.this.localizer.translate("_UI_GameOver_ExposedBy"), 350, 0, 360, 16, g);
                    }
                    String line1 = exposers[0];
                    String line2 = "";
                    int atExp = 1;
                    FontMetrics fm = g.getFontMetrics();
                    while (exposers.length > atExp) {
                        String futureLine1 = String.valueOf(line1) + ", " + exposers[atExp];
                        len = fm.stringWidth(futureLine1);
                        if (len > 360) break;
                        line1 = futureLine1;
                        ++atExp;
                    }
                    if (atExp < exposers.length) {
                        line1 = String.valueOf(line1) + ",";
                        line2 = exposers[atExp];
                        ++atExp;
                        while (exposers.length > atExp) {
                            String futureLine2 = String.valueOf(line2) + ", " + exposers[atExp];
                            len = fm.stringWidth(futureLine2);
                            if (len > 360) break;
                            line2 = futureLine2;
                            ++atExp;
                        }
                    }
                    if (atExp < exposers.length) {
                        line2 = String.valueOf(line2) + ", ...";
                    }
                    MiscAWT.drawCenteredString(line1, 350, 18, 360, 16, g);
                    MiscAWT.drawCenteredString(line2, 350, 32, 360, 16, g);
                } else if (uncovPoints > 0) {
                    MiscAWT.drawCenteredString(GameOverScreen.this.localizer.translate("_UI_GameOver_Bonus", uncovPoints, GameOverScreen.this.localizer.translate("_UI_GameOver_Hidden", 10)), 350, 0, 360, 50, g);
                } else {
                    MiscAWT.drawCenteredString(GameOverScreen.this.localizer.translate("_UI_GameOver_Hidden", 10), 350, 0, 360, 50, g);
                }
            }
            g.dispose();
        }

        @Override
        protected void paintComponent(Graphics gFake) {
            Graphics2D g = (Graphics2D)gFake;
            MiscAWT.setAA(g);
            Composite c = MiscAWT.setAlpha(g, Math.min(1.0f, (float)this.visible / 30.0f));
            g.setColor(this.getBackground());
            g.fillRoundRect(0, 0, 770, 50, 50, 50);
            g.drawImage((Image)this.prerendered, 0, 0, null);
            g.setComposite(c);
        }
    }
}

