/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui.screens;

import com.iosoft.helpers.HtmlEscape;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.web.ExternalIP;
import com.iosoft.ioengine.app.server.DedicatedInfo;
import com.iosoft.ioengine.game.server.GameDedicatedInfo;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.Screen;
import com.iosoft.secag.server.GameServer;
import com.iosoft.secag.server.SecAgDedicatedInfo;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DediScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private final JTextField textDedi;
    private final JTextField textDediIP;
    private final JEditorPane dediChat;
    private final JEditorPane dediPlayers;
    private final TrayIcon trayIcon;
    private final GameServer server;
    private JFrame window;
    private Task<String> extIPGetter;
    private IDisposable serverInfoGetterCancel;
    private boolean minimized = false;

    public DediScreen(UserInterface ui) {
        super(ui);
        this.server = (GameServer)((SecretAgents)ui.getGame()).getServer();
        this.textDediIP = new JTextField();
        this.textDediIP.setBackground(Color.WHITE);
        this.textDediIP.setEditable(false);
        this.textDediIP.setFont(MediaLib.fontInput);
        this.textDediIP.setBounds(500, 70, 280, 30);
        this.textDediIP.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add(this.textDediIP);
        this.dediPlayers = new JEditorPane("text/html", "");
        this.dediPlayers.setEditable(false);
        this.dediPlayers.setFont(MediaLib.fontLabel);
        this.dediPlayers.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JScrollPane dediPlayersScroller = new JScrollPane(this.dediPlayers);
        dediPlayersScroller.setBounds(10, 150, 780, 440);
        this.add(dediPlayersScroller);
        JButton buttonClose = new JButton("Close server");
        buttonClose.setFont(MediaLib.fontInputSmall);
        buttonClose.setOpaque(false);
        buttonClose.setBounds(595, 15, 185, 40);
        buttonClose.addActionListener(evt -> {
            this.server.stop();
            this.uif.setMainMenu();
        });
        this.add(buttonClose);
        JButton buttonTray = new JButton("Tray");
        buttonTray.setFont(MediaLib.fontInputSmall);
        buttonTray.setOpaque(false);
        buttonTray.setBounds(500, 15, 80, 40);
        this.add(buttonTray);
        this.textDedi = new JTextField();
        this.textDedi.setBounds(500, 110, 280, 30);
        this.textDedi.setText("");
        this.textDedi.setFont(MediaLib.fontInput);
        this.textDedi.addActionListener(evt -> {
            this.server.onDedicatedInput(this.textDedi.getText());
            this.textDedi.setText("");
        });
        this.add(this.textDedi);
        this.dediChat = new JEditorPane("text/plain", "");
        this.dediChat.setEditable(false);
        this.dediChat.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JScrollPane dediChatScroller = new JScrollPane(this.dediChat);
        dediChatScroller.setBounds(10, 10, 480, 130);
        this.add(dediChatScroller);
        if (!SystemTray.isSupported()) {
            this.trayIcon = null;
            buttonTray.setEnabled(false);
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        this.trayIcon = new TrayIcon(MediaLib.icon);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(evt -> {
            tray.remove(this.trayIcon);
            this.window.setVisible(true);
            this.minimized = false;
        });
        buttonTray.addActionListener(evt -> {
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException ex) {
                Log.UI.errorShort("TrayIcon could not be added", ex);
                return;
            }
            this.minimized = true;
            this.window = (JFrame)this.getTopLevelAncestor();
            this.window.dispose();
        });
    }

    @Override
    public void reset() {
        super.reset();
        if (this.extIPGetter != null) {
            this.extIPGetter.cancel();
            this.extIPGetter = null;
        }
        if (this.serverInfoGetterCancel != null) {
            this.serverInfoGetterCancel.dispose();
            this.serverInfoGetterCancel = null;
        }
    }

    public void setDediInfo(SecAgDedicatedInfo info) {
        if (info == null) {
            this.dediPlayers.setText("server offline?!");
            return;
        }
        StringBuilder text = new StringBuilder();
        text.append("<html><body><h2>Server name: <u><i>");
        text.append(HtmlEscape.sanitizeForLabel(info.serverName));
        text.append("</i></u></h2><h3>Players: ");
        text.append(info.connectedClients);
        text.append(" / ");
        text.append(info.maxClients);
        text.append(" (+");
        text.append(info.numAIs);
        text.append(" AI) - Total: ");
        text.append(DedicatedInfo.time2String(info.time_running));
        text.append(" - Current game: ");
        text.append(DedicatedInfo.time2String(info.time_sessionRunning));
        text.append("</h3>");
        if (info.noNetwork) {
            text.append("<h3><font color=\"#FF0000\">NETWORK COULD NOT BE STARTED, PORT PROBABLY ALREADY IN USE!</font></h3>");
        }
        text.append("In progress: <b>");
        text.append(info.inProgress ? "yes" : "no");
        text.append("</b> | ");
        text.append("Open game: <b>");
        text.append(info.open ? "yes" : "no");
        text.append("</b> | ");
        text.append("Limit: <b>");
        text.append(info.limit);
        if (info.useSecretPaper) {
            text.append(" (");
            text.append(info.secretPaperLimit);
            text.append(")");
        }
        if (info.inProgress) {
            text.append(" / ");
            text.append(info.maxScore);
        }
        text.append("</b><br>");
        text.append("State - Name - IP - Ping - Admin - Version<br>");
        int iC = info.clients.length;
        int i = 0;
        while (i < iC) {
            GameDedicatedInfo.GameClientSlot p = (GameDedicatedInfo.GameClientSlot)info.clients[i];
            text.append(i + ": ");
            if (p != null) {
                text.append(p.greeted ? "rdy" : "w4g");
                if (p.name != null) {
                    text.append(" - ");
                    text.append(HtmlEscape.sanitizeForLabel(p.name));
                    text.append(" - ");
                    text.append(p.ip == null ? "local" : HtmlEscape.sanitizeForLabel(p.ip));
                    text.append(" - ");
                    text.append(p.ping);
                    text.append(" - ");
                    text.append(p.admin);
                    text.append(" - ");
                    text.append(HtmlEscape.sanitizeForLabel(p.version));
                }
            } else {
                text.append("-");
            }
            text.append("<br>");
            ++i;
        }
        text.append("</body></html>");
        this.dediPlayers.setText(text.toString());
        if (this.trayIcon != null) {
            this.trayIcon.setToolTip("Secret Agents " + ((SecretAgents)this.uif.getGame()).getVersion() + " Dedicated Server\n" + "Total: " + DedicatedInfo.time2String(info.time_running) + "\n" + "Current game: " + DedicatedInfo.time2String(info.time_sessionRunning) + "\n" + info.connectedClients + " / " + info.maxClients);
        }
    }

    public void addChatMsg(String msg) {
        this.dediChat.setText(String.valueOf(this.dediChat.getText()) + "\n" + msg);
        MiscAWT.scrollDownContent(this.dediChat);
    }

    public void init(String ip, int port) {
        this.textDediIP.setText(String.valueOf(ip) + ":" + port);
        this.dediChat.setText("");
        this.addChatMsg("Looking for best external IP...");
        this.extIPGetter = ExternalIP.getAsync(true);
        this.extIPGetter.await((String)((Object)((Consumer<String>)ipFound -> {
            this.extIPGetter = null;
            this.addChatMsg("Best external IP found: " + ipFound);
        })));
        this.serverInfoGetterCancel = Dispatcher.getForCurrentThread().repeat(1.0, () -> this.setDediInfo((SecAgDedicatedInfo)this.server.getDedicatedInfo()));
    }

    public boolean isMinimized() {
        return this.minimized;
    }
}

