/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui.screens;

import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.ui.awt.Picture;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.MenuButton;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.Screen;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;

public class ConnectScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private final JLabel labelConnectTo;

    public ConnectScreen(UserInterface ui) {
        super(ui);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    MediaLib.playClick();
                    ConnectScreen.this.abort();
                }
            }
        });
        this.setFocusable(true);
        Picture base = new Picture(MediaLib.background);
        base.setBounds(0, 0, 800, 600);
        this.add(base);
        this.labelConnectTo = new CenterLabel(0, 125, 800, 100);
        MiscAWT.disableHTML(this.labelConnectTo);
        this.labelConnectTo.setForeground(new Color(150, 150, 0));
        this.labelConnectTo.setFont(MediaLib.fontTitle);
        CenterLabel labelConnectState = new CenterLabel(0, 250, 800, 100);
        MiscAWT.disableHTML(labelConnectState);
        labelConnectState.setFont(MediaLib.fontTitle);
        MenuButton buttonAbort = new MenuButton(this.localizer, "_UI_Connect_Abort", 150, 450, 500, 50, this::abort);
        base.add(this.labelConnectTo);
        base.add(labelConnectState);
        base.add(buttonAbort);
        ui.connectionStepTranslated().bind(labelConnectState::setText);
    }

    private void abort() {
        ((GameClient)this.uif.getClient()).abortConnect();
    }

    @Override
    public void init() {
        super.init();
        this.requestFocusInWindow();
    }

    public void setTarget(String target) {
        this.labelConnectTo.setText(target);
    }
}

