/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.ui.awt.ErrorScreen;
import com.iosoft.ioengine.game.ui.GameUI;
import com.iosoft.iogame.Game;
import com.iosoft.iogame.ui.awt.AWTFullscreenHelper;
import com.iosoft.iogame.ui.awt.FaderFactory;
import com.iosoft.iogame.ui.awt.GenericWindow;
import com.iosoft.iogame.ui.awt.IWindowModel;
import com.iosoft.iogame.updateoverlay.UpdateOverlay;
import com.iosoft.iogame.updateoverlay.UpdateOverlayService;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.Settings;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.SecAgGameState;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.screens.ConnectScreen;
import com.iosoft.secag.client.ui.screens.DediScreen;
import com.iosoft.secag.client.ui.screens.DisconnectedScreen;
import com.iosoft.secag.client.ui.screens.GameOverScreen;
import com.iosoft.secag.client.ui.screens.IngameScreen;
import com.iosoft.secag.client.ui.screens.IntroScreen;
import com.iosoft.secag.client.ui.screens.LoadScreen;
import com.iosoft.secag.client.ui.screens.LobbyScreen;
import com.iosoft.secag.client.ui.screens.MainMenuScreen;
import com.iosoft.secag.client.ui.screens.Screen;
import com.iosoft.secag.client.ui.screens.ServerBrowserScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UserInterface
extends GameUI<GameClient, SecAgGameState, SecretAgents> {
    public static final int APP_WIDTH = 800;
    public static final int APP_HEIGHT = 600;
    private Container content;
    private Screen currentScreen;
    private MainMenuScreen screenMM;
    private LobbyScreen screenLobby;
    private IngameScreen screenIngame;
    private GameOverScreen screenGameOver;
    private DediScreen screenDedi;
    private LoadScreen screenLoad;
    private ConnectScreen screenConnect;
    private DisconnectedScreen screenDisconnected;
    private ServerBrowserScreen screenSB;
    private IntroScreen screenIntro;
    private GenericWindow _genericWindow;
    private boolean backToBrowser;
    private final FaderFactory faderFactory = new FaderFactory(this::addFader, x -> this.content.remove((Component)x), () -> ((SecretAgents)this.game).isDevmode() || ((SecretAgents)this.game).isDedicated(), this::addTickable);
    private UpdateOverlayService updateOverlayService;
    private boolean introSkipped = false;

    @Override
    protected void initialize() {
        this.updateOverlayService = new UpdateOverlayService((Game<?>)this.getGame(), this, "https://para-welt.com/main/ayce/secag/", MediaLib::playClick, this::setUpdateOverlayVisible);
        this.updateOverlayService.LabelFactory = CenterLabel::new;
    }

    @Override
    public void onImportantLoaded() {
        this.screenLoad = new LoadScreen(this);
        IWindowModel windowModel = new IWindowModel(){

            @Override
            public File onTakeScreenshot() {
                return ((Settings)((SecretAgents)((UserInterface)UserInterface.this).game).Settings).getScreenshotsPath();
            }

            @Override
            public void onClose() {
                if (UserInterface.this.screenDedi == null || !UserInterface.this.screenDedi.isMinimized()) {
                    ((SecretAgents)UserInterface.this.game).shutDown();
                    UserInterface.this.setScreen(null);
                }
            }
        };
        JFrame frame = new JFrame();
        frame.setIconImage(MediaLib.icon);
        this.content = frame.getContentPane();
        this.content.setPreferredSize(new Dimension(800, 600));
        this.content.setLayout(null);
        frame.setResizable(false);
        this.localizer.bind("_GameName", x -> frame.setTitle(String.valueOf(x) + (((SecretAgents)this.game).isDedicated() ? " " + ((SecretAgents)this.game).getVersion() + " Dedicated Server" : "")));
        this._genericWindow = new GenericWindow(frame, null, windowModel, null);
        this._genericWindow.AWTFullscreenHelper.setSize(((SecretAgents)this.game).isDedicated() ? AWTFullscreenHelper.SizeMode.INACTIVE : AWTFullscreenHelper.SizeMode.S_800_x_600);
        this.setScreen(this.screenLoad);
        frame.pack();
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    @Override
    public void onLoaded() {
        this.updateOverlayService.makeFonts(MediaLib.fontInput);
        this.updateOverlayService.FontGameName = MediaLib.fontInput.deriveFont(1, 15.0f);
        this.screenIntro = new IntroScreen(this);
        this.screenMM = new MainMenuScreen(this);
        if (((SecretAgents)this.game).isDedicated()) {
            this.screenDedi = new DediScreen(this);
        } else {
            this.screenLobby = new LobbyScreen(this, (SecAgGameState)this.gs);
            this.screenConnect = new ConnectScreen(this);
            this.screenDisconnected = new DisconnectedScreen(this);
            this.screenIngame = new IngameScreen(this, (SecAgGameState)this.gs);
            this.screenGameOver = new GameOverScreen(this, (SecAgGameState)this.gs);
            this.screenSB = new ServerBrowserScreen(this);
        }
        ((SecAgGameState)this.gs).bindCheckInProgressWhenConnected(this::checkGameState);
        this.doFader(() -> this.setScreen(this.screenIntro), () -> VTask.delay(((SecretAgents)this.game).isDevmode() ? 0.0 : 2.5).await(this::skipIntro), true);
    }

    private void setScreen(Screen screen) {
        if (((SecretAgents)this.game).isStopped()) {
            return;
        }
        if (this.currentScreen != null) {
            this.currentScreen.reset();
            this.content.remove(this.currentScreen);
        }
        this.currentScreen = screen;
        if (screen != null) {
            this.content.add(screen);
            screen.init();
        }
        this._genericWindow.redraw();
    }

    @Override
    protected void setConnectTargetTranslated(String target) {
        this.screenConnect.setTarget(target);
        this.screenDisconnected.setTarget(target);
    }

    @Override
    public void onConnecting() {
        if (this.currentScreen != this.screenDisconnected) {
            this.backToBrowser = this.currentScreen == this.screenSB;
        }
        this.setScreen(this.screenConnect);
    }

    @Override
    public void onDisconnectedTranslated(TextWithArguments reason, String translated) {
        if (((SecAgGameState)this.gs).gameOver && reason.Text != "Quit") {
            ((SecAgGameState)this.gs).addSystemMsg(SecAgGameState.MsgType.CLIENT_INFO, this.localizer.translate("_Chat_Disconnected"));
            ((SecAgGameState)this.gs).addSystemMsg(SecAgGameState.MsgType.CLIENT_INFO, translated);
        } else if (reason.Text == "Cancelled" || reason.Text == "Quit") {
            this.backFromDCScreen();
        } else {
            this.screenDisconnected.setReason(translated);
            this.setScreen(this.screenDisconnected);
        }
        this.screenGameOver.checkRestart();
    }

    private void addFader(JComponent fader) {
        fader.setBounds(0, 0, 800, 600);
        this.content.add(fader);
        this.content.setComponentZOrder(fader, 0);
    }

    public void doFader(Runnable onBlack, Runnable onDone, boolean skipInDevmode) {
        this.faderFactory.create(50, 50, onBlack, onDone, null, skipInDevmode, false);
        this.repaint();
    }

    @Override
    public void onError(Throwable ex) {
        ErrorScreen.show(this._genericWindow.Frame.getContentPane(), ex, ((SecretAgents)this.game).getFullName());
    }

    @Override
    public void onUpdateFound(String newVersion, String otherData) {
        this.updateOverlayService.showAsync(newVersion);
    }

    private void setUpdateOverlayVisible(UpdateOverlay panel, boolean show) {
        if (!show) {
            this._genericWindow.Frame.getGlassPane().setVisible(false);
            return;
        }
        panel.setWindowWidth(800);
        JPanel glassPane = new JPanel(null);
        glassPane.setOpaque(false);
        this._genericWindow.Frame.setGlassPane(glassPane);
        glassPane.setVisible(true);
        glassPane.add(panel);
        if (((SecretAgents)this.game).isDedicated()) {
            panel.setNonTickMode();
        }
    }

    public void setDediMode(String ip, int port) {
        this.screenDedi.init(ip, port);
        this.setScreen(this.screenDedi);
    }

    public void setMainMenu() {
        this.setScreen(this.screenMM);
    }

    public void setMainMenuJoin() {
        this.setScreen(this.screenMM);
        this.screenMM.toJoinMenu();
    }

    public void backFromDCScreen() {
        if (this.backToBrowser) {
            this.setServerBrowser();
        } else {
            this.setMainMenu();
        }
    }

    public void setServerBrowser() {
        this.setScreen(this.screenSB);
    }

    public void checkGameState(boolean inProgress) {
        if (!((SecAgGameState)this.gs).gameOver || ((SecAgGameState)this.gs).IsAdmin.get() || inProgress) {
            ((SecAgGameState)this.gs).restart();
            this.setScreen(inProgress ? this.screenIngame : this.screenLobby);
        }
    }

    public void update() {
        this.screenLobby.update();
        this.screenIngame.update();
        this.screenGameOver.checkRestart();
        this.repaint();
    }

    public void onGameOver() {
        this.doFader(() -> {
            this.screenGameOver.init();
            this.setScreen(this.screenGameOver);
        }, this.screenGameOver::onFadeDone, false);
    }

    public void setChat(String text) {
        this.screenLobby.setChat(text);
        this.screenIngame.setChat(text);
        this.screenGameOver.setChat(text);
    }

    public void repaint() {
        this._genericWindow.Frame.repaint();
    }

    public AWTFullscreenHelper getFullscreen() {
        return this._genericWindow.AWTFullscreenHelper;
    }

    @Override
    public void addDediChat(String str) {
        this.screenDedi.addChatMsg(str);
    }

    public ServerBrowserScreen getServerBrowser() {
        return this.screenSB;
    }

    public void skipIntro() {
        if (!this.introSkipped) {
            this.introSkipped = true;
            this.doFader(() -> {
                this.setScreen(this.screenMM);
                this.screenIntro = null;
            }, () -> {
                if (((SecretAgents)this.game).isDedicated()) {
                    ((GameClient)this.client).shutdown();
                }
                ((SecretAgents)this.game).canLaunchConnectNow();
            }, true);
        }
    }
}

