/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ui.awt.GameText;
import com.iosoft.secag.client.ui.MediaLib;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;

public class TextInput
extends GameText {
    private static final long serialVersionUID = 1L;
    private int imgX;
    private int imgY;
    private int imgW;
    private int imgH;
    private boolean renderBG;

    public TextInput(String text, int x, int y, int w, int h) {
        super(text, MediaLib.fontInput, null);
        this.setBounds(x, y, w, h);
        this.renderBG = true;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.setForeground(Color.BLACK);
        this.setBackground(Color.LIGHT_GRAY);
        this.setHorizontalAlignment(0);
    }

    public TextInput(String text, int x, int y, int w, int h, int maxChars) {
        this(text, x, y, w, h);
        this.setMaxChars(maxChars);
    }

    public TextInput(int x, int y, int w, int h, int maxChars) {
        this(x, y, w, h);
        this.setMaxChars(maxChars);
    }

    public TextInput(int x, int y, int w, int h) {
        this("", x, y, w, h);
    }

    public TextInput(int x, int y, int w, int h, ActionListener al) {
        this("", x, y, w, h);
        this.addActionListener(Misc.notNull(al));
    }

    public TextInput(String text, int x, int y, int w, int h, ActionListener al, int maxChars) {
        this(text, x, y, w, h, maxChars);
        this.addActionListener(Misc.notNull(al));
    }

    public void setRenderBG(boolean renderBG) {
        this.renderBG = renderBG;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.imgW = w;
        this.imgH = h;
        this.imgX = Misc.getRandomInt(800 - this.imgW);
        this.imgY = Misc.getRandomInt(600 - this.imgH);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.renderBG) {
            g.drawImage(MediaLib.buttonBackground[3], 0, 0, this.imgW, this.imgH, this.imgX, this.imgY, this.imgX + this.imgW, this.imgY + this.imgH, null);
        }
        super.paintComponent(g);
    }
}

