/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.secag.client.ui.BGPanel;
import com.iosoft.secag.client.ui.CenterLabel;
import com.iosoft.secag.client.ui.MediaLib;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;

public class SelectPanel
extends BGPanel {
    private static final long serialVersionUID = 1L;
    private static final Color COLOR_SELECTED = new Color(100, 100, 255, 150);
    private static final Color COLOR_OMO = new Color(255, 255, 100, 50);
    private final CenterLabel label;
    private ActionListener[] actionListeners = new ActionListener[0];
    private boolean selected;
    private boolean omo;

    public SelectPanel(ILocalizer translator, String text, int x, int y, int w, int h) {
        super(null);
        this.label = new CenterLabel(translator, text, 0, 0, w, h);
        this.label.setFont(MediaLib.fontInputSmall);
        this.add(this.label);
        this.setSelected(false);
        this.setBounds(x, y, w, h);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MediaLib.playClick();
                SelectPanel.this.selected = !SelectPanel.this.selected;
                SelectPanel.this.fireAction();
                SelectPanel.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                SelectPanel.this.omo = true;
                SelectPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                SelectPanel.this.omo = false;
                SelectPanel.this.repaint();
            }
        });
    }

    protected void fireAction() {
        ActionEvent e = new ActionEvent(this, 1001, "clicked");
        ActionListener[] actionListenerArray = this.actionListeners;
        int n = this.actionListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener actionListener = actionListenerArray[n2];
            actionListener.actionPerformed(e);
            ++n2;
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void checkSelected() {
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.selected) {
            g.setColor(COLOR_SELECTED);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.omo) {
            g.setColor(COLOR_OMO);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.label != null) {
            this.label.setBounds(0, 0, w, h);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        ArrayList<ActionListener> list = new ArrayList<ActionListener>(Arrays.asList(this.actionListeners));
        list.add(actionListener);
        this.actionListeners = list.toArray(new ActionListener[list.size()]);
    }
}

