/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.secag.client.ui.MediaLib;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SecAgCheckbox
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean checked;
    private ActionListener[] als;
    protected int imgX;
    protected int imgY;
    protected int imgW;
    protected int imgH;
    private static final Color COLOR_DISABLED = new Color(127, 127, 127, 127);
    private Shape clip;

    public SecAgCheckbox(int x, int y, int width, int height, boolean startChecked) {
        this.setBounds(x, y, width, height);
        this.als = new ActionListener[0];
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SecAgCheckbox.this.isEnabled()) {
                    MediaLib.playClick();
                    SecAgCheckbox.this.checked = !SecAgCheckbox.this.checked;
                    SecAgCheckbox.this.repaint();
                    SecAgCheckbox.this.doClick(true);
                }
            }
        });
        this.checked = startChecked;
        this.setBackground(Color.WHITE);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.imgW = w;
        this.imgH = h;
        this.imgX = Misc.getRandomInt(800 - this.imgW);
        this.imgY = Misc.getRandomInt(600 - this.imgH);
        float qX = (float)this.imgW / 4.0f;
        float qY = (float)this.imgH / 4.0f;
        this.clip = new RoundRectangle2D.Float(qX, qY, qX * 2.0f, qY * 2.0f, qX, qY);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.repaint();
    }

    public void addActionListener(ActionListener al) {
        int iC = this.als.length;
        ActionListener[] temp = new ActionListener[iC + 1];
        int i = 0;
        while (i < iC) {
            temp[i] = this.als[i];
            ++i;
        }
        temp[iC] = al;
        this.als = temp;
    }

    public void sendEvt() {
        this.doClick(false);
    }

    public void doClick(boolean sound) {
        int iC = this.als.length;
        int i = 0;
        while (i < iC) {
            this.als[i].actionPerformed(new ActionEvent(this, 1001, sound ? "click3" : "nosound"));
            ++i;
        }
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        MiscAWT.setAA(g);
        g.drawImage(MediaLib.buttonBackground[3], 0, 0, this.imgW, this.imgH, this.imgX, this.imgY, this.imgX + this.imgW, this.imgY + this.imgH, null);
        if (this.checked) {
            g.setColor(Color.BLACK);
            g.fill(this.clip);
        }
        if (!this.isEnabled()) {
            g.setColor(COLOR_DISABLED);
            g.fillRect(0, 0, this.imgW, this.imgH);
        }
    }
}

