/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.game.ITickable;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.secag.client.AgentColor;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.UserInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class OwnAgentCard
extends JPanel
implements ITickable {
    private static final long serialVersionUID = 1L;
    private static final int TURNAROUND_SPEED = 50;
    private int _progress;
    private BufferedImage agentImg;
    private String[] text;
    private final UserInterface uif;
    private final MyBoolObservable shouldShow = new MyBoolObservable(false);
    public final BoolObservable ShouldShow;

    public OwnAgentCard(UserInterface ui) {
        super(new BorderLayout());
        this.ShouldShow = this.shouldShow.Getter;
        this.uif = ui;
        ui.getLocalizer().bind("_UI_Ingame_ShowOwnAgent", x -> {
            this.text = x.split("\n");
            String[] stringArray = this.text;
        });
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel clicker = new JPanel();
        clicker.setOpaque(false);
        clicker.setCursor(Cursor.getPredefinedCursor(12));
        clicker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OwnAgentCard.this.setShouldShow(!OwnAgentCard.this.ShouldShow.get());
                MediaLib.playClick();
            }
        });
        this.add(clicker);
    }

    @Override
    public boolean tick() {
        if (this.ShouldShow.get()) {
            if (this._progress >= 50) {
                return false;
            }
            ++this._progress;
        } else if (this._progress > 0) {
            --this._progress;
        } else {
            return false;
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint();
        }
        return true;
    }

    public void init() {
        this.setShouldShow(false);
        this._progress = 0;
    }

    private void setShouldShow(boolean show) {
        this.shouldShow.set(show);
        this.uif.addTickable(this);
    }

    public void setAgent(AgentColor color, boolean show) {
        this.agentImg = color == null ? null : color.Card;
        this.setShouldShow(show);
        this._progress = show ? 50 : 0;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        boolean frontside;
        Graphics2D g = (Graphics2D)g2;
        double progress = 2.0 * Misc.smootherstep((float)this._progress / 50.0f);
        boolean bl = frontside = progress > 1.0;
        if (frontside) {
            progress = 2.0 - progress;
        }
        AffineTransform t = g.getTransform();
        if (progress > 0.0) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.translate(100.0, 75.0);
            g.scale(1.0 - progress, 1.0 - progress * 0.2);
            g.rotate(progress);
            g.translate(-100.0, -75.0);
        }
        if (frontside) {
            g.drawImage((Image)this.agentImg, 0, 0, null);
        } else {
            g.setColor(Color.WHITE);
            g.setFont(MediaLib.fontLabel);
            int iC = this.text.length;
            int offset = -23 * (iC - 1) / 2;
            int i = 0;
            while (i < iC) {
                MiscAWT.drawShadowedCenteredString(this.text[i], 0, offset + i * 23, 200, 150, g);
                ++i;
            }
        }
        g.setTransform(t);
    }
}

