/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.ui.awt.GameButton;
import com.iosoft.secag.client.ui.MediaLib;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;

public class MenuButton
extends GameButton {
    private static final long serialVersionUID = 1L;
    private int imgX;
    private int imgY;
    private int imgW;
    private int imgH;
    public boolean PlayClick = true;

    public MenuButton() {
        this.setForeground(Color.BLACK);
        this.setBackground(Color.LIGHT_GRAY);
        this.setFont(MediaLib.fontButton);
        this.borderUp = BorderFactory.createBevelBorder(0, Color.GRAY, Color.DARK_GRAY);
        this.borderDown = BorderFactory.createBevelBorder(1, Color.GRAY, Color.DARK_GRAY);
        this.setState();
        this.addActionListener(evt -> {
            if (this.PlayClick) {
                MediaLib.playClick();
            }
        });
    }

    public MenuButton(String text, int x, int y, int w, int h) {
        this();
        this.setText(text);
        this.setBounds(x, y, w, h);
    }

    public MenuButton(ILocalizer translator, String text, int x, int y, int w, int h) {
        this(text, x, y, w, h);
        translator.bind(text, this::setText);
    }

    public MenuButton(String text, int x, int y, int w, int h, ActionListener al) {
        this(text, x, y, w, h);
        this.addActionListener(al);
    }

    public MenuButton(String text, int x, int y, int w, int h, Runnable al) {
        this(text, x, y, w, h);
        this.addActionListener(evt -> al.run());
    }

    public MenuButton(ILocalizer translator, String text, int x, int y, int w, int h, ActionListener al) {
        this(translator, text, x, y, w, h);
        this.addActionListener(al);
    }

    public MenuButton(Localizer localizer, String text, int x, int y, int w, int h, Runnable al) {
        this(text, x, y, w, h);
        localizer.bind(text, this::setText);
        this.addActionListener(evt -> al.run());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.imgW = width;
        this.imgH = height;
        this.imgX = Misc.getRandomInt(800 - this.imgW);
        this.imgY = Misc.getRandomInt(600 - this.imgH);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(MediaLib.buttonBackground[!this.isEnabled() ? 2 : (this.isClicked && this.isInButton ? 1 : 0)], 0, 0, this.imgW, this.imgH, this.imgX, this.imgY, this.imgX + this.imgW, this.imgY + this.imgH, null);
        if (this._img != null) {
            g.drawImage(this._img, ((GameButton)this).imgX, ((GameButton)this).imgY, null);
            if (!this.isEnabled()) {
                g.setColor(this.colorImageDisabled);
                g.fillRect(((GameButton)this).imgX, ((GameButton)this).imgY, ((GameButton)this).imgW, ((GameButton)this).imgH);
            }
        }
    }
}

