/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.audio.wav.SimpleSound;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.datasource.Resource;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.iogame.assets.ImageLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MediaLib {
    public static BufferedImage icon;
    public static BufferedImage background;
    public static BufferedImage background2;
    public static BufferedImage title;
    public static BufferedImage ai;
    public static BufferedImage map;
    public static BufferedImage tresor;
    public static BufferedImage intro;
    public static BufferedImage scoreEnd;
    public static BufferedImage guiLine;
    public static BufferedImage secPapLine;
    public static BufferedImage[] kick;
    public static BufferedImage[] ready;
    public static BufferedImage[] cards;
    public static BufferedImage[] upndown;
    public static BufferedImage[] agents;
    public static BufferedImage[] events;
    public static BufferedImage[] halos;
    public static BufferedImage[] score;
    public static BufferedImage[] buttonBackground;
    public static Font fontLoading;
    public static Font fontMMCopyright;
    public static Font fontTitle;
    public static Font fontLabel;
    public static Font fontLabelSmall;
    public static Font fontLabelVerySmall;
    public static Font fontInput;
    public static Font fontInputSmall;
    public static Font fontInputVerySmall;
    public static Font fontButton;
    public static Font fontPing;
    public static Font fontChat;
    public static Font fontPlayerList;
    public static Font fontBigEnd;
    public static Font fontExposed;
    public static Font fontPoints;
    public static Font fontStats;
    public static Font fontStatsBig;
    public static Font fontSBHead;
    public static Font fontSBEntry;
    public static Font fontIngameFS;
    private static List<Sound> sounds;
    public static final Sound SoundSecretPaper;
    public static final Sound SoundChat;
    public static final Sound SoundClick;
    public static final Sound SoundJoin;
    public static final Sound SoundLeave;
    public static final Sound SoundDice;
    public static final Sound SoundMove;
    public static final Sound SoundSafePlaced;
    public static final Sound SoundSafeOpened;
    public static final Sound SoundGameOver;
    public static Point[][] mapCoords;

    static {
        sounds = new ArrayList<Sound>();
        SoundSecretPaper = MediaLib.sound("hctip2", 1);
        SoundChat = MediaLib.sound("chat2", 2);
        SoundClick = MediaLib.sound("click3", 2);
        SoundJoin = MediaLib.sound("join", 2);
        SoundLeave = MediaLib.sound("leave", 2);
        SoundDice = MediaLib.sound("dice", 1);
        SoundMove = MediaLib.sound("move3", 2);
        SoundSafePlaced = MediaLib.sound("safeplaced", 1);
        SoundSafeOpened = MediaLib.sound("safe2", 1);
        SoundGameOver = MediaLib.sound("jingle2", 1);
    }

    private MediaLib() {
    }

    public static void loadImportant() throws IOException, FontFormatException {
        icon = MiscImg.loadImage("/res/gfx/icon.png");
        Font fontBase = MiscAWT.loadFontRegister("/res/sansation.ttf");
        fontLoading = fontBase.deriveFont(1, 50.0f);
        fontMMCopyright = fontBase.deriveFont(2, 20.0f);
        fontTitle = fontBase.deriveFont(1, 40.0f);
        fontLabel = fontBase.deriveFont(2, 30.0f);
        fontLabelVerySmall = fontBase.deriveFont(2, 16.0f);
        fontLabelSmall = fontBase.deriveFont(2, 22.0f);
        fontInput = fontBase.deriveFont(0, 28.0f);
        fontInputSmall = fontBase.deriveFont(0, 25.0f);
        fontInputVerySmall = fontBase.deriveFont(0, 20.0f);
        fontButton = fontBase.deriveFont(0, 30.0f);
        fontPing = fontBase.deriveFont(0, 16.0f);
        fontChat = fontBase.deriveFont(0, 14.0f);
        fontPlayerList = fontBase.deriveFont(2, 14.0f);
        fontStats = fontBase.deriveFont(2, 10.0f);
        fontStatsBig = fontBase.deriveFont(1, 12.0f);
        fontBigEnd = fontBase.deriveFont(3, 25.0f);
        fontExposed = fontBase.deriveFont(0, 14.0f);
        fontPoints = fontBase.deriveFont(2, 14.0f);
        fontSBHead = fontBase.deriveFont(1, 20.0f);
        fontSBEntry = fontBase.deriveFont(0, 16.0f);
        fontIngameFS = fontBase.deriveFont(0, 8.0f);
    }

    public static void load(boolean devmode, boolean dedi) throws IOException {
        ImageLoader img = new ImageLoader("/res/gfx/");
        intro = img.load("iosoft.png");
        background = img.load("background.jpg");
        background2 = img.load("background2.jpg");
        buttonBackground = img.load1DLeaky("background3.jpg", 1, 4);
        title = img.load("title.png");
        if (!dedi) {
            ai = img.load("ai.png");
            map = img.load("map.png");
            tresor = img.load("tresor.png");
            secPapLine = img.load("secpapline.png");
            guiLine = img.load("guiline.png");
            scoreEnd = img.load("scoreend.png");
            kick = img.load1DLeaky("kick.png", 2, 1);
            ready = img.load1DLeaky("ready.png", 3, 1);
            cards = img.load1DLeaky("cards.png", 7, 1);
            score = img.load1DLeaky("score.png", 1, 7);
            agents = img.load1DLeaky("agents.png", 7, 1);
            halos = img.load1DLeaky("halos.png", 7, 1);
            upndown = img.load1DLeaky("upndown.png", 2, 2);
            events = img.load1DLeaky("events.png", 5, 1);
            Resource resSounds = new Resource("/res/sound/sfx/");
            for (Sound sound : sounds) {
                try {
                    sound.Sound = SimpleSound.load(resSounds.getSub(String.valueOf(sound.Filename) + ".wav"), sound.Count);
                }
                catch (IOException e) {
                    Log.UI.errorShort("Sound " + sound.Filename, e);
                }
            }
            sounds = null;
        }
        mapCoords = new Point[12][8];
        int house = 0;
        int pos = 0;
        for (String line : MiscIO.getResourceAsStrings("/res/mapinfo.txt")) {
            if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
            int index = line.indexOf(44);
            if (index == -1) {
                throw new IOException("Error loading mapinfo: a line has no comma");
            }
            if (house < mapCoords.length) {
                Point p;
                int x = Misc.getAsInt(line.substring(0, index).trim());
                int y = Misc.getAsInt(line.substring(index + 1).trim());
                MediaLib.mapCoords[house][pos] = p = new Point(x, y);
            }
            if (++pos != mapCoords[0].length) continue;
            pos = 0;
            ++house;
        }
    }

    public static void destroy() {
        MediaLib.tryDestroy(icon);
        MediaLib.tryDestroy(background);
        MediaLib.tryDestroy(title);
        MediaLib.tryDestroy(ai);
        MediaLib.tryDestroy(map);
        MediaLib.tryDestroy(kick);
        MediaLib.tryDestroy(ready);
    }

    public static void tryDestroy(Image img) {
        if (img != null) {
            img.flush();
        }
    }

    public static void tryDestroy(Image[] imgs) {
        if (imgs != null) {
            int i = 0;
            while (i < imgs.length) {
                MediaLib.tryDestroy(imgs[i]);
                ++i;
            }
        }
    }

    public static void tryDestroy(Image[][] imgs) {
        if (imgs != null) {
            int i = 0;
            while (i < imgs.length) {
                MediaLib.tryDestroy(imgs[i]);
                ++i;
            }
        }
    }

    public static void playClick() {
        SoundClick.play();
    }

    private static Sound sound(String filename, int count) {
        Sound sound = new Sound(filename, count);
        sounds.add(sound);
        return sound;
    }

    public static final class Sound {
        private final String Filename;
        private final int Count;
        private SimpleSound Sound;

        private Sound(String filename, int count) {
            this.Filename = filename;
            this.Count = count;
        }

        public void play() {
            if (this.Sound != null) {
                this.Sound.play();
            }
        }
    }
}

