/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.game.ITickable;
import com.iosoft.helpers.game.ITicking;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.secag.client.ui.CenterLabel;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class EasterEggLabel
extends CenterLabel
implements ITickable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SHINING = 30;
    private int shining;
    private boolean doShining;

    public EasterEggLabel(final ITicking ticker) {
        Misc.notNull(ticker);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!EasterEggLabel.this.doShining && EasterEggLabel.this.shining == 0) {
                    ticker.addTickable(EasterEggLabel.this);
                }
                EasterEggLabel.this.doShining = true;
            }
        });
    }

    @Override
    public boolean tick() {
        if (this.shining == 0) {
            if (!this.doShining) {
                return false;
            }
            this.doShining = false;
        }
        this.shining = (this.shining + 1) % 30;
        MiscAWT.repaintWindow(this);
        return true;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.shining != 0) {
            Graphics2D g = (Graphics2D)g2;
            double progress = (double)this.shining / 30.0;
            double progressSin = Math.sin(Misc.smootherstep(progress) * Math.PI);
            double distance = progressSin * 20.0;
            double rotation = -1.5707963267948966 * (1.0 + progress);
            AffineTransform t = g.getTransform();
            g.translate(Math.cos(rotation) * distance, Math.sin(rotation) * distance);
            Composite c = MiscAWT.setAlpha(g, 1.0f - (float)progressSin);
            super.paintComponent(g);
            g.setComposite(c);
            g.setTransform(t);
        } else {
            super.paintComponent(g2);
        }
    }
}

