/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client.ui;

import com.iosoft.helpers.ui.awt.AntialiasedEditorPane;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.secag.client.ui.BGPanel;
import com.iosoft.secag.client.ui.MediaLib;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class ChatArea
extends BGPanel {
    private static final long serialVersionUID = 1L;
    private final JEditorPane editorPane;
    private final JScrollPane scrollPane;

    public ChatArea(int x, int y, int w, int h) {
        this.setBounds(x, y, w, h);
        this.setLayout(null);
        this.editorPane = new AntialiasedEditorPane("text/html", "");
        this.editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.editorPane.setFont(MediaLib.fontChat);
        this.editorPane.setEditable(false);
        this.editorPane.setOpaque(false);
        this.editorPane.setForeground(Color.BLACK);
        this.editorPane.setBackground(Color.WHITE);
        this.scrollPane = new JScrollPane(this.editorPane);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setBounds(0, 0, w, h);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.add(this.scrollPane);
    }

    @Override
    public void setOpaque(boolean op) {
        super.setOpaque(op);
        if (this.scrollPane != null) {
            this.editorPane.setOpaque(op);
            this.scrollPane.setOpaque(op);
            this.scrollPane.getViewport().setOpaque(op);
        }
    }

    public void setText(String text) {
        this.editorPane.setText(text);
        this.scrollDown();
        this.revalidate();
        this.repaint();
    }

    public void scrollDown() {
        MiscAWT.scrollDownContent(this.editorPane);
    }
}

