/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client;

import com.iosoft.helpers.HtmlEscape;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.MutableInt;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.helpers.network.ReceiverHelper;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.web.ExternalIP;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.NetUtil;
import com.iosoft.ioengine.base.IMessage;
import com.iosoft.ioengine.game.client.GameState;
import com.iosoft.ioengine.game.client.LocalPlayer;
import com.iosoft.iogame.ConsoleCommand;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.TurnState;
import com.iosoft.secag.client.Agent;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.PlayerEntry;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.UserInterface;
import com.iosoft.secag.client.ui.screens.IngameScreen;
import com.iosoft.secag.dtos.InProgressGameState;
import com.iosoft.secag.dtos.S_ChooseSafePos;
import com.iosoft.secag.dtos.S_GameOver;
import com.iosoft.secag.dtos.S_GameState;
import com.iosoft.secag.dtos.S_Moved;
import com.iosoft.secag.dtos.S_RollTheDice;
import com.iosoft.secag.dtos.S_SafePlaced;
import com.iosoft.secag.dtos.S_Status;
import com.iosoft.secag.dtos.S_TipAccepted;
import com.iosoft.secag.dtos.S_Turn;
import com.iosoft.secag.server.GameServer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class SecAgGameState
extends GameState<GameClient, PlayerEntry, UserInterface, SecretAgents> {
    public static final int MAX_CHAT_MSGS = 50;
    private static final Color[] COLORS_AGENTS = new Color[]{Color.RED, Color.BLUE, Color.YELLOW, Color.GREEN, new Color(237, 157, 38), new Color(200, 0, 200), Color.BLACK};
    private final MyBoolObservable hostWantsRestart = new MyBoolObservable(false);
    public final BoolObservable HostWantsRestart;
    public TurnState turnState;
    public int pointsForGameover;
    public int pointsForSecretPaper;
    public int playerTurn;
    public int dice;
    public int safePos;
    public int fadeIn;
    public boolean showRendertime;
    public boolean tipAccepted;
    public boolean gameOver;
    public boolean useSecretPaper;
    public boolean showLocalDebugStats;
    public Agent[] agents;
    public int[] moves;
    public IngameScreen ingameScreen;
    protected GameServer server;
    protected final List<String> chatMsgs;
    private Task<String> extIPGetter;
    private final MyObservable<Agent> ownAgent;
    public final Observable<Agent> OwnAgent;

    public SecAgGameState() {
        this.HostWantsRestart = this.hostWantsRestart.Getter;
        this.turnState = TurnState.GameOver;
        this.chatMsgs = new ArrayList<String>();
        this.ownAgent = new MyObservable<Object>(null);
        this.OwnAgent = this.ownAgent.Getter;
    }

    public static Color getAgentColor(int agentColor) {
        return COLORS_AGENTS[agentColor];
    }

    @Override
    protected UserInterface createUI() {
        return new UserInterface();
    }

    @Override
    protected void initPreUI() {
        super.initPreUI();
        this.bindCheckInProgressWhenConnected(x -> this.hostWantsRestart.set(!x));
    }

    @Override
    public void reset() {
        super.reset();
        this.restart();
        this.agents = new Agent[0];
        this.chatMsgs.clear();
        this.showRendertime = false;
    }

    public void restart() {
        this.moves = null;
        this.fadeIn = 60;
        this.tipAccepted = false;
        this.gameOver = false;
        int i = 0;
        while (i < this.players.length) {
            ((PlayerEntry)this.tryGetPlayer(i)).restart();
            ++i;
        }
    }

    @Override
    protected void onFullyConnected() {
        this.showLocalDebugStats = this.serverLocal && ((SecretAgents)((GameClient)this.client).getGame()).isDevmode();
        this.server = (GameServer)((SecretAgents)((GameClient)this.client).getGame()).getServer();
        this.buildChat();
        super.onFullyConnected();
    }

    public void render(Graphics2D g) {
        Point pnt2;
        Point pnt;
        Agent a;
        long sw_render = Stopwatch.start();
        g.drawImage((Image)MediaLib.background, 0, 0, null);
        g.drawImage((Image)MediaLib.map, 0, 0, null);
        g.setColor(Color.BLACK);
        if (this.turnState != TurnState.ChooseSafePos) {
            Point pnt3 = MediaLib.mapCoords[this.safePos][0];
            g.drawImage((Image)MediaLib.tresor, pnt3.x - MediaLib.tresor.getWidth() / 2, pnt3.y - MediaLib.tresor.getHeight() / 2, null);
        }
        Agent[] agentsZOrdered = (Agent[])this.agents.clone();
        Arrays.sort(agentsZOrdered, Comparator.comparingInt(agent -> MediaLib.mapCoords[agent.getHouse()][agent.getPos() + 1].y + agent.getShift().y));
        Agent[] agentArray = agentsZOrdered;
        int n = agentsZOrdered.length;
        int n2 = 0;
        while (n2 < n) {
            a = agentArray[n2];
            pnt = MediaLib.mapCoords[a.getHouse()][a.getPos() + 1];
            pnt2 = a.getShift();
            g.drawImage((Image)a.Color.Halo, pnt.x - 20 + pnt2.x, pnt.y - 24 + pnt2.y, null);
            ++n2;
        }
        agentArray = agentsZOrdered;
        n = agentsZOrdered.length;
        n2 = 0;
        while (n2 < n) {
            a = agentArray[n2];
            pnt = MediaLib.mapCoords[a.getHouse()][a.getPos() + 1];
            pnt2 = a.getShift();
            g.drawImage((Image)a.Color.Image, pnt.x - 20 + pnt2.x, pnt.y - 20 + pnt2.y, null);
            ++n2;
        }
        g.drawImage((Image)MediaLib.guiLine, 600, 0, null);
        int totalHeight = 206;
        int heightPerAgent = (int)((double)totalHeight / (double)this.agents.length);
        if (heightPerAgent > 50) {
            heightPerAgent = 50;
        }
        int start = 150 + totalHeight - heightPerAgent * this.agents.length;
        g.setFont(MediaLib.fontPoints);
        int i = 0;
        while (i < this.agents.length) {
            Agent a2 = this.agents[i];
            int width = Math.min((int)(a2.getDPoints() / (double)this.pointsForGameover * 195.0), 195);
            g.drawImage(MediaLib.score[a2.Color.Nr], 605, start + heightPerAgent * i, 605 + width, start + heightPerAgent * i + heightPerAgent, 0, 0, width, 50, null);
            g.drawImage(MediaLib.scoreEnd, 600 + width, start + heightPerAgent * i, 608 + width, start + heightPerAgent * i + heightPerAgent, 0, 0, 6, 50, null);
            g.setColor(a2.Color.Foreground);
            int showPoints = a2.getShowPoints();
            MiscAWT.drawVerticalCenteredString("" + showPoints, 615, start + heightPerAgent * i, heightPerAgent, g);
            if (showPoints > this.pointsForGameover) {
                MiscAWT.drawCenteredString("+", 780, start + heightPerAgent * i, 20, heightPerAgent, g);
            }
            ++i;
        }
        if (this.useSecretPaper) {
            int pos = (int)((double)this.pointsForSecretPaper / (double)this.pointsForGameover * 196.0);
            g.drawImage((Image)MediaLib.secPapLine, 601 + pos, 150, null);
        }
        if (this.showLocalDebugStats) {
            g.setFont(MediaLib.fontLabelVerySmall);
            g.setColor(Color.WHITE);
            g.drawString("sent: " + this.server.firstClientSentBytes + " bytes / " + this.server.firstClientSentPackets + " packets", 0, 15);
        }
        if (this.showRendertime) {
            g.setFont(MediaLib.fontLoading);
            g.setColor(Color.BLUE);
            g.drawString("Zeit: " + Stopwatch.getMillis(sw_render) + " ms", 0, 50);
        }
    }

    @Override
    public void tick() {
        int i;
        boolean shouldRepaint = false;
        if (this.agents != null) {
            i = 0;
            while (i < this.agents.length) {
                if (this.agents[i].convergePoints()) {
                    shouldRepaint = true;
                }
                ++i;
            }
        }
        if (this.GameInProgress.get()) {
            if (this.fadeIn > 0) {
                --this.fadeIn;
                shouldRepaint = true;
            }
            i = 0;
            while (i < this.agents.length) {
                if (this.agents[i].tick()) {
                    shouldRepaint = true;
                    break;
                }
                ++i;
            }
        }
        super.tick();
        if (shouldRepaint) {
            ((UserInterface)this.ui).repaint();
        }
    }

    @Override
    protected void onChatMsg(String msg, PlayerEntry sender) {
        this.addChatMsg(MsgType.CHAT, sender, msg);
    }

    @Override
    protected void setServerFlags(int flags) throws AppProtocolException {
        super.setServerFlags(flags);
        this.useSecretPaper = Misc.getFlag(flags, 64);
        ((UserInterface)this.ui).update();
    }

    @Override
    protected void setMaxPlayers(int newPlayers) {
        super.setMaxPlayers(newPlayers);
        ((UserInterface)this.ui).update();
    }

    @Override
    protected void setServerName(String newName) {
        super.setServerName(newName);
        if (!this.serverLocal) {
            this.addSystemMsg(MsgType.INFO, ((UserInterface)this.ui).getLocalizer().translate("_Chat_Welcome", this.serverName));
        } else if (!this.singleplayer) {
            this.addSystemMsg(MsgType.INFO, ((UserInterface)this.ui).getLocalizer().translate("_Chat_Hosting", this.serverName));
            this.extIPGetter = ExternalIP.getAsync(true);
            this.extIPGetter.await((String)((Object)((Consumer<String>)ip -> {
                this.addSystemMsg(MsgType.CLIENT_INFO, ((UserInterface)this.ui).getLocalizer().translate("_Chat_ExternalIP", ip));
                this.extIPGetter = null;
            })));
        }
    }

    @Override
    protected void readStartInfo(ReceiverHelper rh, List<IMessage> messages) throws IOException {
        super.readStartInfo(rh, messages);
        S_GameState msg = new S_GameState();
        msg.read(rh.Stream);
        messages.add(() -> this.onGameState(msg));
    }

    @Override
    protected void readStartUpdates(ReceiverHelper rh, List<IMessage> messages) throws IOException {
        super.readStartUpdates(rh, messages);
        messages.add(this.readServerUpdate(rh.Stream, 7));
    }

    @Override
    protected IMessage readServerUpdate(DataInputStream in, int nr) throws IOException {
        switch (nr) {
            case 7: {
                int iLimit = in.readUnsignedShort();
                int iSecPapLimit = in.readUnsignedShort();
                return () -> {
                    this.pointsForGameover = iLimit;
                    this.pointsForSecretPaper = iSecPapLimit;
                    if (this.isFullyConnected()) {
                        ((UserInterface)this.ui).update();
                    }
                };
            }
        }
        return super.readServerUpdate(in, nr);
    }

    @Override
    protected void processServerCommand(ConsoleCommand command) throws AppProtocolException {
        if (command.Action.equals("wrong_number_of_players") && command.Params.length == 0) {
            this.ingameScreen.plsFixThis();
        } else {
            super.processServerCommand(command);
        }
    }

    public void onGameState(S_GameState msg) throws AppProtocolException {
        if (msg.GameState == null) {
            this.setGameInProgress(false);
            return;
        }
        InProgressGameState gs = msg.GameState;
        MutableInt agentNr = new MutableInt();
        this.agents = (Agent[])Stream.of(gs.Agents).map(x -> new Agent(mutableInt.Value++, x.Color, x.House, x.Position, x.Points)).toArray(Agent[]::new);
        this.turnState = gs.State;
        this.playerTurn = NetUtil.rangeExclusive(gs.PlayerAtTurn, this.getMaxPlayers());
        this.dice = gs.Dice;
        this.safePos = gs.SafePos;
        this.ownAgent.set(this.agents[gs.MyAgent]);
        this.setGameInProgress(true);
    }

    private void setTurnState(TurnState newState) {
        this.turnState = newState;
        this.ingameScreen.updateStatus();
    }

    void onRollTheDice(S_RollTheDice msg) throws AppProtocolException {
        this.playerTurn = NetUtil.rangeExclusive(msg.PlayerAtTurn, this.protocol.getMaxPlayers());
        this.setTurnState(TurnState.RollTheDice);
    }

    void onTurn(S_Turn msg) {
        this.dice = msg.Dice;
        MediaLib.SoundDice.play();
        this.setTurnState(TurnState.Turn);
    }

    void onChooseSafePos(S_ChooseSafePos msg) throws AppProtocolException {
        NetUtil.ensureValue(this.agents.length, msg.NewAgentPoints.length, "Num agents");
        MediaLib.SoundSafeOpened.play();
        int[] xOldPoints = new int[this.agents.length];
        int i = 0;
        while (i < this.agents.length) {
            Agent agent = this.agents[i];
            xOldPoints[i] = agent.getPoints();
            agent.setPoints(msg.NewAgentPoints[i]);
            ++i;
        }
        this.ingameScreen.addStatsSafe(this.safePos, xOldPoints, msg.NewAgentPoints);
        this.setTurnState(TurnState.ChooseSafePos);
    }

    void onSafePlaced(S_SafePlaced msg) {
        this.safePos = msg.NewSafePos;
        MediaLib.SoundSafePlaced.play();
        this.setTurnState(TurnState.SafePlaced);
    }

    void onStatus(S_Status msg) throws AppProtocolException {
        if (msg.State != TurnState.SubmitSecretPaper) {
            throw new AppProtocolException("Illegal status '" + (Object)((Object)msg.State) + "'");
        }
        this.setTurnState(msg.State);
    }

    public void onMoved(S_Moved moved) throws AppProtocolException {
        NetUtil.ensureValue(this.agents.length, moved.Moves.length, "Num agents");
        this.skipMovement();
        this.moves = new int[this.agents.length];
        int i = 0;
        while (i < this.agents.length) {
            S_Moved.Move move = moved.Moves[i];
            this.moves[i] = move.MovedBy;
            this.agents[i].move(move.MovedBy, move.Position);
            ++i;
        }
        this.ingameScreen.addStatsMoved(this.playerTurn, this.moves);
        this.setTurnState(TurnState.TurnWait);
    }

    void onTipAccepted(S_TipAccepted msg) throws AppProtocolException {
        int maxPlayers = this.getMaxPlayers();
        NetUtil.ensureValue(maxPlayers, msg.Players.length, "Num players");
        int i = 0;
        while (i < maxPlayers) {
            ((PlayerEntry)this.tryGetPlayer(i)).lockThinkAgent(msg.Players[i]);
            ++i;
        }
        this.tipAccepted = true;
        this.ingameScreen.updateStatus();
    }

    Agent getAgentNetwork(int nr) throws AppProtocolException {
        return NetUtil.ensureValue(this.agents, nr);
    }

    void onGameOver(S_GameOver msg) throws AppProtocolException {
        if (!this.GameInProgress.get() || this.gameOver) {
            return;
        }
        ArrayList anonymousAgents = new ArrayList();
        Collections.addAll(anonymousAgents, this.agents);
        for (S_GameOver.Player msgPlayer : msg.Players) {
            PlayerEntry player = (PlayerEntry)this.getPlayerNetwork(msgPlayer.PlayerId);
            Agent agent = this.getAgentNetwork(msgPlayer.OwnAgent);
            ArrayList<Pair<PlayerEntry, Agent>> guesses = new ArrayList<Pair<PlayerEntry, Agent>>();
            for (S_GameOver.PlayerGuess msgGuess : msgPlayer.ThinkAgents) {
                guesses.add(new Pair<PlayerEntry, Agent>((PlayerEntry)this.getPlayerNetwork(msgGuess.PlayerId), this.getAgentNetwork(msgGuess.AgentId)));
            }
            player.setScoringInfo(agent, guesses);
            anonymousAgents.remove(agent);
        }
        for (Agent anonymousAgent : anonymousAgents) {
            anonymousAgent.setRealPoints(0);
        }
        int i = 0;
        while (i < this.maxPlayers) {
            PlayerEntry player = (PlayerEntry)this.tryGetPlayer(i);
            if (player.isPlaying()) {
                Agent agent = player.getRealAgent();
                if (agent == null || this.useSecretPaper && player.getGuesses() == null) {
                    throw new AppProtocolException(String.valueOf(player.toString()) + " has no agent or guesses assigned - this will not do!");
                }
                int add = 0;
                if (this.useSecretPaper) {
                    for (Pair<PlayerEntry, Agent> guess : player.getGuesses()) {
                        if (((PlayerEntry)guess.V1).getRealAgent() != guess.V2) continue;
                        add += 5;
                        ((Agent)guess.V2).addDiscoverer(player.getName());
                        agent.addDiscovered(((PlayerEntry)guess.V1).getName());
                    }
                    for (Agent dummy : anonymousAgents) {
                        boolean assignedToPlayer = MiscLINQ.any(player.getGuesses(), x -> x.V2 == dummy);
                        if (assignedToPlayer) continue;
                        add += 5;
                        dummy.addDiscoverer(player.getName());
                        agent.addDiscovered("Anonymous" + dummy.Color.Nr);
                    }
                }
                agent.setRealPoints(add);
            }
            ++i;
        }
        if (this.useSecretPaper) {
            Agent[] agentArray = this.agents;
            int n = this.agents.length;
            int n2 = 0;
            while (n2 < n) {
                Agent a = agentArray[n2];
                a.checkApplyHiddenBonus();
                ++n2;
            }
        }
        this.turnState = TurnState.GameOver;
        this.gameOver = true;
        this.hostWantsRestart.set(false);
        ((UserInterface)this.ui).onGameOver();
    }

    public void addSystemMsg(MsgType type, String msg) {
        this.addChatMsg(type, null, msg);
    }

    public void addChatMsg(MsgType type, PlayerEntry sender, String msg) {
        while (this.chatMsgs.size() >= 50) {
            this.chatMsgs.remove(0);
        }
        this.chatMsgs.add(SecAgGameState.makeChatMsg(type, sender, msg));
        if (type == MsgType.CHAT) {
            MediaLib.SoundChat.play();
        }
        this.buildChat();
    }

    private void buildChat() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        int iC = this.chatMsgs.size();
        int i = 0;
        while (i < iC) {
            String chatMsg = this.chatMsgs.get(i);
            if (i != 0) {
                sb.append("<br>");
            }
            sb.append(chatMsg);
            ++i;
        }
        sb.append("</body></html>");
        String text = sb.toString();
        ((UserInterface)this.ui).setChat(text);
    }

    public static String makeChatMsg(MsgType xType, PlayerEntry pSender, String sMsg) {
        StringBuilder sb = new StringBuilder();
        if (pSender != null) {
            String senderName = pSender.getName();
            sb.append("<font color=\"#500000\"><b>");
            sb.append(HtmlEscape.sanitizeForLabel(senderName));
            sb.append("</b></font>: ");
        }
        if (xType.ChatColor != null) {
            sb.append("<font color=\"");
            sb.append(xType.ChatColor);
            sb.append("\">");
        }
        sb.append(HtmlEscape.sanitizeForLabel(sMsg));
        if (xType.ChatColor != null) {
            sb.append("</font>");
        }
        return sb.toString();
    }

    private void skipMovement() {
        Agent[] agentArray = this.agents;
        int n = this.agents.length;
        int n2 = 0;
        while (n2 < n) {
            Agent a = agentArray[n2];
            a.skipMovement();
            ++n2;
        }
    }

    @Override
    protected void onDisconnected(TextWithArguments reason) {
        super.onDisconnected(reason);
        this.skipMovement();
        if (this.extIPGetter != null) {
            this.extIPGetter.cancel();
            this.extIPGetter = null;
        }
    }

    @Override
    protected PlayerEntry createSlot() {
        return new PlayerEntry();
    }

    public PlayerEntry getMe() {
        return (PlayerEntry)((LocalPlayer)((GameClient)this.client).getPrimaryLocalPlayer()).getSlot();
    }

    public static enum MsgType {
        CHAT(null),
        INFO("#505000"),
        DEBUG("#000050"),
        CLIENT_INFO("#005000");

        public final String ChatColor;

        private MsgType(String chatColor) {
            this.ChatColor = chatColor;
        }
    }
}

