/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.game.client.ClientPlayerSlot;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.client.Agent;
import com.iosoft.secag.client.SecAgGameState;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.client.ui.UserInterface;
import java.util.List;

public class PlayerEntry
extends ClientPlayerSlot<SecAgGameState> {
    protected boolean stillInGamerOver;
    protected int isAgent;
    protected int isAgentLocked;
    protected Agent _realAgent;
    protected List<Pair<PlayerEntry, Agent>> _guesses;

    private void update() {
        if (((SecAgGameState)this._gs).isFullyConnected()) {
            ((UserInterface)((SecAgGameState)this._gs).getUI()).update();
        }
    }

    @Override
    public void onConnecting() {
        super.onConnecting();
        this.update();
    }

    @Override
    public void readFlags(int flags) {
        super.readFlags(flags);
        this.stillInGamerOver = Misc.getFlag(flags, 64);
        this.update();
    }

    @Override
    protected void setReady(boolean ready) {
        super.setReady(ready);
        this.update();
    }

    @Override
    protected void setAdmin(boolean admin) {
        boolean wasAdmin = this.isAdmin();
        super.setAdmin(admin);
        if (((SecAgGameState)this._gs).isFullyConnected() && this.isAdmin() && !wasAdmin && this.isPlaying()) {
            ((SecAgGameState)this._gs).addSystemMsg(SecAgGameState.MsgType.INFO, ((UserInterface)((SecAgGameState)this._gs).getUI()).getLocalizer().translate("_Chat_NewAdmin", this.getName()));
        }
        this.update();
    }

    @Override
    public void onConnected() {
        super.onConnected();
        if (((SecAgGameState)this._gs).isFullyConnected()) {
            String msg = ((UserInterface)((SecAgGameState)this._gs).getUI()).getLocalizer().translate("_Chat_PlayerJoined", this.getName());
            ((SecAgGameState)this._gs).addSystemMsg(SecAgGameState.MsgType.INFO, msg);
            if (((SecAgGameState)this._gs).GameInProgress.get()) {
                ((SecAgGameState)this._gs).ingameScreen.addStatsSlot(msg, true);
            }
            if (!this.isAI()) {
                MediaLib.SoundJoin.play();
            }
        }
        this.update();
    }

    @Override
    public void onRemoved(TextWithArguments reason) {
        boolean wasConnected = this.isPlaying();
        super.onRemoved(reason);
        if (reason != null) {
            String message = reason.translate(((SecretAgents)((SecAgGameState)this._gs).getGame()).getLocalizer());
            ((SecAgGameState)this._gs).addSystemMsg(SecAgGameState.MsgType.INFO, message);
            if (((SecAgGameState)this._gs).GameInProgress.get()) {
                ((SecAgGameState)this._gs).ingameScreen.addStatsSlot(message, false);
            }
            if (wasConnected && !this.isAI()) {
                MediaLib.SoundLeave.play();
            }
        }
        this.update();
    }

    @Override
    public void reset() {
        super.reset();
        this.stillInGamerOver = false;
        this.restart();
    }

    public void restart() {
        this.isAgentLocked = -1;
        this.isAgent = -1;
        this._realAgent = null;
        this._guesses = null;
    }

    public void lockThinkAgent(int agent) {
        this.isAgentLocked = agent;
    }

    public int getThinkIsAgent() {
        return this.isAgent;
    }

    public int getLockedThinkIsAgent() {
        return this.isAgentLocked;
    }

    public void setThinkIsAgent(int n) {
        this.isAgent = n;
    }

    @Override
    public void setPing(int ping) {
        super.setPing(ping);
        this.update();
    }

    public void setScoringInfo(Agent realAgent, List<Pair<PlayerEntry, Agent>> guesses) {
        this._realAgent = realAgent;
        this._guesses = guesses;
    }

    public Agent getRealAgent() {
        return this._realAgent;
    }

    public List<Pair<PlayerEntry, Agent>> getGuesses() {
        return this._guesses;
    }

    public boolean isStillInGameOver() {
        return this.stillInGamerOver;
    }

    public boolean isMe() {
        return ((SecAgGameState)this._gs).getMe() == this;
    }
}

