/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.client;

import com.iosoft.helpers.Misc;
import com.iosoft.secag.client.AgentColor;
import com.iosoft.secag.client.ui.MediaLib;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Agent {
    public static final int UNCOVER_BONUS = 5;
    public static final int HIDDEN_BONUS = 10;
    private int house;
    private int pos;
    private int points;
    private int remainingMoves;
    private int realPoints;
    private int rank;
    private int showPoints;
    private int pointTick;
    private int uncoverPoints;
    private double dPoints;
    private Point start;
    private Point end;
    private int tickMove;
    private final int nr;
    private final Point shift = new Point();
    private final List<String> discoverers = new ArrayList<String>();
    private final List<String> discovered = new ArrayList<String>();
    public final AgentColor Color;

    Agent(int nr, int color, int house, int pos, int points) {
        this.nr = nr;
        this.house = house;
        this.pos = pos;
        this.points = points;
        this.Color = new AgentColor(color);
    }

    public void addDiscoverer(String name) {
        this.discoverers.add(name);
    }

    public void addDiscovered(String name) {
        this.discovered.add(name);
    }

    public String[] getDiscoverers() {
        return this.discoverers.toArray(new String[this.discoverers.size()]);
    }

    public void move(int by, int toPos) {
        this.remainingMoves = by;
        this.start = MediaLib.mapCoords[this.house][this.pos + 1];
        this.house += by;
        this.house %= 12;
        this.pos = toPos;
        Point p = MediaLib.mapCoords[this.house][this.pos + 1];
        this.setShift(this.start.x - p.x, this.start.y - p.y);
        this.tickMove = 0;
    }

    public int getNr() {
        return this.nr;
    }

    public int getHouse() {
        return this.house;
    }

    public int getPos() {
        return this.pos;
    }

    public int getRealPoints() {
        return this.realPoints;
    }

    public int getUncoverPoints() {
        return this.uncoverPoints;
    }

    public void setRealPoints(int add) {
        this.uncoverPoints = add;
        this.realPoints = this.points + add;
    }

    public void checkApplyHiddenBonus() {
        if (this.discoverers.isEmpty()) {
            this.realPoints += 10;
        }
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean convergePoints() {
        boolean up;
        if (this.showPoints == this.points) {
            this.pointTick = 0;
            this.dPoints = this.showPoints;
            return false;
        }
        ++this.pointTick;
        boolean bl = up = this.points > this.showPoints;
        if (this.pointTick >= 10) {
            this.pointTick = 0;
            this.showPoints += up ? 1 : -1;
        }
        this.dPoints = (double)this.showPoints + (up ? 1.0 : -1.0) * ((double)this.pointTick / 10.0);
        return true;
    }

    public void skipMovement() {
        this.setShift(0, 0);
        this.remainingMoves = 0;
        this.tickMove = -1;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int newPoints) {
        this.points = newPoints;
    }

    public double getDPoints() {
        return this.dPoints;
    }

    public int getShowPoints() {
        return this.showPoints;
    }

    public void setShift(int x, int y) {
        this.shift.x = x;
        this.shift.y = y;
    }

    public Point getShift() {
        return this.shift;
    }

    public boolean tick() {
        if (this.remainingMoves == 0) {
            return false;
        }
        if (this.end == null) {
            int h = Misc.modNegToPos(this.house - this.remainingMoves + 1, 12);
            this.end = MediaLib.mapCoords[h][this.remainingMoves == 1 ? this.pos + 1 : 0];
            this.tickMove = 0;
        }
        ++this.tickMove;
        if (this.tickMove == 14) {
            MediaLib.SoundMove.play();
        }
        Point finPos = MediaLib.mapCoords[this.house][1 + this.pos];
        if (this.tickMove < 10) {
            this.setShift(this.start.x - finPos.x, this.start.y - finPos.y);
        } else if (this.tickMove < 50) {
            double factor = Misc.smoothstep((double)(this.tickMove - 10) / 40.0);
            int x = (int)Math.round((double)(this.end.x - this.start.x) * factor);
            int y = (int)Math.round((double)(this.end.y - this.start.y) * factor);
            this.setShift(this.start.x - finPos.x + x, this.start.y - finPos.y + y);
        } else {
            this.setShift(this.end.x - finPos.x, this.end.y - finPos.y);
        }
        if (this.tickMove == 60) {
            this.start = this.end;
            this.end = null;
            --this.remainingMoves;
            if (this.remainingMoves == 0) {
                this.setShift(0, 0);
            }
        }
        return true;
    }
}

