/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag;

import com.iosoft.helpers.Misc;
import com.iosoft.ioengine.game.NetGameSettings;
import com.iosoft.iogame.saveload.IKVRW;
import com.iosoft.secag.client.ui.screens.LobbyScreen;

public class Settings
extends NetGameSettings {
    private int limit = LobbyScreen.LIMITS[2];
    private boolean useSecretPaper = true;
    private float secretPaperQuota = 0.7f;

    @Override
    protected void rw(IKVRW rw) {
        super.rw(rw);
        this.limit = Misc.clamp(rw.rwInt("limit", this.limit), 1, 65535);
        this.useSecretPaper = rw.rwBool("useSecretPaper", this.useSecretPaper);
        this.secretPaperQuota = rw.rwFloat("secretPaperQuota", this.secretPaperQuota);
    }

    public int getLimit() {
        return this.limit;
    }

    public float getSecretPaperQuota() {
        return this.secretPaperQuota;
    }

    public boolean getUseSecretPaper() {
        return this.useSecretPaper;
    }

    public void setLimit(int value) {
        if (this.limit != value) {
            this.limit = value;
            this.save();
        }
    }

    public void setSecretPaperQuota(float value) {
        if (this.secretPaperQuota != value) {
            this.secretPaperQuota = value;
            this.save();
        }
    }

    public void setUseSecretPaper(boolean value) {
        if (this.useSecretPaper != value) {
            this.useSecretPaper = value;
            this.save();
        }
    }
}

