/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag;

import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.EDTDispatcher;
import com.iosoft.helpers.datasource.Resource;
import com.iosoft.helpers.localizer.LocalizationParser;
import com.iosoft.ioengine.game.NetworkGameNoshared;
import com.iosoft.iogame.Game;
import com.iosoft.secag.Protocol;
import com.iosoft.secag.SecAgHeadlessMode;
import com.iosoft.secag.Settings;
import com.iosoft.secag.client.GameClient;
import com.iosoft.secag.client.ui.MediaLib;
import com.iosoft.secag.server.GameServer;
import com.iosoft.secag.server.SecAgData;

public class SecretAgents
extends NetworkGameNoshared<GameClient, GameServer, Protocol, Settings> {
    private static final String VERSION = "1.6.0";
    public static final String BaseUrl = "https://para-welt.com/main/ayce/secag/";
    static final String URL_MASTERSERVER = "https://para-welt.com/main/ayce/secag/browser.php";
    static final String OFFICIAL_UPDATE_SITE = "https://para-welt.com/main/ayce/secag/update.txt";

    public static void main(String[] args) {
        new SecretAgents().start(args);
    }

    @Override
    protected Dispatcher createUIDispatcher() {
        return EDTDispatcher.initialize();
    }

    @Override
    protected boolean hasNonHeadlessDedicated() {
        return true;
    }

    @Override
    protected void addLocalizationPaths(LocalizationParser parser) {
        super.addLocalizationPaths(parser);
        parser.addTextsPropDB(new Resource("/res/text/"));
    }

    @Override
    protected Settings createSettings() {
        return new Settings();
    }

    @Override
    protected void initializeServer() {
        super.initializeServer();
        SecAgData data = (SecAgData)((GameServer)this._server).getData();
        data.setLimit(((Settings)this.Settings).getLimit(), ((Settings)this.Settings).getSecretPaperQuota());
        data.setUseSecretPaper(((Settings)this.Settings).getUseSecretPaper());
    }

    @Override
    protected GameClient createClient() {
        return new GameClient(this);
    }

    @Override
    protected GameServer createServer() {
        return new GameServer(this);
    }

    @Override
    public String getGameName() {
        return "SecAg";
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    protected Protocol createProtocol(String gameName) {
        return new Protocol(gameName);
    }

    protected SecAgHeadlessMode createHeadlessMode() {
        return new SecAgHeadlessMode();
    }

    @Override
    protected Game.UpdateCheckerInfo getUpdateCheckerInfo() {
        return new Game.UpdateCheckerInfo(OFFICIAL_UPDATE_SITE, "secagupdate");
    }

    @Override
    protected VTask loadImportantAssetsAsync() {
        VTask task = super.loadImportantAssetsAsync();
        if (this.skipLoadMedia()) {
            return task;
        }
        return task.awaitAndContinueVTask(() -> Async.runAsyncEnforced(MediaLib::loadImportant));
    }

    @Override
    protected VTask loadAssetsAsync() {
        VTask task = super.loadAssetsAsync();
        if (this.skipLoadMedia()) {
            return task;
        }
        return task.awaitAndContinueVTask(() -> {
            boolean devmode = this.isDevmode();
            boolean dedicated = this.isDedicated();
            return Async.runAsyncEnforced(() -> MediaLib.load(devmode, dedicated));
        });
    }
}

