/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.propdb.saveload;

import com.iosoft.helpers.Misc;
import com.iosoft.iogame.saveload.IKVArray;
import com.iosoft.iogame.saveload.IKVNode;
import com.iosoft.iogame.saveload.IKVRead;
import com.iosoft.iogame.saveload.IKVReadItem;
import com.iosoft.iogame.saveload.IKVWriteItem;
import com.iosoft.iogame.saveload.KVReadItemCollection;
import com.iosoft.propdb.PropDB;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PropDBKVNode
implements IKVNode {
    protected final PropDB.Node _node;

    public PropDBKVNode(PropDB.Node node) {
        this._node = node;
    }

    @Override
    public PropDBKVNode getSub(String key) {
        return new PropDBKVNode(this.sub(key));
    }

    @Override
    public IKVRead tryGetReadSub(String key) {
        PropDB.Node node = this._node.tryGetChild(key);
        return node == null ? null : new PropDBKVNode(this.sub(key));
    }

    public PropDB.Node sub(String key) {
        return this._node.add(key);
    }

    @Override
    public Collection<IKVReadItem> tryGetArray(String key) {
        final PropDB.Node node = this._node.tryGetChild(key);
        if (node == null) {
            return null;
        }
        return new KVReadItemCollection(){

            @Override
            public int size() {
                return node.size();
            }

            @Override
            public Iterator<IKVReadItem> iterator() {
                return node.stream().map(x -> new PropDBKVNode((PropDB.Node)x)).iterator();
            }
        };
    }

    @Override
    public IKVArray setArray(String key) {
        final PropDB.Node node = this.sub(key);
        node.clear();
        return new IKVArray(){

            @Override
            public void dispose() {
            }

            @Override
            public IKVWriteItem add() {
                return new PropDBKVNode(node.addSameName("" + node.size()));
            }
        };
    }

    @Override
    public String tryGetString(String key) {
        PropDB.Node node = this._node.tryGetChild(key);
        return node == null ? null : node.getAsString();
    }

    @Override
    public int getInt(String key, int def) {
        PropDB.Node node = this._node.tryGetChild(key);
        return node == null ? def : node.getAsInt(def);
    }

    @Override
    public long getLong(String key, long def) {
        PropDB.Node node = this._node.tryGetChild(key);
        return node == null ? def : node.getAsLong(def);
    }

    @Override
    public boolean getBool(String key, boolean def) {
        PropDB.Node node = this._node.tryGetChild(key);
        return node == null ? def : node.getAsBoolean(def);
    }

    @Override
    public float getFloat(String key, float def) {
        PropDB.Node node = this._node.tryGetChild(key);
        return node == null ? def : node.getAsFloat(def);
    }

    @Override
    public double getDouble(String key, double def) {
        PropDB.Node node = this._node.tryGetChild(key);
        return node == null ? def : node.getAsDouble(def);
    }

    @Override
    public void setString(String key, String value) {
        this._node.set(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this._node.set(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this._node.set(key, value);
    }

    @Override
    public void setBool(String key, boolean value) {
        this._node.set(key, value);
    }

    @Override
    public void setFloat(String key, float value) {
        this._node.set(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this._node.set(key, value);
    }

    @Override
    public boolean getBool(boolean defVal) {
        return this._node.getAsBoolean();
    }

    @Override
    public String getString(String defVal) {
        return this._node.getAsString();
    }

    @Override
    public double getDouble(double defVal) {
        return this._node.getAsDouble();
    }

    @Override
    public int getInt(int defVal) {
        return this._node.getAsInt(defVal);
    }

    @Override
    public void setBool(boolean value) {
        this._node.setValue(value);
    }

    @Override
    public void setString(String value) {
        this._node.setValue(value);
    }

    @Override
    public void setDouble(double value) {
        this._node.setValue(value);
    }

    @Override
    public void setInt(int value) {
        this._node.setValue(value);
    }

    @Override
    public int[] getIntArray(String key) {
        String value = this.getString(key, null);
        if (value == null) {
            return Misc.EMPTYINTS;
        }
        return Stream.of(Misc.splitNoempty(value, ",")).mapToInt(Misc::getAsInt).toArray();
    }

    @Override
    public void setIntArray(String key, int[] array) {
        this.setString(key, IntStream.of(array).mapToObj(Integer::toString).collect(Collectors.joining(",")));
    }
}

