/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.propdb;

import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.localizer.source.AbstractLocalizationFile;
import com.iosoft.propdb.PropDB;
import java.io.IOException;
import java.util.Map;

public class PropDBLocalizationFile
extends AbstractLocalizationFile {
    public PropDBLocalizationFile(IDataSource source) {
        super(source);
    }

    @Override
    protected void loadFile(IDataSource source, Map<String, String> mapping) throws IOException {
        this.load(PropDB.loadSource(source), mapping);
    }

    @Override
    protected Task<IOException> loadFileAsync(IDataSource source, Map<String, String> mapping) {
        return PropDB.loadSourceAsync(source).awaitAndTranslate(x -> {
            if (x.Exception != null) {
                return (IOException)x.Exception;
            }
            this.load((PropDB)x.Value, mapping);
            return null;
        });
    }

    private void load(PropDB propDB, Map<String, String> mapping) {
        PropDB.Node node = propDB.getRoot();
        this.loadSubNodes(node.getAsString(), node, mapping);
    }

    private void load(String prefix, PropDB.Node node, Map<String, String> mapping) {
        String name = node.getName();
        if (!name.startsWith("\u00a7")) {
            prefix = String.valueOf(prefix) + name;
            String value = node.getAsString();
            if (!value.isEmpty() || !node.iterator().hasNext()) {
                mapping.put(prefix, value);
            }
        }
        this.loadSubNodes(prefix, node, mapping);
    }

    private void loadSubNodes(String prefix, PropDB.Node node, Map<String, String> mapping) {
        for (PropDB.Node subNode : node) {
            this.load(prefix, subNode, mapping);
        }
    }
}

