/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.json;

import com.iosoft.helpers.FormatException;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.Parser;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.iter.SkippingIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public final class JSON
extends Parser {
    public static final Class<Node> ClassNode = Node.class;
    private static final Field WrapValueField;
    public boolean AllowComments = true;
    private boolean lastBool;
    private String lastString;
    private final ParserOptions _options;

    static {
        try {
            WrapValueField = Mutable.class.getField("Value");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new WrapException(e);
        }
    }

    private JSON(String input, ParserOptions options) throws FormatException {
        super(input);
        this._options = Misc.notNull(options);
    }

    public static <T> T deserialize(String jsonString, Class<T> clazz) throws FormatException {
        return JSON.deserialize(jsonString, clazz, ParserOptions.Default);
    }

    public static Node deserialize(String jsonString) throws FormatException {
        return JSON.deserialize(jsonString, ParserOptions.Default);
    }

    public static <T> T deserialize(String jsonString, Class<T> clazz, ParserOptions options) throws FormatException {
        return new JSON(jsonString, options).deserialize(clazz);
    }

    public static Node deserialize(String jsonString, ParserOptions options) throws FormatException {
        return new JSON(jsonString, options).deserialize(ClassNode);
    }

    private <T> T deserialize(Class<T> type) throws FormatException {
        try {
            T result = this.reqObjectWrapped(type);
            this.reqEnd();
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("Data error", e);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FormatException("Model error", e);
        }
    }

    private <T> T reqObjectWrapped(Class<T> type) throws FormatException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (type.isAnnotationPresent(Wrap.class)) {
            T wrap = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                Field field = type.getField("JSON");
                if (Misc.isStatic(field)) {
                    throw new FormatException("JSON cannot be static");
                }
                this.reqObject(field.getType(), field, wrap);
                return wrap;
            }
            catch (NoSuchFieldException e) {
                throw new FormatException("Invalid model, JSON field not found", e);
            }
        }
        Mutable wrap = new Mutable();
        this.reqObject(type, WrapValueField, wrap);
        return wrap.Value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, V> void reqObject(Class<T> type, Field field, Object parent) throws FormatException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (type == ClassNode) {
            Node node = new Node();
            this.reqNode(node);
            field.set(parent, node);
            return;
        }
        if (this.tryNull()) {
            if (!type.isPrimitive()) {
                field.set(parent, null);
                return;
            }
            if (this._options.IgnoreInvalidValues) return;
            throw new FormatException("Primitives cannot have null values ('" + field.getName() + "')");
        }
        if (type == Boolean.TYPE) {
            if (this.tryBool()) {
                field.setBoolean(parent, this.lastBool);
                return;
            }
            if (this._options.IgnoreInvalidValues) return;
            throw new FormatException("Not a boolean value given for '" + field.getName() + "'");
        }
        if (type == String.class) {
            if (this.tryString()) {
                field.set(parent, this.lastString);
                this.lastString = null;
                return;
            }
            if (this._options.IgnoreInvalidValues) return;
            throw new FormatException("Not a string value given for '" + field.getName() + "'");
        }
        if (type == Map.class) {
            this.reqToken('{');
            MapType mapTypeAnnotation = field.getAnnotation(MapType.class);
            if (mapTypeAnnotation == null) {
                throw new FormatException("A @MapType is missing for a Map<String, ?>");
            }
            Class<?> mapType = mapTypeAnnotation.value();
            HashMap map = new HashMap();
            while (!this.askToken('}')) {
                String fieldName = this.reqString();
                this.reqToken(':');
                if (!this._options.IgnoreInvalidValues && map.containsKey(fieldName)) {
                    throw new FormatException("'" + fieldName + "' is present twice");
                }
                map.putIfAbsent(fieldName, this.reqObjectWrapped(mapType));
                if (this.tryToken(',')) continue;
            }
            this.reqToken('}');
            field.set(parent, map);
            return;
        }
        if (type.isArray()) {
            this.reqToken('[');
            if (type == int[].class) {
                LinkedList<Integer> list = new LinkedList<Integer>();
                while (!this.askToken(']')) {
                    String str = this.reqNumberString();
                    Integer result = Misc.tryGetAsInt(str);
                    if (result != null) {
                        list.add(result);
                    } else if (!this._options.IgnoreInvalidValues) {
                        throw new FormatException("'" + str + "' is an invalid value for array '" + field.getName() + "'");
                    }
                    if (this.tryToken(',')) continue;
                }
                field.set(parent, Misc.toIntArray(list));
            } else {
                Class<?> elementType = type.getComponentType();
                this.reqObjectArray(elementType, field, parent);
            }
            this.reqToken(']');
            return;
        }
        if (type.isEnum()) {
            if (this.tryString()) {
                try {
                    Field enumConstant = type.getField(this.lastString);
                    if (enumConstant.isEnumConstant()) {
                        field.set(parent, enumConstant.get(null));
                        return;
                    }
                    if (this._options.IgnoreInvalidValues) return;
                    throw new FormatException("'" + this.lastString + "' is not an enum constant");
                }
                catch (NoSuchFieldException | SecurityException e) {
                    if (this._options.IgnoreInvalidValues) return;
                    throw new FormatException("'" + this.lastString + "' is not an enum constant");
                }
            }
            String str = this.reqNumberString();
            Integer result = Misc.tryGetAsInt(str);
            if (result != null) {
                int index = result;
                T[] values = type.getEnumConstants();
                if (index >= 0 && index < values.length) {
                    field.set(parent, values[index]);
                    return;
                }
                if (this._options.IgnoreInvalidValues) return;
                throw new FormatException("'" + index + "' is an invalid index for enum '" + type.getName() + "' (num " + values.length + " values)");
            }
            if (this._options.IgnoreInvalidValues) return;
            throw new FormatException("'" + str + "' is an invalid value for enum '" + type.getName() + "'");
        }
        if (!type.isPrimitive() && !Number.class.isAssignableFrom(type)) {
            this.reqToken('{');
            T complex = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            field.set(parent, complex);
            Map<String, Field> fields = MiscLINQ.toMap(Arrays.stream(type.getFields()).filter(x -> {
                int m = x.getModifiers();
                return !Modifier.isStatic(m) && !Modifier.isFinal(m);
            }), Field::getName);
            while (!this.askToken('}')) {
                String fieldName = this.reqString();
                this.reqToken(':');
                Field memberField = fields.get(fieldName);
                if (memberField != null) {
                    this.reqObject(memberField.getType(), memberField, complex);
                } else {
                    if (!this._options.IgnoreUnknownFields) {
                        throw new FormatException("Unknown field '" + fieldName + "' in " + type.getName());
                    }
                    this.reqNode(null);
                }
                if (this.tryToken(',')) continue;
            }
            this.reqToken('}');
            return;
        }
        String numberString = this.reqNumberString();
        try {
            if (type == Integer.TYPE || type == Integer.class) {
                Integer value = Integer.parseInt(numberString);
                if (type == Integer.TYPE) {
                    field.setInt(parent, value);
                    return;
                } else {
                    field.set(parent, value);
                }
                return;
            } else if (type == Long.TYPE || type == Long.class) {
                Long value = Long.parseLong(numberString);
                if (type == Integer.TYPE) {
                    field.setLong(parent, value);
                    return;
                } else {
                    field.set(parent, value);
                }
                return;
            } else if (type == Float.TYPE || type == Float.class) {
                float value = Float.parseFloat(numberString);
                if (type == Float.TYPE) {
                    field.setFloat(parent, value);
                    return;
                } else {
                    field.set(parent, Float.valueOf(value));
                }
                return;
            } else {
                if (type != Double.TYPE && type != Double.class) throw new FormatException("Cannot parse that yet ('" + field.getName() + "')");
                double value = Double.parseDouble(numberString);
                if (type == Double.TYPE) {
                    field.setDouble(parent, value);
                    return;
                } else {
                    field.set(parent, value);
                }
            }
            return;
        }
        catch (NumberFormatException e) {
            if (this._options.IgnoreInvalidValues) return;
            throw new FormatException("'" + numberString + "' is an invalid value for '" + field.getName() + "'", e);
        }
    }

    private boolean tryNull() throws FormatException {
        return this.tryTokens("null");
    }

    private boolean tryBool() throws FormatException {
        if (this.tryTokens("true")) {
            this.lastBool = true;
            return true;
        }
        if (this.tryTokens("false")) {
            this.lastBool = false;
            return true;
        }
        return false;
    }

    private void reqNode(Node node) throws FormatException {
        if (this.tryNull()) {
            if (node != null) {
                node.setNull();
            }
        } else if (this.tryBool()) {
            if (node != null) {
                node.set(this.lastBool);
            }
        } else if (this.tryString()) {
            if (node != null) {
                node.set(this.lastString);
            }
            this.lastString = null;
        } else if (this.tryToken('[')) {
            if (node != null) {
                node.setArray();
            }
            while (!this.askToken(']')) {
                Node sub;
                if (node == null) {
                    sub = null;
                } else {
                    sub = new Node();
                    node.addElement(sub);
                }
                this.reqNode(sub);
                if (this.tryToken(',')) continue;
            }
            this.reqToken(']');
        } else if (this.tryToken('{')) {
            if (node != null) {
                node.setObject();
            }
            while (!this.askToken('}')) {
                Node sub;
                String name = this.reqString();
                this.reqToken(':');
                if (node == null) {
                    sub = null;
                } else {
                    sub = new Node();
                    node.addField(name, sub);
                }
                this.reqNode(sub);
                if (this.tryToken(',')) continue;
            }
            this.reqToken('}');
        } else {
            String numberString = this.reqNumberString();
            if (node != null) {
                try {
                    long value = Long.parseLong(numberString);
                    node.set(value);
                }
                catch (NumberFormatException e) {
                    try {
                        double value = Double.parseDouble(numberString);
                        node.set(value);
                    }
                    catch (NumberFormatException e2) {
                        throw new FormatException("Could not parse '" + numberString + "'", e2);
                    }
                }
            }
        }
    }

    private boolean tryString() throws FormatException {
        if (this.askToken('\"')) {
            this.lastString = this.reqString();
            return true;
        }
        return false;
    }

    private String reqNumberString() throws FormatException {
        this.skipWhitespace();
        return this.reqString_number().trim();
    }

    private String reqString() throws FormatException {
        this.reqToken('\"');
        String value = this.readString();
        this.reqNextChar('\"');
        return value;
    }

    private String reqString_number() throws FormatException {
        int lastIndex;
        String numberString;
        int nearestIndex;
        int idxComma = this.input.indexOf(44, this.pos);
        int idxArrayBracket = this.input.indexOf(93, this.pos);
        int idxObjBracket = this.input.indexOf(125, this.pos);
        if (idxComma == -1) {
            idxComma = Integer.MAX_VALUE;
        }
        if (idxArrayBracket == -1) {
            idxArrayBracket = Integer.MAX_VALUE;
        }
        if (idxObjBracket == -1) {
            idxObjBracket = Integer.MAX_VALUE;
        }
        if ((nearestIndex = Math.min(idxComma, Math.min(idxArrayBracket, idxObjBracket))) == Integer.MAX_VALUE) {
            numberString = this.input.substring(this.pos);
            lastIndex = this.input.length() - 1;
        } else {
            numberString = this.input.substring(this.pos, nearestIndex);
            lastIndex = nearestIndex - 1;
        }
        this.pos = lastIndex;
        this.nextChar();
        return numberString;
    }

    private String readString() throws FormatException {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        while (true) {
            char c = this.lookaheadChar;
            switch (c) {
                case '\\': {
                    if (escaped) {
                        sb.append('\\');
                        escaped = false;
                        break;
                    }
                    escaped = true;
                    break;
                }
                default: {
                    switch (c) {
                        case '\"': {
                            if (!escaped) {
                                return sb.toString();
                            }
                            sb.append(c);
                            break;
                        }
                        case 'n': {
                            if (escaped) {
                                sb.append('\n');
                                break;
                            }
                            sb.append(c);
                            break;
                        }
                        case 'r': {
                            if (escaped) {
                                sb.append('\r');
                                break;
                            }
                            sb.append(c);
                            break;
                        }
                        case 't': {
                            if (escaped) {
                                sb.append('\t');
                                break;
                            }
                            sb.append(c);
                            break;
                        }
                        default: {
                            if (escaped) {
                                throw new FormatException("Unknown escape sequence '\\" + c + "'");
                            }
                            sb.append(c);
                        }
                    }
                    escaped = false;
                }
            }
            this.nextChar();
        }
    }

    @Override
    protected boolean skipWhitespace() throws FormatException {
        block6: {
            if (this.endReached) {
                return false;
            }
            boolean isComment = false;
            do {
                boolean skip;
                boolean bl = skip = isComment || Character.isWhitespace(this.lookaheadChar);
                if (isComment) {
                    if (this.lookaheadChar == '\n') {
                        isComment = false;
                    }
                } else if (this.AllowComments && this.lookaheadChar == '/' && this.input.startsWith("//", this.pos)) {
                    isComment = true;
                    skip = true;
                }
                if (!skip) break block6;
            } while (this.nextChar());
            return false;
        }
        return true;
    }

    private <T> void reqObjectArray(Class<T> type, Field field, Object parent) throws FormatException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        LinkedList<T> list = new LinkedList<T>();
        while (!this.askToken(']')) {
            list.add(this.reqObjectWrapped(type));
            if (this.tryToken(',')) continue;
        }
        Object[] resultArray = (Object[])Array.newInstance(type, list.size());
        field.set(parent, list.toArray(resultArray));
    }

    public static String serialize(Object obj, boolean pretty) {
        return JSON.serialize(obj, pretty ? SerializerOptions.DefaultPretty : SerializerOptions.Default);
    }

    public static String serialize(Object obj, SerializerOptions options) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StringWriter writer = new StringWriter();){
                JSON.serialize(obj, options, writer);
                writer.flush();
                return writer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    public static void serialize(Object obj, SerializerOptions options, OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            JSON.serialize(obj, options, writer);
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void serialize(Object obj, SerializerOptions options, Writer writer) throws IOException {
        new JSONSerializer(obj, options, writer);
    }

    private static final class JSONSerializer {
        private final Writer _writer;
        private final SerializerOptions _options;
        private String _left = "";

        private JSONSerializer(Object root, SerializerOptions options, Writer writer) throws IOException {
            this._options = options;
            this._writer = writer;
            try {
                try {
                    this.serialize(root);
                    if (this._options.Pretty && this._options.Pretty_TrailingLineBreak) {
                        writer.append('\n');
                    }
                }
                catch (WrapException e) {
                    e.tryUnwrap(IllegalArgumentException.class);
                    throw e.unwrap(IllegalAccessException.class);
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot serialize", e);
            }
        }

        private boolean serialize(final Object obj) throws IOException, IllegalAccessException {
            if (obj == null) {
                this._writer.append("null");
                return false;
            }
            Class<?> type = obj.getClass();
            if (type == ClassNode) {
                Node node = (Node)obj;
                switch (node.getType()) {
                    case UNKNOWN: {
                        return this.serialize(null);
                    }
                    case ARRAY: {
                        return this.serializeArray(type, node.elements.iterator());
                    }
                    case OBJECT: {
                        return this.serializeMap(node.fields);
                    }
                }
                return this.serialize(node.getValue());
            }
            if (Number.class.isAssignableFrom(type) || type == Boolean.TYPE || type == Boolean.class) {
                this._writer.append(obj.toString());
            } else {
                if (type.isArray()) {
                    return this.serializeArray(type, (Iterator<? extends Object>)new SkippingIterator<Object>(){
                        final int _length;
                        int _i;
                        {
                            this._length = Array.getLength(object);
                        }

                        @Override
                        protected Object findNextElement() {
                            if (this._i >= this._length) {
                                this.onEndReached();
                                return null;
                            }
                            return Array.get(obj, this._i++);
                        }
                    });
                }
                if (type == String.class) {
                    this.serializeString((String)obj);
                } else if (type.isEnum()) {
                    Enum e = (Enum)obj;
                    if (this._options.EnumsAsNumbers) {
                        this._writer.append(Integer.toString(e.ordinal()));
                    } else {
                        this.serializeString(e.name());
                    }
                } else {
                    if (obj instanceof Map) {
                        return this.serializeMap((Map)obj);
                    }
                    return this.serializeObj(type, obj);
                }
            }
            return false;
        }

        private void serializeString(String string) throws IOException {
            this._writer.append('\"');
            this._writer.append(JSONSerializer.sanitizeString(string));
            this._writer.append('\"');
        }

        private static String sanitizeString(String input) {
            return input.replace("\\", "\\\\").replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n").replace("\"", "\\\"");
        }

        private boolean serializeArray(Class<?> type, Iterator<? extends Object> iter) throws IOException, IllegalAccessException {
            String oldLeft = this.indent();
            this._writer.append('[');
            boolean wasKeyValueType = false;
            boolean first = true;
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else if (this._options.Pretty) {
                    this._writer.append(", ");
                } else {
                    this._writer.append(',');
                }
                wasKeyValueType = this.serialize(iter.next());
            }
            this._left = oldLeft;
            if (this._options.Pretty && wasKeyValueType) {
                this._writer.append('\n');
                this._writer.append(this._left);
            }
            this._writer.append(']');
            return first;
        }

        private boolean serializeMap(Map<?, ?> map) throws IOException, IllegalAccessException {
            return this.serializeKeyValues(map.entrySet().stream().map(x -> {
                Object key = x.getKey();
                if (!(key instanceof String)) {
                    throw new WrapException(new IllegalArgumentException("Can only serialize maps with string keys"));
                }
                return new Pair((String)key, x.getValue());
            }));
        }

        private boolean serializeObj(Class<?> type, Object obj) throws IOException, IllegalAccessException {
            Stream<Pair<String, Object>> stream = Stream.of(type.getFields()).filter(x -> !Misc.isStatic(x)).map(x -> {
                Object value;
                block3: {
                    try {
                        value = x.get(obj);
                        if (this._options.SerializeNullFields || value != null) break block3;
                        return null;
                    }
                    catch (IllegalAccessException e) {
                        throw new WrapException(e);
                    }
                }
                return new Pair<String, Object>(x.getName(), value);
            });
            if (!this._options.SerializeNullFields) {
                stream = stream.filter(x -> x != null);
            }
            return this.serializeKeyValues(stream);
        }

        private String indent() {
            String oldLeft = this._left;
            if (this._options.Pretty) {
                this._left = String.valueOf(this._left) + "    ";
            }
            return oldLeft;
        }

        private boolean serializeKeyValues(Stream<Pair<String, Object>> keyValues) throws IOException, IllegalAccessException {
            this._writer.append('{');
            String oldLeft = this.indent();
            boolean first = true;
            for (Pair<String, Object> keyValue : MiscLINQ.iter(keyValues)) {
                if (first) {
                    first = false;
                } else {
                    this._writer.append(',');
                }
                if (this._options.Pretty) {
                    this._writer.append('\n');
                    this._writer.append(this._left);
                }
                this.serializeString((String)keyValue.V1);
                if (this._options.Pretty) {
                    this._writer.append(": ");
                } else {
                    this._writer.append(':');
                }
                this.serialize(keyValue.V2);
            }
            this._left = oldLeft;
            if (!first && this._options.Pretty) {
                this._writer.append('\n');
                this._writer.append(this._left);
            }
            this._writer.append('}');
            return !first;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface MapType {
        public Class<?> value();
    }

    public static class Node {
        private NodeType type = NodeType.UNKNOWN;
        private Object value;
        private List<Node> elements;
        private Map<String, Node> fields;

        public void setNull() {
            this.type = NodeType.UNKNOWN;
            this.value = null;
        }

        public void set(boolean boolVal) {
            this.type = NodeType.BOOL;
            this.value = boolVal ? Boolean.TRUE : Boolean.FALSE;
        }

        public void set(String stringVal) {
            this.type = NodeType.STRING;
            this.value = stringVal;
        }

        public void set(long longVal) {
            this.type = NodeType.NUMBER_LONG;
            this.value = longVal;
        }

        public void set(double doubleVal) {
            this.type = NodeType.NUMBER_DOUBLE;
            this.value = doubleVal;
        }

        public void setArray() {
            this.type = NodeType.ARRAY;
            this.elements = new LinkedList<Node>();
            this.value = null;
        }

        public void setObject() {
            this.type = NodeType.OBJECT;
            this.fields = new HashMap<String, Node>();
            this.value = null;
        }

        public void addElement(Node node) {
            if (this.type != NodeType.ARRAY) {
                throw new IllegalStateException("Can only add elements to arrays");
            }
            this.elements.add(node);
        }

        public void addField(String name, Node node) {
            if (this.type != NodeType.OBJECT) {
                throw new IllegalStateException("Can only add fields to objects");
            }
            if (this.fields.putIfAbsent(name, node) != null) {
                throw new IllegalArgumentException("Node '" + name + "' already exists");
            }
        }

        public Node tryGetField(String name) {
            return this.type == NodeType.OBJECT ? this.fields.get(name) : null;
        }

        public Node getOrAddField(String name) {
            Node field = this.tryGetField(name);
            if (field != null) {
                return field;
            }
            field = new Node();
            field.setNull();
            if (this.getType() != NodeType.OBJECT) {
                this.setObject();
            }
            this.addField(name, field);
            return field;
        }

        public NodeType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public Iterator<Node> iterArray() {
            if (this.type != NodeType.ARRAY) {
                throw new IllegalStateException("Node is not an array");
            }
            return this.elements.iterator();
        }

        public Stream<Node> streamArray() {
            return this.elements.stream();
        }

        public Set<Map.Entry<String, Node>> getFields() {
            if (this.type != NodeType.OBJECT) {
                throw new IllegalStateException("Node is not an object");
            }
            return this.fields.entrySet();
        }

        public int size() {
            if (this.type == NodeType.OBJECT) {
                return this.fields.size();
            }
            if (this.type == NodeType.ARRAY) {
                return this.elements.size();
            }
            throw new IllegalStateException("Can only get size of an object or array");
        }

        public long getAsLong(long defVal) {
            switch (this.type) {
                case NUMBER_LONG: {
                    return (Long)this.value;
                }
                case NUMBER_DOUBLE: {
                    return ((Double)this.value).longValue();
                }
            }
            return defVal;
        }

        public double getAsDouble(double defVal) {
            switch (this.type) {
                case NUMBER_LONG: {
                    return ((Long)this.value).longValue();
                }
                case NUMBER_DOUBLE: {
                    return (Double)this.value;
                }
            }
            return defVal;
        }

        public String getAsString(String defVal) {
            switch (this.type) {
                case STRING: {
                    return (String)this.value;
                }
                case NUMBER_DOUBLE: {
                    return ((Double)this.value).toString();
                }
                case NUMBER_LONG: {
                    return ((Long)this.value).toString();
                }
                case BOOL: {
                    return ((Boolean)this.value).toString();
                }
            }
            return defVal;
        }

        public boolean getAsBool(boolean defVal) {
            switch (this.type) {
                case BOOL: {
                    return (Boolean)this.value;
                }
                case NUMBER_LONG: {
                    return (Long)this.value != 0L;
                }
                case NUMBER_DOUBLE: {
                    return (Double)this.value != 0.0;
                }
            }
            return defVal;
        }
    }

    public static enum NodeType {
        UNKNOWN,
        ARRAY,
        OBJECT,
        BOOL,
        STRING,
        NUMBER_LONG,
        NUMBER_DOUBLE;

    }

    public static class ParserOptions {
        public static final ParserOptions Default = new ParserOptions();
        public static final ParserOptions Strict = new ParserOptions();
        public static final ParserOptions Lax = new ParserOptions();
        public boolean IgnoreUnknownFields = true;
        public boolean IgnoreInvalidValues = false;

        static {
            ParserOptions.Lax.IgnoreInvalidValues = true;
            ParserOptions.Strict.IgnoreUnknownFields = false;
        }
    }

    public static class SerializerOptions {
        public static final SerializerOptions Default = new SerializerOptions();
        public static final SerializerOptions DefaultMinimal = new SerializerOptions();
        public static final SerializerOptions DefaultPretty = new SerializerOptions();
        public boolean Pretty = false;
        public boolean EnumsAsNumbers = false;
        public boolean SerializeNullFields = true;
        public boolean Pretty_TrailingLineBreak = true;

        static {
            SerializerOptions.DefaultPretty.Pretty = true;
            SerializerOptions.DefaultMinimal.SerializeNullFields = false;
            SerializerOptions.DefaultMinimal.Pretty_TrailingLineBreak = false;
            SerializerOptions.DefaultMinimal.EnumsAsNumbers = true;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Wrap {
    }
}

