/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.updateoverlay;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.audio.wav.SimpleSound;
import com.iosoft.helpers.awt.ImageCollection;
import com.iosoft.helpers.datasource.Resource;
import com.iosoft.helpers.game.ITicking;
import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.iogame.Game;
import com.iosoft.iogame.assets.ImageLoader;
import com.iosoft.iogame.updateoverlay.IUpdateOverlayHost;
import com.iosoft.iogame.updateoverlay.UpdateOverlay;
import com.iosoft.iogame.updateoverlay.UpdateOverlayAssets;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JLabel;

public class UpdateOverlayService
implements IDisposable {
    public final ILocalizer Localizer;
    public final ITicking Ticker;
    public final IUpdateOverlayHost OverlayHost;
    public boolean AutoUnloadAssetsOnClose = true;
    public Supplier<JLabel> LabelFactory = JLabel::new;
    public Function<String, UpdateOverlay> UpdateOverlayFactory = x -> new UpdateOverlay(this, (String)x);
    public URI Target;
    public Runnable OnClick;
    public BufferedImage Update;
    public ImageCollection UpdateButton;
    public Font FontUpdateAvailable;
    public Font FontGameName;
    public Font FontVersion;
    public Font FontUpdateClick;
    private VTask taskLoading;

    public UpdateOverlayService(ILocalizer localizer, ITicking ticker, IUpdateOverlayHost overlayHost) {
        this.Localizer = Misc.notNull(localizer);
        this.Ticker = Misc.notNull(ticker);
        this.OverlayHost = Misc.notNull(overlayHost);
        this.makeFonts(new JLabel().getFont());
    }

    public UpdateOverlayService(Game<?> game, ITicking ticker, String url, Runnable onClick, IUpdateOverlayHost overlayHost) {
        this(game.Localizer, ticker, overlayHost);
        game.registerOnShutdown(this::dispose);
        this.setTarget(url);
        game.addAsset(new UpdateOverlayAssets());
        this.OnClick = onClick;
    }

    public Task<UpdateOverlay> showAsync(String version) {
        return this.loadAssetsAsync().awaitAndContinue(() -> {
            UpdateOverlay updateOverlay = this.UpdateOverlayFactory.apply(version);
            this.setUpdateOverlayVisible(updateOverlay, true);
            return updateOverlay;
        });
    }

    public VTask loadAssetsAsync() {
        if (this.Update != null && this.UpdateButton != null) {
            return VTask.COMPLETED_TASK;
        }
        if (this.taskLoading == null) {
            this.taskLoading = Async.runAsyncEnforced(() -> {
                ImageLoader img = new ImageLoader("/res/ioengine/images/");
                return new Pair<BufferedImage, ImageCollection>(img.load("update.png"), img.load("update_button.png", 2, 1));
            }).awaitAndContinue(x -> {
                this.taskLoading = null;
                this.Update = (BufferedImage)x.V1;
                this.UpdateButton = (ImageCollection)x.V2;
            });
        }
        return this.taskLoading;
    }

    public void unloadAssets() {
        if (this.Update != null) {
            this.Update.flush();
            this.Update = null;
        }
        if (this.UpdateButton != null) {
            this.UpdateButton.dispose();
            this.UpdateButton = null;
        }
    }

    public void makeFonts(Font font) {
        Misc.notNull(font);
        this.FontUpdateAvailable = font.deriveFont(0, 14.0f);
        this.FontGameName = font.deriveFont(1, 13.0f);
        this.FontVersion = font.deriveFont(1, 16.0f);
        this.FontUpdateClick = font.deriveFont(2, 12.0f);
    }

    public void setTarget(String uri) {
        this.Target = URI.create(uri);
    }

    protected void onClick() {
        if (this.OnClick != null) {
            this.OnClick.run();
        }
    }

    @Override
    public void dispose() {
        if (this.taskLoading != null) {
            this.taskLoading.cancel();
            this.taskLoading = null;
        }
        this.unloadAssets();
    }

    protected void setUpdateOverlayVisible(UpdateOverlay updateOverlay, boolean show) {
        if (show) {
            Async.runAsyncWrap(() -> SimpleSound.playOnce(new Resource("/res/ioengine/sound/update.wav")));
        } else if (this.AutoUnloadAssetsOnClose) {
            this.unloadAssets();
        }
        this.OverlayHost.setUpdateOverlayVisible(updateOverlay, show);
    }
}

