/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.updateoverlay;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.binding.Disposables;
import com.iosoft.helpers.game.ITickable;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.ui.awt.Picture;
import com.iosoft.iogame.updateoverlay.UpdateOverlayService;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class UpdateOverlay
extends JPanel
implements ITickable,
IDisposable {
    private static final long serialVersionUID = 1L;
    private static final Border Border1 = BorderFactory.createEtchedBorder(Color.GRAY, Color.DARK_GRAY);
    private static final Border Border2 = BorderFactory.createEtchedBorder(Color.LIGHT_GRAY, Color.GRAY);
    private final UpdateOverlayService service;
    private final Picture buttonPic;
    private final Disposables disposables = new Disposables();
    private long lastTick = Stopwatch.start();
    private double pos;
    private double max;
    private boolean hiding;
    private boolean _nonTickMode;

    public UpdateOverlay(final UpdateOverlayService service, String version) {
        super(null);
        this.setOpaque(false);
        this.service = service;
        this.max = 0.0;
        this.pos = -120.0;
        this.setCursor(Cursor.getPredefinedCursor(12));
        JLabel label = service.LabelFactory.get();
        UpdateOverlay.center(label);
        label.setBounds(0, 0, 150, 30);
        this.disposables.addDisposable(service.Localizer.bind("_UI_UpdateAvailable", label::setText));
        label.setFont(service.FontUpdateAvailable);
        label.setForeground(Color.DARK_GRAY);
        this.add(label);
        label = service.LabelFactory.get();
        MiscAWT.disableHTML(label);
        UpdateOverlay.center(label);
        label.setBounds(0, 30, 150, 20);
        this.disposables.addDisposable(service.Localizer.bind("_GameName", label::setText));
        label.setFont(service.FontGameName);
        label.setForeground(new Color(100, 0, 0));
        this.add(label);
        label = service.LabelFactory.get();
        MiscAWT.disableHTML(label);
        UpdateOverlay.center(label);
        label.setText(version);
        label.setBounds(0, 50, 150, 20);
        label.setFont(service.FontVersion);
        label.setForeground(new Color(55, 0, 0));
        this.add(label);
        label = service.LabelFactory.get();
        MiscAWT.disableHTML(label);
        UpdateOverlay.center(label);
        label.setBounds(11, 70, 50, 20);
        this.disposables.addDisposable(service.Localizer.bind("_UI_UpdateClick", label::setText));
        label.setFont(service.FontUpdateClick);
        label.setForeground(Color.GRAY);
        this.add(label);
        this.buttonPic = new Picture(110, 70, 20, 20, this.getButtonImage(false));
        this.buttonPic.setCursor(Cursor.getPredefinedCursor(0));
        this.buttonPic.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (!UpdateOverlay.this.hiding) {
                    UpdateOverlay.this.hiding = true;
                    UpdateOverlay.this.lastTick = Stopwatch.start();
                    service.Ticker.addTickable(UpdateOverlay.this);
                    service.onClick();
                }
                if (UpdateOverlay.this._nonTickMode) {
                    UpdateOverlay.this.pos = -1000.0;
                    UpdateOverlay.this.tick();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                UpdateOverlay.this.buttonPic.setImage(UpdateOverlay.this.getButtonImage(true));
                UpdateOverlay.this.buttonPic.repaint();
                UpdateOverlay.this.buttonPic.setBorder(Border1);
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                UpdateOverlay.this.buttonPic.setImage(UpdateOverlay.this.getButtonImage(false));
                UpdateOverlay.this.buttonPic.repaint();
                UpdateOverlay.this.buttonPic.setBorder(Border2);
            }
        });
        this.add(this.buttonPic);
        this.buttonPic.setBorder(Border2);
        if (Desktop.isDesktopSupported()) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent arg0) {
                    service.onClick();
                    try {
                        Desktop.getDesktop().browse(service.Target);
                    }
                    catch (IOException | UnsupportedOperationException ex) {
                        Log.UI.errorFull("Cannot open update site in browser", ex);
                    }
                }
            });
        }
        this.setSize(150, 120);
        service.Ticker.addTickable(this);
        this.tick();
    }

    private static void center(JLabel label) {
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
    }

    private Image getButtonImage(boolean active) {
        if (this.service.UpdateButton == null) {
            return null;
        }
        return this.service.UpdateButton.Images[active ? 1 : 0];
    }

    public void setWindowWidth(int width) {
        this.setLocation(width - 170, (int)Math.round(this.pos));
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.service.Update, 0, 0, null);
    }

    @Override
    public boolean tick() {
        long now = Stopwatch.start();
        double seconds = Stopwatch.getSeconds(this.lastTick, now);
        this.lastTick = now;
        if (this.hiding) {
            this.pos = Math.max(-120.0, this.pos - 240.0 * seconds);
            if (this.pos <= -120.0) {
                this.service.setUpdateOverlayVisible(this, false);
                return false;
            }
            this.setLocation(this.getX(), (int)Math.round(this.pos));
            MiscAWT.repaintWindow(this);
        } else {
            this.max = Math.min(100.0, this.max + 60.0 * seconds);
            this.pos = this.max <= 50.0 ? (double)((int)(-140.0 * Math.cos(Math.PI * (this.max / 100.0)))) : (double)((int)(-Math.abs(Math.sin((this.max - 50.0) / 10.0) * (this.max - 100.0))));
            this.setLocation(this.getX(), (int)Math.round(this.pos));
            MiscAWT.repaintWindow(this);
            if (this.max >= 100.0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void setNonTickMode() {
        this._nonTickMode = true;
        if (!this.hiding) {
            this.max = 1000.0;
            this.tick();
        }
    }
}

