/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.ui.awt;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.iogame.ui.awt.GraphicsDeviceConfig;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.VolatileImage;

public final class VolatileImageSurface
implements IDisposable,
WindowStateListener {
    public VolatileImage Image;
    public Graphics2D Graphics;
    public boolean IsDirty;
    public boolean UseBestQuality;
    public int ImageTransparency = 1;
    public boolean DoLogging = false;
    public static final Log.Category Log = new Log.Category("VolatileImageSurface");
    private UacState _windowsUacHackFix = UacState.Ok;
    private boolean _contentsLost;
    private boolean _disposed;
    private Window _windowForScreen;
    private final Dimension _desiredSize = new Dimension();

    public void setWindow(Window windowForScreen) {
        this.unregisterWindowListener();
        this._windowForScreen = windowForScreen;
        if (this._windowForScreen != null) {
            this._windowForScreen.addWindowStateListener(this);
        }
    }

    private void unregisterWindowListener() {
        if (this._windowForScreen != null) {
            this._windowForScreen.removeWindowStateListener(this);
            this._windowForScreen = null;
        }
    }

    public void setSize(int width, int height) {
        this._desiredSize.setSize(width, height);
    }

    public boolean startRender() {
        boolean recreateBuffer;
        if (this._disposed || this._desiredSize.width <= 0 || this._desiredSize.height <= 0) {
            return false;
        }
        GraphicsConfiguration gc = null;
        if (this._windowForScreen != null) {
            gc = GraphicsDeviceConfig.tryFindConfig(this._windowForScreen);
        }
        if (gc == null) {
            gc = MiscAWT.getGraphicsConfiguration();
        }
        boolean bl = recreateBuffer = this.Image == null || this.Image.getWidth() != this._desiredSize.width || this.Image.getHeight() != this._desiredSize.height;
        if (!recreateBuffer) {
            int validationResult = this.Image.validate(gc);
            switch (validationResult) {
                case 2: {
                    if (this.DoLogging) {
                        Log.info("SURFACE INCOMPATIBLE, REQUIRES RECREATION");
                    }
                    recreateBuffer = true;
                    break;
                }
                case 1: {
                    if (this.DoLogging) {
                        Log.info("IMAGE RESTORED " + validationResult + " - " + this._contentsLost + " -> Dirty!");
                    }
                    if (this._windowsUacHackFix == UacState.WindowStateChangedNoContentsLost || !this._contentsLost && this._windowsUacHackFix == UacState.ValidateOkWaitForForRestoredWithLost) {
                        if (this.DoLogging) {
                            Log.info("WINDOWS UAC LEVEL " + (Object)((Object)this._windowsUacHackFix) + " - triggered, recreating!");
                        }
                        recreateBuffer = true;
                        break;
                    }
                    this.IsDirty = true;
                    break;
                }
                case 0: {
                    if (this._contentsLost) {
                        this.IsDirty = true;
                        if (this.DoLogging) {
                            Log.info("IMAGE OK BUT CONTENTS WERE PREVIOUSLY LOST");
                        }
                        if (this._windowsUacHackFix != UacState.ContentsLostWaitForValidate) break;
                        this._windowsUacHackFix = UacState.ValidateOkWaitForForRestoredWithLost;
                        if (!this.DoLogging) break;
                        Log.info("WINDOWS UAC LEVEL 1->2");
                        break;
                    }
                    if (this._windowsUacHackFix != UacState.WindowStateChangedNoContentsLost) break;
                    if (this.DoLogging) {
                        Log.info("WINDOWS UAC LEVEL " + (Object)((Object)this._windowsUacHackFix) + "->0");
                    }
                    this._windowsUacHackFix = UacState.Ok;
                    break;
                }
            }
        }
        if (recreateBuffer) {
            if (this.DoLogging) {
                Log.info("RECREATING SURFACE");
            }
            this.clear();
            this.Image = gc.createCompatibleVolatileImage(this._desiredSize.width, this._desiredSize.height, this.ImageTransparency);
            this.Graphics = this.Image.createGraphics();
            if (this.UseBestQuality) {
                MiscAWT.setBestQuality(this.Graphics);
            }
            this._contentsLost = false;
            this._windowsUacHackFix = UacState.Ok;
            this.IsDirty = true;
        }
        return true;
    }

    public boolean endRender() {
        if (this.Image.contentsLost()) {
            if (this._windowsUacHackFix == UacState.WindowStateChangedWaitOneCycle || this._windowsUacHackFix == UacState.WindowStateChangedNoContentsLost) {
                if (this.DoLogging) {
                    Log.info("STILL NOT FIXED AND CONTENTS LOST -> reset");
                }
                this.clear();
                return false;
            }
            if (this._contentsLost) {
                if (this.DoLogging) {
                    Log.info("CONTENTS STILL LOST");
                }
            } else {
                if (this.DoLogging) {
                    Log.info("CONTENTS LOST :(");
                }
                this._contentsLost = true;
            }
            if (this._windowsUacHackFix == UacState.Ok && Misc.IsOnWindows) {
                if (this.DoLogging) {
                    Log.info("WINDOWS UAC LEVEL 0->1");
                }
                this._windowsUacHackFix = UacState.ContentsLostWaitForValidate;
            }
            return false;
        }
        if (this._windowsUacHackFix == UacState.WindowStateChangedWaitOneCycle) {
            this._windowsUacHackFix = UacState.WindowStateChangedNoContentsLost;
        }
        this._contentsLost = false;
        return true;
    }

    public void clear() {
        if (this.Image != null) {
            this.Graphics.dispose();
            this.Graphics = null;
            this.Image.flush();
            this.Image = null;
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        if (this.Image != null) {
            if (this.DoLogging) {
                Log.info("WINDOW STATE CHANGED, UAC PRIMED TO 3: " + e.paramString());
            }
            this._windowsUacHackFix = UacState.WindowStateChangedWaitOneCycle;
        }
    }

    @Override
    public void dispose() {
        if (this.DoLogging) {
            Log.info("DISPOSE");
        }
        this.unregisterWindowListener();
        this._disposed = true;
        this.clear();
    }

    private static enum UacState {
        Ok,
        ContentsLostWaitForValidate,
        ValidateOkWaitForForRestoredWithLost,
        WindowStateChangedWaitOneCycle,
        WindowStateChangedNoContentsLost,
        WindowStateChangedContentsLost;

    }
}

