/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.ui.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Comparator;
import java.util.stream.Stream;

public final class GraphicsDeviceConfig {
    public final int Area;
    public final GraphicsDevice Device;
    public final GraphicsConfiguration Config;

    private GraphicsDeviceConfig(int area, GraphicsDevice device, GraphicsConfiguration config) {
        this.Area = area;
        this.Device = device;
        this.Config = config;
    }

    public static GraphicsConfiguration tryFindConfig(Window window) {
        GraphicsDeviceConfig config = GraphicsDeviceConfig.tryFind(window);
        return config == null ? null : config.Config;
    }

    public static GraphicsDevice tryFindDeviceOrDefault(Window window) {
        GraphicsDeviceConfig config = GraphicsDeviceConfig.tryFind(window);
        return config == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice() : config.Device;
    }

    public static GraphicsDeviceConfig tryFind(Window window) {
        Rectangle windowBounds = window.getBounds();
        return Stream.of(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).flatMap(device -> Stream.of(device.getConfigurations()).map(configuration -> {
            Rectangle graphicsBounds = configuration.getBounds();
            Rectangle intersection = windowBounds.intersection(graphicsBounds);
            int area = intersection.width * intersection.height;
            return area > 0 ? new GraphicsDeviceConfig(area, (GraphicsDevice)device, (GraphicsConfiguration)configuration) : null;
        })).filter(x -> x != null).sorted(Comparator.comparingInt(x -> x.Area).reversed()).findFirst().orElse(null);
    }
}

