/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.ui.awt;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.iogame.ui.awt.AWTFullscreenHelper;
import com.iosoft.iogame.ui.awt.IWindowModel;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.event.KeyEvent;
import java.io.File;

public class GlobalEventHandler
implements KeyEventDispatcher {
    private final Component _content;
    private final AWTFullscreenHelper _fullscreenHelper;
    private final IWindowModel _model;

    public GlobalEventHandler(Component content, AWTFullscreenHelper fullscreenHelper, IWindowModel model) {
        this._content = content;
        this._fullscreenHelper = fullscreenHelper;
        this._model = model;
    }

    public boolean tryTakeScrenshot() {
        File path = this._model.onTakeScreenshot();
        if (path == null || this._content == null) {
            return false;
        }
        MiscImg.takeScreenshot(this._content, path);
        Log.UI.info("Screenshot taken!");
        return true;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        Boolean handled = this._model.onGlobalKeyEvent(e);
        if (handled != null) {
            return handled;
        }
        if (e.getID() == 402) {
            switch (e.getKeyCode()) {
                case 154: {
                    return this.tryTakeScrenshot();
                }
            }
        } else if (e.getID() == 401) {
            switch (e.getKeyCode()) {
                case 10: {
                    if (MiscAWT.isAltDown(e)) {
                        this._fullscreenHelper.ToggleFullscreen.tryPerform();
                        return true;
                    }
                    return false;
                }
                case 122: {
                    this._fullscreenHelper.ToggleFullscreen.tryPerform();
                    return true;
                }
                case 123: {
                    return this.tryTakeScrenshot();
                }
                case 27: {
                    return this._model.onEsc();
                }
            }
        }
        return false;
    }
}

