/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.ui.awt;

import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.iogame.ui.awt.AWTFullscreenHelper;
import com.iosoft.iogame.ui.awt.GlobalEventHandler;
import com.iosoft.iogame.ui.awt.IWindowModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JFrame;

public class GenericWindow {
    public final JFrame Frame;
    public final AWTFullscreenHelper AWTFullscreenHelper = new AWTFullscreenHelper(AWTFullscreenHelper.SizeMode.FULLSCREEN);
    public final GlobalEventHandler GlobalEventHandler;

    public GenericWindow(String title, Component content, IWindowModel model, Dimension minSize) {
        this(new JFrame(title), content, model, minSize);
        MiscAWT.maximizeFrame(this.Frame);
        this.Frame.setVisible(true);
    }

    public GenericWindow(JFrame frame, Component content, final IWindowModel model, Dimension minSize) {
        this.Frame = frame;
        if (frame.getIconImage() == null) {
            frame.setIconImage(MiscImg.createCompatibleImage(1, 1));
        }
        this.AWTFullscreenHelper.setWindow(this.Frame);
        this.Frame.setDefaultCloseOperation(2);
        this.Frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (!GenericWindow.this.AWTFullscreenHelper.SwitchingFullscreen.get()) {
                    model.onClose();
                }
            }
        });
        if (content != null) {
            this.Frame.add(content);
        }
        this.Frame.pack();
        this.Frame.setLocationRelativeTo(null);
        if (content == null) {
            content = this.Frame.getRootPane();
        }
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.GlobalEventHandler = new GlobalEventHandler(content, this.AWTFullscreenHelper, model);
        manager.addKeyEventDispatcher(this.GlobalEventHandler);
        if (minSize != null) {
            MiscAWT.setMinimumWindowSize(this.Frame, minSize);
        }
        this.Frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                model.onWindowFocus(e, false);
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                model.onWindowFocus(e, true);
            }
        });
        this.Frame.getRootPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                model.onResize();
            }
        });
    }

    public void redraw() {
        if (this.Frame != null) {
            this.Frame.revalidate();
            this.Frame.repaint();
        }
    }
}

