/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.ui.awt;

import com.iosoft.helpers.game.ITickable;
import com.iosoft.helpers.ui.awt.MiscAWT;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class Fader
extends JPanel
implements ITickable {
    private static final long serialVersionUID = 1L;
    private int time;
    private int fadeIn;
    private int fadeOut;
    private boolean stopped;
    private final boolean skipIt;
    private final Runnable onBlack;
    private final Runnable onDone;

    public Fader(int maxFadeIn, int maxFadeOut, Runnable onBlack, Runnable onDone, final Runnable onClick, boolean skip, final boolean canClickWhileFadeIn) {
        super(null);
        this.onBlack = onBlack;
        this.onDone = onDone;
        this.skipIt = skip;
        this.fadeIn = maxFadeIn;
        this.fadeOut = -maxFadeOut;
        this.stopped = false;
        this.time = 0;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (onClick != null && (canClickWhileFadeIn || Fader.this.time > Fader.this.fadeIn)) {
                    onClick.run();
                }
            }
        });
    }

    @Override
    public boolean tick() {
        if (this.stopped) {
            return false;
        }
        if (this.skipIt) {
            this.doAction();
            this.doActionOnFinished();
        } else {
            ++this.time;
            if (this.time == this.fadeIn) {
                this.doAction();
                this.time = this.fadeOut;
            } else if (this.time == 0) {
                this.doActionOnFinished();
            }
        }
        MiscAWT.repaintWindow(this);
        return true;
    }

    private void doAction() {
        if (this.onBlack != null) {
            this.onBlack.run();
        }
    }

    private void doActionOnFinished() {
        this.stopped = true;
        if (this.onDone != null) {
            this.onDone.run();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(new Color(0, 0, 0, (int)((this.time > 0 ? (float)this.time / (float)this.fadeIn : (float)this.time / (float)this.fadeOut) * 255.0f)));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }
}

