/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.ui.awt;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.Command;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.iogame.ui.awt.GraphicsDeviceConfig;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import javax.swing.SwingUtilities;

public class AWTFullscreenHelper {
    private SizeMode _size;
    private SizeMode _currentSizeMode;
    private GraphicsDevice _graphicsDevice;
    private DisplayMode _fullscreenDisplayMode;
    private DisplayMode _oldDisplayMode;
    private Frame _window;
    private final MyBoolObservable _fullscreened = new MyBoolObservable(false);
    public final BoolObservable Fullscreened;
    private final MyBoolObservable _canGoFullscreen;
    public final Command ToggleFullscreen;
    private final MyBoolObservable _switchingFullscreen;
    public final BoolObservable SwitchingFullscreen;

    public AWTFullscreenHelper(SizeMode size) {
        this(null, size);
    }

    public AWTFullscreenHelper(Frame window, SizeMode size) {
        this.Fullscreened = this._fullscreened.Getter;
        this._canGoFullscreen = new MyBoolObservable(false);
        this.ToggleFullscreen = new Command(this._canGoFullscreen.Getter, () -> this.setFullscreen(!this.Fullscreened.get()));
        this._switchingFullscreen = new MyBoolObservable(false);
        this.SwitchingFullscreen = this._switchingFullscreen.Getter;
        this._size = Misc.notNull(size);
        this.setWindow(window);
        this.SwitchingFullscreen.bind(x -> this.checkCanGoFullscreen());
    }

    public void setSize(SizeMode size) {
        this._size = Misc.notNull(size);
        this.reloadDevices();
    }

    public void setWindow(Frame window) {
        this._window = window;
        this.reloadDevices();
    }

    public void reloadDevices() {
        if (this._size.Exclusive) {
            if (this._window == null) {
                this._graphicsDevice = null;
                this._fullscreenDisplayMode = null;
            } else {
                this._graphicsDevice = GraphicsDeviceConfig.tryFindDeviceOrDefault(this._window);
                if (!this._graphicsDevice.isFullScreenSupported()) {
                    this._graphicsDevice = null;
                    this._fullscreenDisplayMode = null;
                } else {
                    this._oldDisplayMode = this._graphicsDevice.getDisplayMode();
                    this._fullscreenDisplayMode = MiscLINQ.firstOrDefault(this._graphicsDevice.getDisplayModes(), x -> x.getWidth() == this._size.Width && x.getHeight() == this._size.Height && x.getBitDepth() == this._size.BitDepth);
                }
            }
        }
        this.checkCanGoFullscreen();
    }

    private void checkCanGoFullscreen() {
        this._canGoFullscreen.set(!this.SwitchingFullscreen.get() && this._size.Active && (!this._size.Exclusive || this._graphicsDevice != null && this._fullscreenDisplayMode != null));
    }

    private void setFullscreen(boolean doit) {
        this._switchingFullscreen.set(true);
        if (doit) {
            if (!this.Fullscreened.get()) {
                this._window.dispose();
                this._window.setUndecorated(true);
                this._currentSizeMode = this._size;
                if (this._size.Exclusive) {
                    this._graphicsDevice.setFullScreenWindow(this._window);
                    try {
                        this._graphicsDevice.setDisplayMode(this._fullscreenDisplayMode);
                        this._fullscreened.set(true);
                    }
                    catch (IllegalArgumentException | UnsupportedOperationException ex) {
                        try {
                            this._graphicsDevice.setDisplayMode(this._oldDisplayMode);
                        }
                        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                            // empty catch block
                        }
                        this._currentSizeMode = null;
                        this._graphicsDevice.setFullScreenWindow(null);
                        this._window.setUndecorated(false);
                        ex.printStackTrace();
                    }
                    this._window.pack();
                } else {
                    this._fullscreened.set(true);
                    this._window.setVisible(true);
                    this._window.setExtendedState(this._window.getExtendedState() | 6);
                }
                this._window.repaint();
            }
        } else if (this.Fullscreened.get()) {
            this._fullscreened.set(false);
            if (this._currentSizeMode.Exclusive) {
                try {
                    this._graphicsDevice.setDisplayMode(this._oldDisplayMode);
                }
                catch (IllegalArgumentException | UnsupportedOperationException ex) {
                    ex.printStackTrace();
                }
                this._graphicsDevice.setFullScreenWindow(null);
            }
            this._currentSizeMode = null;
            this._window.dispose();
            this._window.setUndecorated(false);
            this._window.setVisible(true);
            this._window.pack();
            this._window.setLocationRelativeTo(null);
            this._window.repaint();
        }
        SwingUtilities.invokeLater(() -> this._switchingFullscreen.set(false));
    }

    public static enum SizeMode {
        INACTIVE(false),
        FULLSCREEN(true),
        S_800_x_600(800, 600, 32);

        public final boolean Exclusive;
        public final boolean Active;
        public final int Width;
        public final int Height;
        public final int BitDepth;

        private SizeMode(boolean active) {
            this.Active = active;
            this.Exclusive = false;
            this.Width = 0;
            this.Height = 0;
            this.BitDepth = 0;
        }

        private SizeMode(int width, int height, int depth) {
            this.Active = true;
            this.Exclusive = true;
            this.Width = width;
            this.Height = height;
            this.BitDepth = depth;
        }
    }
}

