/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.turnbased;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class HybridTurnsFinder {
    private HybridTurnsFinder() {
    }

    public static <T> List<List<T>> simultaneous(Iterable<T> actors, Predicate<T> needsOwnGroup, boolean simultaneousGroupFirst) {
        ArrayList<List<T>> groups = new ArrayList<List<T>>();
        ArrayList<T> simultaneous = new ArrayList<T>();
        for (T actor : actors) {
            if (needsOwnGroup.test(actor)) {
                groups.add(new ArrayList<Object>(Arrays.asList(actor)));
                continue;
            }
            simultaneous.add(actor);
        }
        if (!simultaneous.isEmpty()) {
            if (simultaneousGroupFirst) {
                groups.add(0, simultaneous);
            } else {
                groups.add(simultaneous);
            }
        }
        return groups;
    }

    public static <T> List<List<T>> group(Iterable<T> actors, BiPredicate<T, T> canInteract) {
        return HybridTurnsFinder.group(actors, canInteract, x -> false);
    }

    public static <T> List<List<T>> group(Iterable<T> actors, BiPredicate<T, T> canInteract, Predicate<T> needsOwnGroup) {
        ArrayList<List<T>> groups = new ArrayList<List<T>>();
        ArrayList<List<T>> joinableGroups = new ArrayList<List<T>>();
        for (T actor : actors) {
            List<T> group;
            boolean actorNeedsOwnGroup = needsOwnGroup.test(actor);
            List<T> list = group = actorNeedsOwnGroup ? null : HybridTurnsFinder.findGroup(joinableGroups, actor, canInteract);
            if (group == null) {
                group = new ArrayList<T>();
                groups.add(0, group);
                if (!actorNeedsOwnGroup) {
                    joinableGroups.add(0, group);
                }
            }
            group.add(actor);
        }
        Collections.reverse(groups);
        return groups;
    }

    public static <T> List<T> findGroup(List<List<T>> groups, T actor, BiPredicate<T, T> canInteract) {
        List<T> previousGroup = null;
        for (List<T> group : groups) {
            if (!HybridTurnsFinder.isGoodGroup(group, actor, canInteract)) break;
            previousGroup = group;
        }
        return previousGroup;
    }

    public static <T> boolean isGoodGroup(List<T> group, T actor, BiPredicate<T, T> canInteract) {
        for (T otherActor : group) {
            if (!canInteract.test(actor, otherActor)) continue;
            return false;
        }
        return true;
    }
}

