/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased.rect;

import com.iosoft.helpers.math.Vector2D;
import com.iosoft.iogame.tilebased.pathfinding.IPathfindingModel;
import com.iosoft.iogame.tilebased.pathfinding.PathfindingLink;
import java.util.function.Predicate;

public abstract class TilePathfindingModel<T>
implements IPathfindingModel<T, Double, Double, Double, Double> {
    private static final Double Zero = 0.0;
    protected boolean _diagonalSameCostAsCardinal = false;
    private final Vector2D _pos1 = new Vector2D();
    private final Vector2D _pos2 = new Vector2D();

    protected abstract boolean getPosition(T var1, Vector2D var2);

    @Override
    public Iterable<PathfindingLink<T, Double>> getAdjacentTiles(T tile, Double costSoFar, Predicate<T> filter) {
        return this.getAdjacentTiles(tile, (double)costSoFar, filter);
    }

    @Override
    protected abstract Iterable<PathfindingLink<T, Double>> getAdjacentTiles(T var1, double var2, Predicate<T> var4);

    @Override
    public Double getHeuristicCost(T start, T end, Double currentCost) {
        if (end == null) {
            return Zero;
        }
        if (!this.getPosition(start, this._pos1) || !this.getPosition(end, this._pos2)) {
            return 2.147483647E9;
        }
        return this._pos1.getTaxiDistanceWithDiagonal(this._pos2, this._diagonalSameCostAsCardinal);
    }

    @Override
    public boolean shouldReplace(Double oldCost, Double newCost) {
        return oldCost.compareTo(newCost) > 0;
    }

    @Override
    public int compare(Double o1, Double o2) {
        return o1.compareTo(o2);
    }

    @Override
    public Double addDelta(Double cost1, Double cost2) {
        return cost1 + cost2;
    }

    @Override
    public Double addHeuristic(Double cost1, Double cost2) {
        return cost1 + cost2;
    }

    @Override
    public Double getStartingCost(T tile) {
        return Zero;
    }
}

