/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased.rect;

import com.iosoft.helpers.game.IDirection;
import com.iosoft.helpers.iter.SkippingIterator;
import com.iosoft.helpers.math.Vector2D;
import com.iosoft.iogame.tilebased.pathfinding.PathfindingLink;
import com.iosoft.iogame.tilebased.rect.TilePathfindingModel;
import java.awt.Point;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;

public abstract class PointPathfindingModel<T extends IDirection>
extends TilePathfindingModel<Point> {
    private final Iterable<T> _directions;

    public PointPathfindingModel(Iterable<T> directions) {
        this._directions = directions;
    }

    public PointPathfindingModel(T[] directions) {
        this._directions = Arrays.asList(directions);
    }

    @Override
    protected boolean getPosition(Point tile, Vector2D out_pos) {
        out_pos.put(tile.x, tile.y);
        return true;
    }

    @Override
    protected Iterable<PathfindingLink<Point, Double>> getAdjacentTiles(final Point tile, final double costSoFar, final Predicate<Point> filter) {
        return () -> new SkippingIterator<PathfindingLink<Point, Double>>(){
            final Iterator<T> iterDirection;
            {
                this.iterDirection = PointPathfindingModel.this._directions.iterator();
            }

            @Override
            protected PathfindingLink<Point, Double> findNextElement() {
                while (this.iterDirection.hasNext()) {
                    Double cost;
                    IDirection direction = (IDirection)this.iterDirection.next();
                    Point neighbour = direction.move(tile);
                    if (!PointPathfindingModel.this.isValid(tile, neighbour, direction, costSoFar) || !filter.test(neighbour) || (cost = PointPathfindingModel.this.tryGetCost(tile, neighbour, direction, costSoFar)) == null) continue;
                    return new PathfindingLink<Point, Double>(neighbour, cost);
                }
                this.onEndReached();
                return null;
            }
        };
    }

    protected abstract Double tryGetCost(Point var1, Point var2, T var3, double var4);

    protected boolean isValid(Point start, Point end, T direction, double costSoFar) {
        return true;
    }
}

