/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased.pathfinding;

import com.iosoft.iogame.tilebased.pathfinding.PathfindingEntry;
import java.util.ArrayList;
import java.util.stream.Stream;

public class PathfindingResult<T, Ch, Ct, Ce> {
    public final Ct TotalCost;
    public final PathfindingEntry<T, Ch, Ct, Ce> TargetNode;

    public PathfindingResult(PathfindingEntry<T, Ch, Ct, Ce> targetNode) {
        this.TargetNode = targetNode;
        this.TotalCost = this.TargetNode.CostCurrentTotal;
    }

    public Stream<T> pathTiles() {
        return this.createPath().stream().map(x -> x.Tile);
    }

    public ArrayList<PathfindingEntry<T, Ch, Ct, Ce>> createPath() {
        return this.TargetNode.createPathFromStart();
    }

    public T tryGetNextTile(T start) {
        return this.pathTiles().filter(x -> x != start).findFirst().orElse(null);
    }
}

