/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased.pathfinding;

import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.Mutable;
import com.iosoft.iogame.tilebased.pathfinding.IPathfindingModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class PathfindingEntry<T, Ch, Ct, Ce> {
    public final T Tile;
    public Ch CostHeuristic;
    public PathfindingEntry<T, Ch, Ct, Ce> CurrentParent;
    public Ct CostCurrentTotal;
    public Ce CostEstimated;

    public PathfindingEntry(T tile, PathfindingEntry<T, Ch, Ct, Ce> newParent, Ct newTotalCost, IPathfindingModel<T, Ch, Ct, Ce, ?> model, T heuristicTarget) {
        this.Tile = tile;
        this.setParent(newParent, newTotalCost, model);
        this.setHeuristicCost(heuristicTarget, model);
        this.calculateEstimation(model);
    }

    public void setHeuristic(T heuristicTarget, IPathfindingModel<T, Ch, Ct, Ce, ?> model) {
        this.setHeuristicCost(heuristicTarget, model);
        this.calculateEstimation(model);
    }

    private void setHeuristicCost(T heuristicTarget, IPathfindingModel<T, Ch, Ct, Ce, ?> model) {
        this.CostHeuristic = model.getHeuristicCost(this.Tile, heuristicTarget, this.CostCurrentTotal);
    }

    public boolean trySetParent(PathfindingEntry<T, Ch, Ct, Ce> newParent, Ct newTotalCost, IPathfindingModel<T, Ch, Ct, Ce, ?> model) {
        if (!model.shouldReplace(this.CostCurrentTotal, newTotalCost)) {
            return false;
        }
        this.setParent(newParent, newTotalCost, model);
        this.calculateEstimation(model);
        return true;
    }

    private void setParent(PathfindingEntry<T, Ch, Ct, Ce> newParent, Ct newTotalCost, IPathfindingModel<T, Ch, Ct, Ce, ?> model) {
        this.CurrentParent = newParent;
        this.CostCurrentTotal = newTotalCost;
    }

    private void calculateEstimation(IPathfindingModel<T, Ch, Ct, Ce, ?> model) {
        this.CostEstimated = model.addHeuristic(this.CostCurrentTotal, this.CostHeuristic);
    }

    public Iterable<PathfindingEntry<T, Ch, Ct, Ce>> tracePathBack() {
        return () -> {
            final Mutable<PathfindingEntry> entry = new Mutable<PathfindingEntry>(this);
            return new Iterator<PathfindingEntry<T, Ch, Ct, Ce>>(){

                @Override
                public boolean hasNext() {
                    return entry.Value != null;
                }

                @Override
                public PathfindingEntry<T, Ch, Ct, Ce> next() {
                    PathfindingEntry currentEntry = (PathfindingEntry)entry.Value;
                    entry.Value = currentEntry.CurrentParent;
                    return currentEntry;
                }
            };
        };
    }

    public ArrayList<PathfindingEntry<T, Ch, Ct, Ce>> createPathFromStart() {
        ArrayList<PathfindingEntry<T, Ch, Ct, Ce>> list = MiscLINQ.toList(this.tracePathBack());
        Collections.reverse(list);
        return list;
    }
}

