/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased.pathfinding;

import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.MutableBool;
import com.iosoft.iogame.tilebased.pathfinding.IMultiTarget;
import com.iosoft.iogame.tilebased.pathfinding.PathfindingEntry;
import java.util.Collection;
import java.util.HashSet;

public class HeuristicMultiTarget<T, Ch, Ct, Ce>
implements IMultiTarget<T, Ch, Ct, Ce> {
    private final HashSet<T> _targetList;
    private T _nextTarget;
    private boolean _checkedHasAnyTargets;

    public HeuristicMultiTarget(Collection<T> targets) {
        this._targetList = new HashSet<T>(targets);
        this.setLastTarget();
    }

    @Override
    public boolean isTarget(PathfindingEntry<T, Ch, Ct, Ce> tile, MutableBool out_moreTargetsRemaining) {
        if (this._targetList.remove(tile.Tile)) {
            this.setMoreTargetsRemaining(out_moreTargetsRemaining);
            this.setLastTarget();
            return true;
        }
        if (!this._checkedHasAnyTargets) {
            this.setMoreTargetsRemaining(out_moreTargetsRemaining);
        }
        return false;
    }

    private void setMoreTargetsRemaining(MutableBool out_moreTargetsRemaining) {
        this._checkedHasAnyTargets = true;
        out_moreTargetsRemaining.Value = !this._targetList.isEmpty();
    }

    private void setLastTarget() {
        this._nextTarget = MiscLINQ.firstOrDefault(this._targetList);
    }

    @Override
    public T getHeuristicTarget() {
        return this._nextTarget;
    }
}

