/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased.pathfinding;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.MutableBool;
import com.iosoft.iogame.tilebased.pathfinding.AllReachableResult;
import com.iosoft.iogame.tilebased.pathfinding.CheckingResult;
import com.iosoft.iogame.tilebased.pathfinding.HeuristicMultiTarget;
import com.iosoft.iogame.tilebased.pathfinding.IMultiTarget;
import com.iosoft.iogame.tilebased.pathfinding.IMultiTargetFunction;
import com.iosoft.iogame.tilebased.pathfinding.IPathfindingModel;
import com.iosoft.iogame.tilebased.pathfinding.MultiTargetFixedHeuristicTarget;
import com.iosoft.iogame.tilebased.pathfinding.PathfindingEntry;
import com.iosoft.iogame.tilebased.pathfinding.PathfindingLink;
import com.iosoft.iogame.tilebased.pathfinding.PathfindingResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GenericPathfinding<T, Ch, Ct, Ce, Cd> {
    private final IPathfindingModel<T, Ch, Ct, Ce, Cd> _model;
    private final Function<T, CheckingResult> _filter;
    public boolean StrictClosedListCheck = true;
    public Integer OpenListStartSize;

    public GenericPathfinding(IPathfindingModel<T, Ch, Ct, Ce, Cd> model) {
        this(model, null);
    }

    public GenericPathfinding(IPathfindingModel<T, Ch, Ct, Ce, Cd> model, Function<T, CheckingResult> filter) {
        this._model = Misc.notNull(model);
        this._filter = filter;
    }

    public void visitAll(Consumer<PathfindingEntry<T, Ch, Ct, Ce>> consumer, T ... starts) {
        this.visitAll(new HashSet<T>(Arrays.asList(starts)), consumer);
    }

    public void visitAll(Set<T> starts, Consumer<PathfindingEntry<T, Ch, Ct, Ce>> consumer) {
        this.runMultiTarget(starts, (PathfindingEntry<T, Ch, Ct, Ce> tile, MutableBool out) -> {
            consumer.accept(tile);
            return false;
        });
    }

    public void visit(Predicate<PathfindingEntry<T, Ch, Ct, Ce>> visitor, T ... starts) {
        this.visit(new HashSet<T>(Arrays.asList(starts)), visitor);
    }

    public void visit(Set<T> starts, Predicate<PathfindingEntry<T, Ch, Ct, Ce>> visitor) {
        this.runMultiTarget(starts, (PathfindingEntry<T, Ch, Ct, Ce> node, MutableBool out_hasMoreTargets) -> {
            if (!visitor.test(node)) {
                out_hasMoreTargets.Value = false;
            }
            return false;
        });
    }

    public PathfindingResult<T, Ch, Ct, Ce> run(T start, T target) {
        Misc.notNull(start);
        Misc.notNull(target);
        return this.runMultiStart(target, start);
    }

    public Map<T, PathfindingResult<T, Ch, Ct, Ce>> run(T start, IMultiTarget<T, Ch, Ct, Ce> multiTarget) {
        Misc.notNull(start);
        Misc.notNull(multiTarget);
        return this.runMultiTarget((Set<T>)new HashSet<Object>(Arrays.asList(start)), multiTarget);
    }

    public AllReachableResult runAllReachable(Collection<T> points) {
        Iterator<T> iter = points.iterator();
        if (!iter.hasNext()) {
            return new AllReachableResult(0);
        }
        T start = iter.next();
        HashSet<T> targets = new HashSet<T>();
        while (iter.hasNext()) {
            targets.add(iter.next());
        }
        if (targets.isEmpty()) {
            return new AllReachableResult(0);
        }
        Map<Object, PathfindingResult<Object, Ch, Ct, Ce>> result = this.runMultiTarget((Set<T>)targets, (T[])new Object[]{start});
        if (result.size() > targets.size()) {
            throw new IllegalStateException("Wtf");
        }
        return new AllReachableResult(targets.size() - result.size());
    }

    public PathfindingResult<T, Ch, Ct, Ce> runMultiStart2(Predicate<T> isGoodTarget, T ... starts) {
        return this.runMultiStartHeuristicTarget2(isGoodTarget, null, starts);
    }

    public PathfindingResult<T, Ch, Ct, Ce> runMultiStart(Predicate<PathfindingEntry<T, Ch, Ct, Ce>> isGoodTarget, T ... starts) {
        return this.runMultiStartHeuristicTarget(isGoodTarget, null, starts);
    }

    public PathfindingResult<T, Ch, Ct, Ce> runMultiStart(Set<T> starts, Predicate<PathfindingEntry<T, Ch, Ct, Ce>> isGoodTarget) {
        return this.runMultiStartHeuristicTarget(starts, isGoodTarget, null);
    }

    public final PathfindingResult<T, Ch, Ct, Ce> runMultiStart(Set<T> starts, T tileTarget) {
        Misc.notNull(starts);
        Misc.notNull(tileTarget);
        return this.getSingle(this.runMultiTarget(starts, Collections.singleton(tileTarget)), tileTarget);
    }

    @SafeVarargs
    public final PathfindingResult<T, Ch, Ct, Ce> runMultiStart(T tileTarget, T ... starts) {
        Misc.notNull(tileTarget);
        return this.getSingle(this.runMultiTarget(Collections.singleton(tileTarget), starts), tileTarget);
    }

    public PathfindingResult<T, Ch, Ct, Ce> getSingle(Map<T, PathfindingResult<T, Ch, Ct, Ce>> result, T target) {
        if (result.isEmpty()) {
            return null;
        }
        return Misc.get(result, target);
    }

    public PathfindingResult<T, Ch, Ct, Ce> runMultiStartHeuristicTarget2(Predicate<T> isGoodTarget, T heuristicTarget, T ... starts) {
        return this.runMultiStartHeuristicTarget((PathfindingEntry<T, Ch, Ct, Ce> x) -> isGoodTarget.test(x.Tile), heuristicTarget, starts);
    }

    public PathfindingResult<T, Ch, Ct, Ce> runMultiStartHeuristicTarget(Predicate<PathfindingEntry<T, Ch, Ct, Ce>> isGoodTarget, T heuristicTarget, T ... starts) {
        return this.runMultiStartHeuristicTarget(new HashSet<T>(Arrays.asList(starts)), isGoodTarget, heuristicTarget);
    }

    public PathfindingResult<T, Ch, Ct, Ce> runMultiStartHeuristicTarget(Set<T> starts, final Predicate<PathfindingEntry<T, Ch, Ct, Ce>> isGoodTarget, final T heuristicTarget) {
        Misc.notNull(isGoodTarget);
        Map<T, PathfindingResult<T, Ch, Ct, Ce>> result = this.runMultiTarget(starts, new IMultiTarget<T, Ch, Ct, Ce>(){

            @Override
            public boolean isTarget(PathfindingEntry<T, Ch, Ct, Ce> tile, MutableBool out_moreTargetsRemaining) {
                if (isGoodTarget.test(tile)) {
                    out_moreTargetsRemaining.Value = false;
                    return true;
                }
                return false;
            }

            @Override
            public T getHeuristicTarget() {
                return heuristicTarget;
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return MiscLINQ.first(result.values());
    }

    public Map<T, PathfindingResult<T, Ch, Ct, Ce>> runMultiTarget(T start, T ... targets) {
        Misc.notNull(start);
        return this.runMultiTarget((Set<T>)new HashSet<T>(Arrays.asList(targets)), (T[])new Object[]{start});
    }

    @SafeVarargs
    public final Map<T, PathfindingResult<T, Ch, Ct, Ce>> runMultiTarget(Set<T> targets, T ... starts) {
        return this.runMultiTarget((Set<T>)new HashSet<T>(Arrays.asList(starts)), targets);
    }

    public Map<T, PathfindingResult<T, Ch, Ct, Ce>> runMultiTarget(Set<T> starts, Set<T> targets) {
        Misc.notNull(targets);
        return this.runMultiTarget(starts, new HeuristicMultiTarget(targets));
    }

    @SafeVarargs
    public final Map<T, PathfindingResult<T, Ch, Ct, Ce>> runMultiTarget(T heuristicTarget, IMultiTargetFunction<T, Ch, Ct, Ce> multiTargetFunc, T ... starts) {
        return this.runMultiTarget((Set<T>)new HashSet<T>(Arrays.asList(starts)), new MultiTargetFixedHeuristicTarget<T, Ch, Ct, Ce>(multiTargetFunc, heuristicTarget));
    }

    @SafeVarargs
    public final Map<T, PathfindingResult<T, Ch, Ct, Ce>> runMultiTarget(IMultiTargetFunction<T, Ch, Ct, Ce> multiTargetFunc, T ... starts) {
        return this.runMultiTarget((T)null, multiTargetFunc, starts);
    }

    public final Map<T, PathfindingResult<T, Ch, Ct, Ce>> runMultiTarget(Set<T> starts, IMultiTargetFunction<T, Ch, Ct, Ce> multiTargetFunc) {
        return this.runMultiTarget(starts, new MultiTargetFixedHeuristicTarget<Object, Ch, Ct, Ce>(multiTargetFunc, null));
    }

    public Map<T, PathfindingResult<T, Ch, Ct, Ce>> runMultiTarget(Set<T> starts, IMultiTarget<T, Ch, Ct, Ce> multiTarget) {
        Misc.notNull(multiTarget);
        HashSet closedList = new HashSet();
        HashSet permaAllowedList = new HashSet();
        HashMap openListLookup = new HashMap();
        ArrayList<PathfindingEntry<T, Ch, Ct, Ce>> openList = this.OpenListStartSize == null ? new ArrayList<PathfindingEntry<T, Ch, Ct, Ce>>() : new ArrayList(this.OpenListStartSize);
        Mutable<T> heuristicTarget = new Mutable<T>(multiTarget.getHeuristicTarget());
        BooleanSupplier checkHeuristicTarget = () -> {
            Object newHeuristicTarget = multiTarget.getHeuristicTarget();
            if (newHeuristicTarget == mutable.Value) {
                return false;
            }
            mutable.Value = newHeuristicTarget;
            for (PathfindingEntry entry : openList) {
                entry.setHeuristic(mutable.Value, this._model);
            }
            return true;
        };
        for (T start : starts) {
            PathfindingEntry<T, Ch, Ct, Ce> entryStart = new PathfindingEntry<T, Ch, Ct, Ce>(Misc.notNull(start), null, this._model.getStartingCost(start), this._model, heuristicTarget.Value);
            openList.add(entryStart);
            openListLookup.put(start, entryStart);
        }
        Comparator openListComparer = (o1, o2) -> this._model.compare(o2.CostEstimated, o1.CostEstimated);
        checkHeuristicTarget.getAsBoolean();
        openList.sort(openListComparer);
        Predicate<Object> filter = this._filter == null ? x -> !closedList.contains(x) : x -> {
            if (closedList.contains(x)) {
                return false;
            }
            if (permaAllowedList.contains(x)) {
                return true;
            }
            CheckingResult result = this._filter.apply(x);
            switch (result) {
                case BadAlways: {
                    closedList.add(x);
                    return false;
                }
                case GoodAlways: {
                    permaAllowedList.add(x);
                    return true;
                }
                case BadRecheck: {
                    return false;
                }
                case GoodRecheck: {
                    return true;
                }
            }
            throw new IllegalStateException("Unknown result " + (Object)((Object)result));
        };
        HashMap targets = new HashMap();
        MutableBool hasMoreTargets = new MutableBool(true);
        while (!openList.isEmpty()) {
            PathfindingEntry currentEntry = (PathfindingEntry)openList.remove(openList.size() - 1);
            this._model.onEvaluated(currentEntry);
            boolean foundTarget = multiTarget.isTarget(currentEntry, hasMoreTargets);
            if (foundTarget) {
                targets.put(currentEntry.Tile, currentEntry);
            }
            if (!hasMoreTargets.Value) break;
            if (!closedList.add(currentEntry.Tile) && this.StrictClosedListCheck) {
                throw new IllegalStateException("Could not add " + currentEntry.Tile + " to the closed list!?");
            }
            boolean openListChanged = foundTarget && checkHeuristicTarget.getAsBoolean();
            for (PathfindingLink<Object, Cd> link : this._model.getAdjacentTiles(currentEntry.Tile, currentEntry.CostCurrentTotal, filter)) {
                PathfindingEntry<T, Ch, Ct, Ce> entry = (PathfindingEntry<T, Ch, Ct, Ce>)openListLookup.get(link.ToTile);
                Ct costFromThisTile = this._model.addDelta(currentEntry.CostCurrentTotal, link.Cost);
                if (entry == null) {
                    entry = new PathfindingEntry<T, Ch, Ct, Ce>(link.ToTile, currentEntry, costFromThisTile, this._model, heuristicTarget.Value);
                    openList.add(entry);
                    openListLookup.put(link.ToTile, entry);
                    openListChanged = true;
                    continue;
                }
                if (!entry.trySetParent(currentEntry, costFromThisTile, this._model)) continue;
                openListChanged = true;
            }
            if (!openListChanged) continue;
            openList.sort(openListComparer);
        }
        return targets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new PathfindingResult((PathfindingEntry)x.getValue())));
    }
}

