/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased.pathfinding;

import com.iosoft.helpers.MutableBool;
import com.iosoft.iogame.tilebased.pathfinding.HeuristicMultiTarget;
import com.iosoft.iogame.tilebased.pathfinding.PathfindingEntry;
import java.util.Collection;
import java.util.Comparator;

public class ClosestTileMultiTarget<T, Ch, Ct, Ce>
extends HeuristicMultiTarget<T, Ch, Ct, Ce> {
    private PathfindingEntry<T, Ch, Ct, Ce> _closestEntry;
    private final Comparator<PathfindingEntry<T, Ch, Ct, Ce>> _entryComparer;

    public ClosestTileMultiTarget(Collection<T> targets, Comparator<PathfindingEntry<T, Ch, Ct, Ce>> entryComparer) {
        super(targets);
        this._entryComparer = entryComparer;
    }

    @Override
    public boolean isTarget(PathfindingEntry<T, Ch, Ct, Ce> entry, MutableBool out_moreTargetsRemaining) {
        if (this._closestEntry == null || this._entryComparer.compare(this._closestEntry, entry) > 0) {
            this._closestEntry = entry;
        }
        return super.isTarget(entry, out_moreTargetsRemaining);
    }

    public PathfindingEntry<T, Ch, Ct, Ce> getClosestEntry() {
        return this._closestEntry;
    }

    public T getClosestTile() {
        return this._closestEntry == null ? null : (T)this._closestEntry.Tile;
    }
}

