/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased;

import com.iosoft.helpers.ThrowingBiConsumer;
import com.iosoft.helpers.ThrowingFunction;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.iogame.tilebased.ExplorationStatus;
import com.iosoft.iogame.tilebased.VisibleTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VisiblesDelta<T> {
    public VisibleTile<T>[] DeltaTiles;

    public static <T> VisiblesDelta<T> deserialize(DataInputStream in, ThrowingFunction<DataInputStream, T, IOException> terrainReader) throws IOException {
        VisiblesDelta<T> delta = new VisiblesDelta<T>();
        delta.DeltaTiles = new VisibleTile[MiscIO.readPackedUInt(in)];
        int i = 0;
        while (i < delta.DeltaTiles.length) {
            delta.DeltaTiles[i] = new VisibleTile<T>(MiscIO.readPointUByte(in), terrainReader.apply(in), ExplorationStatus.read(in));
            ++i;
        }
        return delta;
    }

    public static <T> void serialize(VisiblesDelta<T> delta, DataOutputStream out, ThrowingBiConsumer<T, DataOutputStream, IOException> terrainWriter) throws IOException {
        MiscIO.writePackedUInt(out, delta.DeltaTiles.length);
        VisibleTile<T>[] visibleTileArray = delta.DeltaTiles;
        int n = delta.DeltaTiles.length;
        int n2 = 0;
        while (n2 < n) {
            VisibleTile<T> tile = visibleTileArray[n2];
            MiscIO.writePointUByte(out, tile.Position);
            terrainWriter.accept(tile.Terrain, out);
            tile.Status.write(out);
            ++n2;
        }
    }
}

