/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased;

import com.iosoft.helpers.TriFunction;
import com.iosoft.iogame.tilebased.ExplorationStatus;
import com.iosoft.iogame.tilebased.IGetExplorationStatus;
import com.iosoft.iogame.tilebased.ITileVisibility;
import com.iosoft.iogame.tilebased.TileVisiter;
import com.iosoft.iogame.tilebased.VisEntry;
import com.iosoft.iogame.tilebased.VisibleTile;
import com.iosoft.iogame.tilebased.VisiblesDelta;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.IntStream;

public class VisibilityDeltaBuilder<TStatus extends IGetExplorationStatus & Comparable<TStatus>> {
    private final Dimension _sizeReference;
    private final TStatus _defaultValue;
    private int _height = -1;
    private VisEntry<TStatus>[] _status = new VisEntry[0];
    private boolean _everythingChanged = true;

    public static VisibilityDeltaBuilder<ExplorationStatus> create(Dimension sizeReference) {
        return new VisibilityDeltaBuilder<ExplorationStatus>(sizeReference, ExplorationStatus.UNKNOWN);
    }

    public VisibilityDeltaBuilder(Dimension sizeReference, TStatus defaultValue) {
        this._defaultValue = defaultValue;
        this._sizeReference = sizeReference;
        this.resize();
    }

    private void resize() {
        int length = this._sizeReference.width * this._sizeReference.height;
        if (length != this._status.length || this._height != this._sizeReference.height) {
            this.resize(length);
        }
    }

    private void resize(int num) {
        this._height = this._sizeReference.height;
        this._status = (VisEntry[])IntStream.range(0, num).mapToObj(x -> new VisEntry<TStatus>(this._defaultValue)).toArray(VisEntry[]::new);
        this._everythingChanged = true;
    }

    public void calculate(Iterable<ITileVisibility<TStatus>> visibles) {
        this.resize();
        int i = 0;
        while (i < this._status.length) {
            this._status[i].New = this.getBestStatus(i, visibles);
            ++i;
        }
    }

    public void clear() {
        this.resize(0);
    }

    private TStatus getBestStatus(int index, Iterable<ITileVisibility<TStatus>> visibles) {
        IGetExplorationStatus bestStatus = null;
        for (ITileVisibility<TStatus> visible : visibles) {
            IGetExplorationStatus status = (IGetExplorationStatus)visible.getStatus(index);
            if (bestStatus != null && ((Comparable)((Object)status)).compareTo(bestStatus) <= 0) continue;
            bestStatus = status;
        }
        return (TStatus)bestStatus;
    }

    public <TTile, TDto> VisiblesDelta<TDto> buildDelta(TTile[][] map, TriFunction<TTile, TStatus, TStatus, TDto> tileToVis, Set<TTile> visibles) {
        ArrayList<VisibleTile<TDto>> tiles = new ArrayList<VisibleTile<TDto>>();
        int i = 0;
        while (i < this._status.length) {
            VisEntry<TStatus> entry = this._status[i];
            IGetExplorationStatus sOld = (IGetExplorationStatus)entry.Old;
            IGetExplorationStatus sNew = (IGetExplorationStatus)entry.New;
            int x = i / this._height;
            int y = i % this._height;
            if (this._everythingChanged || !sNew.equals(sOld)) {
                entry.Old = sNew;
                TTile tile = map[x][y];
                tiles.add(new VisibleTile<TDto>(x, y, tileToVis.apply(tile, sOld, sNew), sNew.getExplorationStatus()));
            }
            if (sNew.getExplorationStatus().SeeFull) {
                visibles.add(map[x][y]);
            }
            ++i;
        }
        this._everythingChanged = false;
        VisiblesDelta delta = new VisiblesDelta();
        delta.DeltaTiles = tiles.toArray(new VisibleTile[tiles.size()]);
        return delta;
    }

    public <TTile, TDto> void buildAll(TTile[][] map, TileVisiter<TTile, TStatus> visitTile, Set<TTile> visibles) {
        int i = 0;
        while (i < this._status.length) {
            VisEntry<TStatus> entry = this._status[i];
            IGetExplorationStatus sNew = (IGetExplorationStatus)entry.New;
            IGetExplorationStatus sOld = (IGetExplorationStatus)entry.Old;
            int x = i / this._height;
            int y = i % this._height;
            entry.Old = sNew;
            TTile tile = map[x][y];
            visitTile.visit(i, tile, sOld, sNew);
            if (sNew.getExplorationStatus().SeeFull) {
                visibles.add(map[x][y]);
            }
            ++i;
        }
        this._everythingChanged = false;
    }

    public boolean isVisible(Point point) {
        return this.isVisible(this.getIndex(point));
    }

    public boolean isVisible(int index) {
        return index >= 0 && index < this._status.length && ((IGetExplorationStatus)this._status[index].New).getExplorationStatus().SeeFull;
    }

    public boolean isExplored(Point point) {
        return this.isExplored(this.getIndex(point));
    }

    public boolean isExplored(int index) {
        return index >= 0 && index < this._status.length && ((IGetExplorationStatus)this._status[index].New).getExplorationStatus().Explored;
    }

    private int getIndex(Point point) {
        return point.x * this._height + point.y;
    }
}

