/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased;

import com.iosoft.helpers.Mutable;
import com.iosoft.iogame.tilebased.ActorVisibility;
import com.iosoft.iogame.tilebased.ExplorationStatus;
import java.awt.Dimension;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleActorVisibility
extends ActorVisibility<ExplorationStatus> {
    public SimpleActorVisibility(Dimension sizeReference) {
        super(sizeReference, ExplorationStatus.UNKNOWN);
    }

    public void clear(ActorVisibility.ClearArg arg) {
        this.ensureSize();
        Mutable[] mutableArray = this._statusMap;
        int n = this._statusMap.length;
        int n2 = 0;
        while (n2 < n) {
            Mutable item = mutableArray[n2];
            if (arg.SetTo == null) {
                ExplorationStatus stat = (ExplorationStatus)item.Value;
                if (arg == ActorVisibility.ClearArg.ResetExplored) {
                    if (stat == ExplorationStatus.VISIBLE) {
                        item.Value = ExplorationStatus.FOW;
                    }
                } else if (arg == ActorVisibility.ClearArg.UnknownToExplored && stat == ExplorationStatus.UNKNOWN) {
                    item.Value = ExplorationStatus.FOW;
                }
            } else {
                item.Value = arg.SetTo;
            }
            ++n2;
        }
    }

    public void makeVisible(int index) {
        this.setStatus(index, ExplorationStatus.VISIBLE);
    }

    public void setVisible(int index) {
        this.setStatus(index, ExplorationStatus.VISIBLE);
    }

    public boolean setVisibleIfExplored(int x, int y) {
        if (this.inBounds(x, y)) {
            int index = this.getIndex(x, y);
            Mutable tile = this._statusMap[index];
            if (tile.Value == ExplorationStatus.FOW) {
                tile.Value = ExplorationStatus.VISIBLE;
                return true;
            }
        }
        return false;
    }

    public String serialize() {
        return Stream.of(this._statusMap).flatMap(Stream::of).map(x -> "" + ((ExplorationStatus)x.Value).Char).collect(Collectors.joining());
    }

    public void deserialize(String str) {
        int i = 0;
        while (i < this._statusMap.length) {
            this._statusMap[i].Value = i < str.length() ? ExplorationStatus.fromChar(str.charAt(i)) : ExplorationStatus.UNKNOWN;
            ++i;
        }
    }
}

