/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased;

import com.iosoft.iogame.tilebased.IGetExplorationStatus;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public enum ExplorationStatus implements IGetExplorationStatus
{
    UNKNOWN(false, false),
    FOW(true, false),
    VISIBLE(true, true);

    private static final ExplorationStatus[] Values;
    public final char Char = Integer.toString(this.ordinal()).charAt(0);
    public final boolean Explored;
    public final boolean SeeFull;

    static {
        Values = ExplorationStatus.values();
    }

    private ExplorationStatus(boolean explored, boolean seeFull) {
        this.Explored = explored;
        this.SeeFull = seeFull;
    }

    public static ExplorationStatus read(DataInputStream in) throws IOException {
        int ordinal = in.readUnsignedByte();
        if (ordinal >= Values.length) {
            throw new IOException("Invalid value '" + ordinal + "'");
        }
        return Values[ordinal];
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.ordinal());
    }

    public static ExplorationStatus fromChar(char c) {
        return Values[Integer.parseUnsignedInt(Character.toString(c))];
    }

    public static ExplorationStatus fromNum(int num) {
        return Values[num];
    }

    @Override
    public ExplorationStatus getExplorationStatus() {
        return this;
    }
}

