/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.tilebased;

import com.iosoft.helpers.Mutable;
import com.iosoft.iogame.tilebased.ExplorationStatus;
import com.iosoft.iogame.tilebased.IGetExplorationStatus;
import com.iosoft.iogame.tilebased.ITileVisibility;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ActorVisibility<T extends IGetExplorationStatus>
implements ITileVisibility<T> {
    protected final Dimension _sizeReference;
    protected Mutable<T>[] _statusMap;
    protected int _height;
    private final T _defaultValue;

    public ActorVisibility(Dimension sizeReference, T defaultValue) {
        this._sizeReference = sizeReference;
        this._defaultValue = defaultValue;
        this.ensureSize();
    }

    public void ensureSize() {
        this._height = this._sizeReference.height;
        int length = this._sizeReference.width * this._sizeReference.height;
        if (this._statusMap == null || length != this._statusMap.length || this._height != this._sizeReference.height) {
            this._statusMap = (Mutable[])IntStream.range(0, length).mapToObj(x -> new Mutable<T>(this._defaultValue)).toArray(Mutable[]::new);
        }
    }

    public void setStatus(int index, T status) {
        this.getTile((int)index).Value = status;
    }

    public void operation(Consumer<Mutable<T>> determineState) {
        Mutable<T>[] mutableArray = this._statusMap;
        int n = this._statusMap.length;
        int n2 = 0;
        while (n2 < n) {
            Mutable<T> item = mutableArray[n2];
            determineState.accept(item);
            ++n2;
        }
    }

    public <TTile> void operation(TTile[][] map, BiConsumer<TTile, Mutable<T>> determineState) {
        int i = 0;
        while (i < this._statusMap.length) {
            Mutable<T> status = this._statusMap[i];
            int x = i / this._height;
            int y = i % this._height;
            TTile tile = map[x][y];
            determineState.accept(tile, status);
            ++i;
        }
    }

    public <TTile> void operation(TTile[] map, BiConsumer<TTile, Mutable<T>> determineState) {
        int i = 0;
        while (i < this._statusMap.length) {
            determineState.accept(map[i], this._statusMap[i]);
            ++i;
        }
    }

    public <TTile> void operation(Iterator<TTile> map, BiConsumer<TTile, Mutable<T>> determineState) {
        int i = 0;
        while (i < this._statusMap.length) {
            determineState.accept(map.next(), this._statusMap[i]);
            ++i;
        }
    }

    public int getIndex(int x, int y) {
        return ActorVisibility.getIndex(x, y, this._height);
    }

    public static int getIndex(int x, int y, int height) {
        return x * height + y;
    }

    public boolean inBounds(int x, int y) {
        return x >= 0 && y >= 0 && y < this._height && this.getIndex(x, y) < this._statusMap.length;
    }

    private boolean inBounds(int index) {
        return index >= 0 && index < this._statusMap.length;
    }

    public boolean isVisible(int index) {
        return this.getExplorationStatus((int)index).SeeFull;
    }

    public boolean isExplored(int index) {
        return this.getExplorationStatus((int)index).Explored;
    }

    public boolean isFOW(int index) {
        return this.getExplorationStatus(index) == ExplorationStatus.FOW;
    }

    public ExplorationStatus getExplorationStatus(int index) {
        return this.getStatus(index).getExplorationStatus();
    }

    public Mutable<T> getTile(Point p) {
        Mutable<T> tileWrapper = this.tryGetTile(p.x, p.y);
        if (tileWrapper == null) {
            throw new IllegalArgumentException("Not in bounds (" + p + " vs h:" + this._height + ", l:" + this._statusMap.length + ")");
        }
        return this.getTile(this.getIndex(p.x, p.y));
    }

    public Mutable<T> getTile(int index) {
        if (!this.inBounds(index)) {
            throw new IllegalArgumentException("Not in bounds (" + index + " vs " + this._statusMap.length + ")");
        }
        return this._statusMap[index];
    }

    public Mutable<T> tryGetTile(int x, int y) {
        if (x < 0 || y < 0 || y >= this._height) {
            return null;
        }
        return this.getTile(this.getIndex(x, y));
    }

    public Mutable<T> tryGetTile(int index) {
        if (!this.inBounds(index)) {
            return null;
        }
        return this._statusMap[index];
    }

    public T getStatus(Point p) {
        return this.getStatus(p.x, p.y);
    }

    public T getStatus(int x, int y) {
        return (T)this.getStatus(this.getIndex(x, y));
    }

    @Override
    public T getStatus(int index) {
        return (T)(this.inBounds(index) ? (IGetExplorationStatus)this._statusMap[index].Value : this._defaultValue);
    }

    public Iterable<Mutable<T>> enumerateStatusMap() {
        return Arrays.asList(this._statusMap);
    }

    public Stream<Mutable<T>> statusMap() {
        return Stream.of(this._statusMap);
    }

    public static enum ClearArg {
        AllUnknown(ExplorationStatus.UNKNOWN),
        AllVisible(ExplorationStatus.VISIBLE),
        AllExplored(ExplorationStatus.FOW),
        UnknownToExplored(null),
        ResetExplored(null);

        public final ExplorationStatus SetTo;

        private ClearArg(ExplorationStatus setTo) {
            this.SetTo = setTo;
        }
    }
}

