/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.saveload;

import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.game.Handleable;
import com.iosoft.helpers.game.IIndexable;
import com.iosoft.helpers.game.MapLoadException;
import com.iosoft.helpers.game.ObjectHandle;
import com.iosoft.iogame.saveload.IKVArray;
import com.iosoft.iogame.saveload.IKVBase;
import com.iosoft.iogame.saveload.IKVRW;
import com.iosoft.iogame.saveload.IKVWriteItem;
import com.iosoft.iogame.saveload.IRWable;
import com.iosoft.iogame.saveload.ISaveable;
import java.awt.Dimension;
import java.awt.Point;
import java.util.PrimitiveIterator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface IKVWrite
extends IKVBase {
    public IKVWrite getWriteSub(String var1);

    default public void setPoint(String key, Point value) {
        this.setPoint(key, value.x, value.y);
        this.setString(key, String.valueOf(value.x) + "|" + value.y);
    }

    default public void setPoint(String key, Dimension value) {
        this.setPoint(key, value.width, value.height);
    }

    default public void setPoint(String key, int x, int y) {
        this.setString(key, String.valueOf(x) + "|" + y);
    }

    public void setString(String var1, String var2);

    default public void setBool(String key, boolean value) {
        this.setInt(key, value ? 1 : 0);
    }

    default public void setBoolean(String key, Boolean value) {
        this.setInt(key, value == null ? 2 : (value != false ? 1 : 0));
    }

    default public void setInt(String key, int value) {
        this.setString(key, Integer.toString(value));
    }

    default public void setLong(String key, long value) {
        this.setString(key, Long.toString(value));
    }

    default public void setChar(String key, char value) {
        this.setInt(key, value);
    }

    default public void setFloat(String key, float value) {
        this.setString(key, Float.toString(value));
    }

    default public void setDouble(String key, double value) {
        this.setString(key, Double.toString(value));
    }

    default public <T extends Enum<T>> void setEnum(String key, T value) {
        this.setInt(key, value == null ? -1 : value.ordinal());
    }

    default public <T extends Enum<T>> void setEnumString(String key, T value) {
        this.setString(key, value.name());
    }

    public IKVArray setArray(String var1);

    default public <T extends ISaveable> void setArray(String key, Iterable<T> iterable) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IKVArray node = this.setArray(key);){
            for (ISaveable item : iterable) {
                item.save(node.add());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public <T extends ISaveable> void setArray(String key, Stream<T> iterable) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IKVArray node = this.setArray(key);){
            for (ISaveable item : MiscLINQ.iter(iterable)) {
                item.save(node.add());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public <T> void setArray(String key, Iterable<T> iterable, BiConsumer<IKVWriteItem, T> saver) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (IKVArray node = this.setArray(key);){
            for (T item : iterable) {
                saver.accept(node.add(), (IKVWriteItem)item);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public <T> void setArray(String key, Stream<T> stream, BiConsumer<IKVWriteItem, T> saver) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (IKVArray node = this.setArray(key);){
            for (T item : MiscLINQ.iter(stream)) {
                saver.accept(node.add(), (IKVWriteItem)item);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public void setIntArray(String key, int[] array) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IKVArray node = this.setArray(key);){
            int i = 0;
            while (i < array.length) {
                node.add().setInt(array[i]);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public void setIntArray(String key, IntStream array) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IKVArray node = this.setArray(key);){
            PrimitiveIterator.OfInt iter = array.iterator();
            while (iter.hasNext()) {
                node.add().setInt(iter.nextInt());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public void setHandles(String key, Iterable<? extends Handleable> handles) {
        this.setIntArray(key, MiscLINQ.stream(handles).mapToInt(Handleable::getSaveID).toArray());
    }

    default public void setHandles2(String key, Iterable<ObjectHandle<?>> handles) {
        this.setIntArray(key, MiscLINQ.stream(handles).mapToInt(ObjectHandle::save).toArray());
    }

    default public void setHandle(String key, ObjectHandle<?> handle) {
        this.setInt(key, handle.save());
    }

    default public void setObject(String key, Handleable object) {
        this.setInt(key, object.getSaveID());
    }

    default public IKVRW writer() {
        return new IKVRW(){

            @Override
            public void rwPoint(String key, Point val) {
                IKVWrite.this.setPoint(key, val);
            }

            @Override
            public String rwString(String key, String val) {
                IKVWrite.this.setString(key, val);
                return val;
            }

            @Override
            public boolean rwBool(String key, boolean val) {
                IKVWrite.this.setBool(key, val);
                return val;
            }

            @Override
            public Boolean rwBoolean(String key, Boolean val) {
                IKVWrite.this.setBoolean(key, val);
                return val;
            }

            @Override
            public int rwInt(String key, int val) {
                IKVWrite.this.setInt(key, val);
                return val;
            }

            @Override
            public long rwLong(String key, long val) {
                IKVWrite.this.setLong(key, val);
                return val;
            }

            @Override
            public char rwChar(String key, char val) {
                IKVWrite.this.setChar(key, val);
                return val;
            }

            @Override
            public float rwFloat(String key, float val) {
                IKVWrite.this.setFloat(key, val);
                return val;
            }

            @Override
            public double rwDouble(String key, double val) {
                IKVWrite.this.setDouble(key, val);
                return val;
            }

            @Override
            public <T> T rwValue(String key, T val, boolean nullAllowed, T[] vals) {
                if (val instanceof Enum) {
                    Enum enumVal = (Enum)val;
                    IKVWrite.this.setEnum(key, enumVal);
                } else {
                    int idx;
                    if (val == null) {
                        if (!nullAllowed) {
                            throw new IllegalArgumentException("Null is not allowed but null was passed?");
                        }
                        idx = -1;
                    } else {
                        idx = val instanceof IIndexable ? ((IIndexable)val).getIndex() : MiscLINQ.indexOf(vals, val);
                        if (idx < 0) {
                            throw new IllegalArgumentException("Index cannot be negative");
                        }
                    }
                    IKVWrite.this.setInt(key, idx);
                }
                return val;
            }

            @Override
            public <T extends IRWable> T rwValue(String key, T val, boolean nullAllowed, Supplier<T> creator) {
                if (val != null) {
                    val.rw(IKVWrite.this.getWriteSub(key).writer());
                } else if (!nullAllowed) {
                    throw new IllegalArgumentException("Null is not allowed but null was passed?");
                }
                return val;
            }

            @Override
            public <T> T rwValueNotNullForce(String key, T val, T[] vals) throws MapLoadException {
                return this.rwValue(key, val, false, vals);
            }

            @Override
            public <T> T rwValueNotNull(String key, T val, T[] vals) {
                return this.rwValue(key, val, false, vals);
            }

            @Override
            public <T> T rwValueNotNull(String key, T val, T defVal, T[] vals) {
                return this.rwValue(key, val == null ? defVal : val, false, vals);
            }

            @Override
            public <T extends Enum<T>> T rwEnumString(String key, T val, boolean nullAllowed, Function<String, T> valueOf) {
                if (!nullAllowed && val == null) {
                    throw new IllegalArgumentException("Null enum value provided even though it's not allowed");
                }
                IKVWrite.this.setEnumString(key, val);
                return val;
            }

            @Override
            public int[] rwIntArray(String key, int[] val, int defVal) {
                IKVWrite.this.setIntArray(key, val);
                return val;
            }

            @Override
            public void rwObject(String key, ObjectHandle<?> handle) {
                IKVWrite.this.setInt(key, handle.save());
            }
        };
    }
}

