/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.iogame.saveload;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.game.Handleable;
import com.iosoft.helpers.game.MapLoadException;
import com.iosoft.helpers.game.ObjectHandle;
import com.iosoft.helpers.game.ObjectList;
import com.iosoft.iogame.saveload.IKVBase;
import com.iosoft.iogame.saveload.IKVRW;
import com.iosoft.iogame.saveload.IKVReadItem;
import com.iosoft.iogame.saveload.ILoadable;
import com.iosoft.iogame.saveload.IRWable;
import com.iosoft.iogame.saveload.NullKVRead;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface IKVRead
extends IKVBase {
    public IKVRead tryGetReadSub(String var1);

    default public IKVRead getReadSub(String key) {
        IKVRead node = this.tryGetReadSub(key);
        return node == null ? NullKVRead.Instance : node;
    }

    default public boolean getPoint(String key, Point def) {
        String val = this.tryGetString(key);
        if (val == null) {
            return false;
        }
        int idx = val.indexOf(124);
        if (idx == -1) {
            def.x = Misc.getAsInt(val, def.x);
        } else {
            def.x = Misc.getAsInt(val.substring(0, idx), def.x);
            def.y = Misc.getAsInt(val.substring(idx + 1), def.y);
        }
        return true;
    }

    default public boolean getPoint(String key, Dimension def) {
        Point point = new Point();
        if (this.getPoint(key, point)) {
            def.width = point.x;
            def.height = point.y;
            return true;
        }
        return false;
    }

    public String tryGetString(String var1);

    default public String getString(String key, String def) {
        String val = this.tryGetString(key);
        return val == null ? def : val;
    }

    default public boolean getBool(String key, boolean def) {
        String val = this.tryGetString(key);
        return val == null ? def : Misc.getAsInt(val) == 1;
    }

    default public Boolean getBoolean(String key, Boolean def) {
        String val = this.tryGetString(key);
        if (val == null) {
            return def;
        }
        int intVal = Misc.getAsInt(val);
        return intVal == 1 ? Boolean.TRUE : (intVal == 0 ? Boolean.FALSE : null);
    }

    default public int getInt(String key, int def) {
        String val = this.tryGetString(key);
        return val == null ? def : Misc.getAsInt(val, def);
    }

    default public long getLong(String key, long def) {
        String val = this.tryGetString(key);
        return val == null ? def : Misc.getAsLong(val, def);
    }

    default public char getChar(String key, char def) {
        int value = this.getInt(key, def);
        return value < 0 || value > 65535 ? def : (char)value;
    }

    default public float getFloat(String key, float def) {
        String val = this.tryGetString(key);
        return val == null ? def : Misc.getAsFloat(val, def);
    }

    default public double getDouble(String key, double def) {
        String val = this.tryGetString(key);
        return val == null ? def : Misc.getAsDouble(val, def);
    }

    default public <T> T getValue(String key, T def, boolean nullAllowed, T[] vals) {
        int intValue = this.getInt(key, -2);
        if (intValue == -2 || intValue < 0 && !nullAllowed) {
            return def;
        }
        if (intValue == -1) {
            return null;
        }
        if (intValue < 0 || intValue >= vals.length) {
            throw new IllegalArgumentException("Invalid index '" + intValue + "'");
        }
        return vals[intValue];
    }

    default public <T extends Enum<T>> T getEnumString(String key, T def, boolean nullAllowed, Function<String, T> valueOf) {
        String name = this.getString(key, null);
        if (!Misc.isNullOrEmpty(name)) {
            try {
                return (T)((Enum)valueOf.apply(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!nullAllowed && def == null) {
            throw new IllegalArgumentException("Def value is null even though null is not allowed");
        }
        return def;
    }

    public Collection<IKVReadItem> tryGetArray(String var1);

    default public Collection<IKVReadItem> getArray(String key) {
        Collection<IKVReadItem> array = this.tryGetArray(key);
        if (array == null) {
            return Collections.emptyList();
        }
        return array;
    }

    default public <T> void getArray(String key, Collection<T> list, Function<IKVReadItem, T> reader) {
        list.clear();
        for (IKVReadItem item : this.getArray(key)) {
            list.add(reader.apply(item));
        }
    }

    default public <T> void getArray(String key, ObjIntConsumer<IKVReadItem> reader) {
        int i = 0;
        for (IKVReadItem item : this.getArray(key)) {
            reader.accept(item, i++);
        }
    }

    default public <T extends ILoadable> void getArray(String key, Collection<T> list, Supplier<T> creator) {
        list.clear();
        for (IKVReadItem item : this.getArray(key)) {
            ILoadable value = (ILoadable)creator.get();
            value.load(item);
            list.add(value);
        }
    }

    default public <T> ArrayList<T> tryGetList(String key, Function<IKVReadItem, T> reader) {
        Collection<IKVReadItem> array = this.tryGetArray(key);
        if (array == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (IKVReadItem item : array) {
            list.add(reader.apply(item));
        }
        return list;
    }

    default public int[] getIntArray(String key) {
        int[] arr = this.tryGetIntArray(key, 0);
        return arr == null ? Misc.EMPTYINTS : arr;
    }

    default public int[] tryGetIntArray(String key, int defVal) {
        Collection<IKVReadItem> arr = this.tryGetArray(key);
        if (arr == null) {
            return null;
        }
        return arr.stream().mapToInt(x -> x.getInt(defVal)).toArray();
    }

    default public <T extends Handleable> Stream<ObjectHandle<T>> tryStreamHandles(String key) {
        int[] ints = this.tryGetIntArray(key, -1);
        if (ints == null) {
            return null;
        }
        return IntStream.of(ints).mapToObj(x -> {
            ObjectHandle handle = new ObjectHandle();
            handle.load(x);
            return handle;
        });
    }

    default public <T extends Handleable> Stream<T> streamObjects(String key, IntFunction<T> resolver) {
        int[] ints = this.getIntArray(key);
        return IntStream.of(ints).mapToObj(resolver).filter(x -> x != null);
    }

    default public <T extends Handleable> void getObjects(String key, IntFunction<T> resolver, Collection<T> list) {
        this.streamObjects(key, resolver).forEachOrdered(list::add);
    }

    default public <T extends Handleable> List<ObjectHandle<T>> getHandles(String key) {
        Stream stream = this.tryStreamHandles(key);
        if (stream == null) {
            return Collections.emptyList();
        }
        return stream.collect(Collectors.toList());
    }

    default public <T extends Handleable> boolean tryGetHandles(String key, ObjectList<T> list) {
        int[] ints = this.tryGetIntArray(key, -1);
        if (ints == null) {
            return false;
        }
        list.clear();
        list.load(ints);
        return true;
    }

    default public void getHandle(String key, ObjectHandle<?> handle) {
        handle.load(this.getInt(key, -1));
    }

    default public IKVRW reader() {
        return new IKVRW(){

            @Override
            public void rwPoint(String key, Point val) {
                IKVRead.this.getPoint(key, val);
            }

            @Override
            public String rwString(String key, String val) {
                return IKVRead.this.getString(key, val);
            }

            @Override
            public boolean rwBool(String key, boolean val) {
                return IKVRead.this.getBool(key, val);
            }

            @Override
            public Boolean rwBoolean(String key, Boolean val) {
                return IKVRead.this.getBoolean(key, val);
            }

            @Override
            public int rwInt(String key, int val) {
                return IKVRead.this.getInt(key, val);
            }

            @Override
            public long rwLong(String key, long val) {
                return IKVRead.this.getLong(key, val);
            }

            @Override
            public char rwChar(String key, char val) {
                return IKVRead.this.getChar(key, val);
            }

            @Override
            public float rwFloat(String key, float val) {
                return IKVRead.this.getFloat(key, val);
            }

            @Override
            public double rwDouble(String key, double val) {
                return IKVRead.this.getDouble(key, val);
            }

            @Override
            public <T> T rwValue(String key, T val, boolean nullAllowed, T[] vals) {
                return IKVRead.this.getValue(key, val, nullAllowed, vals);
            }

            @Override
            public <T extends IRWable> T rwValue(String key, T val, boolean nullAllowed, Supplier<T> creator) {
                IKVRead sub = IKVRead.this.tryGetReadSub(key);
                if (sub == null) {
                    if (nullAllowed) {
                        return null;
                    }
                    sub = NullKVRead.Instance;
                }
                IRWable obj = (IRWable)creator.get();
                obj.rw(sub.reader());
                return (T)obj;
            }

            @Override
            public <T> T rwValueNotNullForce(String key, T val, T[] vals) throws MapLoadException {
                T result = this.rwValue(key, val, false, vals);
                if (result == null && val == null) {
                    throw new MapLoadException("Key '" + key + "' was not found");
                }
                return result;
            }

            @Override
            public <T> T rwValueNotNull(String key, T val, T[] vals) {
                return this.rwValueNotNull(key, val, val, vals);
            }

            @Override
            public <T> T rwValueNotNull(String key, T val, T defVal, T[] vals) {
                return this.rwValue(key, defVal == null ? val : defVal, false, vals);
            }

            @Override
            public <T extends Enum<T>> T rwEnumString(String key, T val, boolean nullAllowed, Function<String, T> creator) {
                return IKVRead.this.getEnumString(key, val, nullAllowed, creator);
            }

            @Override
            public int[] rwIntArray(String key, int[] val, int defVal) {
                int[] arr = IKVRead.this.tryGetIntArray(key, defVal);
                return arr == null ? val : arr;
            }

            @Override
            public void rwObject(String key, ObjectHandle<?> handle) {
                handle.load(IKVRead.this.getInt(key, -1));
            }
        };
    }
}

